/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.favorite.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.favorite.condition.FavoriteCondition;
import com.thebeastshop.pegasus.component.favorite.dao.FavoriteEntityMapper;
import com.thebeastshop.pegasus.component.favorite.domain.Favorite;
import com.thebeastshop.pegasus.component.favorite.model.FavoriteEntity;
import com.thebeastshop.pegasus.component.favorite.model.FavoriteEntityExample;
import com.thebeastshop.pegasus.component.favorite.service.FavoriteService;
import com.thebeastshop.pegasus.component.member.service.BaseService;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.support.enums.FavoriteExtType;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.page.Page;
import com.thebeastshop.support.page.Pagination;
import com.thebeastshop.support.util.EnumUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.session.RowBounds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FavoriteServiceImpl
extends BaseService
implements FavoriteService {
    @Autowired
    private FavoriteEntityMapper mapper;

    private void fillCriteria(FavoriteEntityExample.Criteria criteria, FavoriteCondition condition) {
        if (condition.getOwnerId() != null) {
            criteria.andOwnerIdEqualTo(condition.getOwnerId());
        }
        if (condition.getExtType() != null) {
            criteria.andExtTypeEqualTo(condition.getExtType().getId());
        }
        if (condition.getExtId() != null) {
            criteria.andExtIdEqualTo(condition.getExtId());
        }
    }

    private Favorite entity2Domain(FavoriteEntity entity) {
        if (entity != null) {
            Favorite domain = (Favorite)BeanUtil.buildFrom((Object)entity, Favorite.class);
            domain.setExtType((FavoriteExtType)EnumUtil.valueOf((Comparable)entity.getExtType(), FavoriteExtType.class));
            return domain;
        }
        return null;
    }

    private List<Favorite> entity2Domain(List<FavoriteEntity> entities) {
        ArrayList domains = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(entities)) {
            for (FavoriteEntity entity : entities) {
                if (entity == null) continue;
                domains.add(this.entity2Domain(entity));
            }
        }
        return domains;
    }

    private FavoriteEntity domain2Entity(Favorite domain) {
        if (domain != null) {
            FavoriteEntity entity = (FavoriteEntity)BeanUtil.buildFrom((Object)domain, FavoriteEntity.class);
            entity.setExtType(domain.getExtType().getId());
            return entity;
        }
        return null;
    }

    @Override
    public Favorite create(Favorite obj) {
        if (this.checkIsExist(obj)) {
            throw new WrongArgException("\u5df2\u6536\u85cf", String.format("member{id:%s}.favorite{extType:%s,extId:%s} exist", obj.getOwnerId(), obj.getExtType(), obj.getExtId()), (Object)obj.getExtId());
        }
        this.logger.info("Creating Favorite: {}", (Object)obj);
        obj.setCreateTime(new Date());
        FavoriteEntity entity = this.domain2Entity(obj);
        if (entity != null) {
            int count = this.mapper.insert(entity);
            obj.setId(entity.getId());
            this.logger.info("Created Favorite: {}", (Object)obj);
            if (count > 0) {
                return obj;
            }
        }
        return null;
    }

    @Override
    public boolean delete(Long id) {
        this.logger.info("Deleting Favorite: {}", (Object)id);
        int count = this.mapper.deleteByPrimaryKey(id);
        this.logger.info("Deleted Favorite: {}", (Object)id);
        return count > 0;
    }

    @Override
    public boolean batchDelete(List<Long> itemIds, FavoriteExtType favoriteExtType, Long memberId) {
        int c;
        FavoriteEntityExample example = new FavoriteEntityExample();
        FavoriteEntityExample.Criteria criteria = example.createCriteria();
        if (favoriteExtType != null) {
            criteria.andExtTypeEqualTo(favoriteExtType.getId());
        }
        if (memberId != null) {
            criteria.andOwnerIdEqualTo(memberId);
        }
        if (CollectionUtils.isNotEmpty(itemIds)) {
            criteria.andExtIdIn((List)itemIds);
        }
        return (c = this.mapper.deleteByExample(example)) > 0;
    }

    @Override
    public Favorite getById(Long id) {
        return this.entity2Domain(this.mapper.selectByPrimaryKey(id));
    }

    @Override
    public List<Favorite> getByCondition(FavoriteCondition condition) {
        FavoriteEntityExample example = new FavoriteEntityExample();
        this.fillCriteria(example.createCriteria(), condition);
        example.setOrderByClause(String.format("%s %s", "create_time", "desc"));
        return this.entity2Domain(this.mapper.selectByExample(example));
    }

    @Override
    public Page<Favorite> find(FavoriteCondition condition, Integer offset, Integer limit) {
        Page page = new Page(new Pagination(offset, limit));
        FavoriteEntityExample example = new FavoriteEntityExample();
        this.fillCriteria(example.createCriteria(), condition);
        example.setOrderByClause(String.format("%s %s", "create_time", "desc"));
        int total = this.mapper.countByExample(example);
        if (total > 0) {
            page.setTotal(Integer.valueOf(total));
            List<FavoriteEntity> entityList = this.mapper.selectByExampleWithRowbounds(example, new RowBounds(offset.intValue(), limit.intValue()));
            page.setItems(this.entity2Domain(entityList));
        }
        return page;
    }

    @Override
    public boolean checkIsExist(Favorite obj) {
        FavoriteCondition condition = new FavoriteCondition();
        condition.setOwnerId(obj.getOwnerId());
        condition.setExtType(obj.getExtType());
        condition.setExtId(obj.getExtId());
        return CollectionUtils.isNotEmpty(this.getByCondition(condition));
    }

    @Override
    public Collection<Favorite> create(Collection<Favorite> favorites) {
        ArrayList list = Lists.newArrayList();
        for (Favorite favorite : favorites) {
            list.add(this.create(favorite));
        }
        return list;
    }
}

