/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.delivery.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.delivery.dao.DeliveryDistrictDao;
import com.thebeastshop.pegasus.component.delivery.enums.DeliveryType;
import com.thebeastshop.pegasus.component.delivery.service.DeliveryDistrictService;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.model.CommDistrict;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeliveryDistrictServiceImpl
implements DeliveryDistrictService {
    private static List<String> fedexNotDeliveryAreas = new ArrayList<String>();
    @Autowired
    private DeliveryDistrictDao dao;

    @Override
    public boolean checkDelivery(DeliveryType type, long districtId) {
        if (type != null) {
            List<Long> districtIds;
            ArrayList types = Lists.newArrayList((Object[])new DeliveryType[]{type});
            if (type.equals((Object)DeliveryType.FEDEX)) {
                CommDistrict district = PegasusUtilFacade.getInstance().findDistrictById(Long.valueOf(districtId));
                if (fedexNotDeliveryAreas.contains(district.getName())) {
                    return false;
                }
                types.add(DeliveryType.SELF);
            }
            if ((districtIds = this.dao.getDistrictIds(types)).contains(districtId)) {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        DeliveryDistrictService service = ComponentServiceLoader.getBean(DeliveryDistrictService.class);
        System.out.println(service.checkDelivery(DeliveryType.FEDEX, 1058L));
    }

    static {
        fedexNotDeliveryAreas.add("\u77f3\u666f\u5c71\u533a");
        fedexNotDeliveryAreas.add("\u95e8\u5934\u6c9f\u533a");
        fedexNotDeliveryAreas.add("\u623f\u5c71\u533a");
        fedexNotDeliveryAreas.add("\u660c\u5e73\u533a");
        fedexNotDeliveryAreas.add("\u5927\u5174\u533a");
        fedexNotDeliveryAreas.add("\u6000\u67d4\u533a");
        fedexNotDeliveryAreas.add("\u5e73\u8c37\u533a");
        fedexNotDeliveryAreas.add("\u5bc6\u4e91\u53bf");
        fedexNotDeliveryAreas.add("\u5ef6\u5e86\u53bf");
    }
}

