/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.compatible.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.compatible.old.DeliverableConstant;
import com.thebeastshop.pegasus.component.compatible.old.DeliverableDateDTO;
import com.thebeastshop.pegasus.component.compatible.old.ResponseVO;
import com.thebeastshop.pegasus.component.compatible.service.OldDeliverableService;
import com.thebeastshop.pegasus.component.delivery.domain.Deliverable;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.support.util.HttpUtil;
import com.thebeastshop.support.util.JsonUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OldDeliverableServiceImpl
implements OldDeliverableService {
    private static final Logger logger = LoggerFactory.getLogger(OldDeliverableServiceImpl.class);

    private Deliverable _callOldGetDeliverable(Long addressId, List<PsSkuVO> skus) {
        Deliverable deliverableInfo = null;
        if (addressId != null && CollectionUtils.isNotEmpty(skus)) {
            try {
                ResponseVO responseVO;
                String url = DeliverableConstant.GET_ALL_ADDRESSVO;
                DeliverableDateDTO deliverableDateDTO = new DeliverableDateDTO();
                deliverableDateDTO.setAddress(addressId);
                ArrayList skuCodes = Lists.newArrayList();
                for (PsSkuVO sku : skus) {
                    skuCodes.add(sku.getSkuCode());
                }
                deliverableDateDTO.setSkuIds(skuCodes);
                String dddressStr = JSON.toJSONString((Object)deliverableDateDTO);
                logger.info("\u63a5\u53e3\u540d={}", (Object)url);
                logger.info("\u53d1\u9001\u7684\u53c2\u6570 orderAddressStr={}", (Object)dddressStr);
                Date start = new Date();
                String resultStr = HttpUtil.doJsonPost((String)url, (String)dddressStr, (String)DeliverableConstant.CHART_SET);
                Date end = new Date();
                logger.info("\u8bf7\u6c42\u5b98\u65b9\u670d\u52a1\u5668\u83b7\u67e5\u8be2\u914d\u9001\u4fe1\u606f\u7684\u8bbf\u95ee\u65f6\u95f4\uff1a{}\u6beb\u79d2", (Object)(end.getTime() - start.getTime()));
                logger.info("\u63a5\u53d7\u7684\u53c2\u6570 resultStr={}", (Object)resultStr);
                if (StringUtils.isNotBlank((CharSequence)resultStr) && null != (responseVO = (ResponseVO)JsonUtil.alibabaToObject((String)resultStr, ResponseVO.class)) && responseVO.getMeta().getErrno() == 0) {
                    deliverableInfo = (Deliverable)JsonUtil.alibabaToObject((String)responseVO.getResult().getData().toString(), Deliverable.class);
                }
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u53ef\u4ee5\u7528\u7684\u65f6\u95f4 \u5f02\u5e38:{}", (Throwable)e);
            }
        }
        return deliverableInfo;
    }

    @Override
    public Deliverable getDeliverable(Long addressId, List<PsSkuVO> skus) {
        logger.info("====\u67e5\u8be2\u914d\u9001\u4fe1\u606f \u53c2\u6570 address={}, skus={}", (Object)addressId, skus);
        Deliverable deliverableInfo = this._callOldGetDeliverable(addressId, skus);
        logger.info("====\u67e5\u8be2\u914d\u9001\u4fe1\u606f \u8fd4\u56de\u503c deliverableDateVOs={}", (Object)deliverableInfo);
        return deliverableInfo;
    }
}

