/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.compatible.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.compatible.ResourceWithCode;
import com.thebeastshop.pegasus.component.compatible.service.IDCodeTransferService;
import com.thebeastshop.pegasus.component.member.dao.MemberEntityMapper;
import com.thebeastshop.pegasus.component.member.model.MemberEntity;
import com.thebeastshop.pegasus.component.member.model.MemberEntityExample;
import com.thebeastshop.pegasus.merchandise.cond.PsProductCond;
import com.thebeastshop.pegasus.merchandise.cond.PsSkuCond;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IDCodeTransferServiceImpl
implements IDCodeTransferService {
    @Autowired
    private McPsSkuService mcPsSkuService;
    @Autowired
    private McPsProductService mcPsProductService;
    @Autowired
    private MemberEntityMapper memberMapper;
    @Autowired
    private McOpChannelService mcOpChannelService;

    @Override
    public String getCode(ResourceWithCode resourceWithCode, long id) {
        if (resourceWithCode == ResourceWithCode.MEMBER) {
            MemberEntity entity = this.memberMapper.selectByPrimaryKey(id);
            return entity.getCode();
        }
        if (resourceWithCode == ResourceWithCode.SKU) {
            PsSkuCond cond = new PsSkuCond();
            cond.setSkuId(Long.valueOf(id));
            List skus = this.mcPsSkuService.findByCond(cond);
            return ((PsSkuVO)skus.get(0)).getSkuCode();
        }
        if (resourceWithCode == ResourceWithCode.PRODUCT) {
            PsProductVO prod = this.mcPsProductService.findByProdId(Long.valueOf(id));
            return prod.getCode();
        }
        if (resourceWithCode == ResourceWithCode.CHANNEL) {
            OpChannelVO opChannel = this.mcOpChannelService.findById(Long.valueOf(id));
            return opChannel.getCode();
        }
        if (resourceWithCode == ResourceWithCode.WAREHOUSE) {
            // empty if block
        }
        return null;
    }

    @Override
    public List<String> getCodes(ResourceWithCode resourceWithCode, List<Long> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            ArrayList rt = Lists.newArrayListWithExpectedSize((int)ids.size());
            if (resourceWithCode == ResourceWithCode.PRODUCT) {
                PsProductCond cond = new PsProductCond();
                ArrayList idsStr = Lists.newArrayListWithExpectedSize((int)ids.size());
                for (Long id : ids) {
                    idsStr.add(id.toString());
                }
                cond.setIds((List)idsStr);
                List products = this.mcPsProductService.findByCond(cond);
                for (PsProductVO psProductVO : products) {
                    rt.add(psProductVO.getCode());
                }
            }
            return rt;
        }
        return null;
    }

    @Override
    public Long getId(ResourceWithCode resourceWithCode, String code) {
        List products;
        if (resourceWithCode == ResourceWithCode.MEMBER) {
            MemberEntityExample example = new MemberEntityExample();
            example.createCriteria().andCodeEqualTo(code);
            List<MemberEntity> entities = this.memberMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(entities)) {
                return entities.get(0).getId();
            }
        } else if (resourceWithCode == ResourceWithCode.PRODUCT && CollectionUtils.isNotEmpty((Collection)(products = this.mcPsProductService.findByProdCode(code)))) {
            return Long.valueOf(((PsProductVO)products.get(0)).getId());
        }
        return null;
    }

    @Override
    public List<Long> getIds(ResourceWithCode resourceWithCode, List<String> codes) {
        if (CollectionUtils.isNotEmpty(codes)) {
            ArrayList rt = Lists.newArrayListWithExpectedSize((int)codes.size());
            if (resourceWithCode == ResourceWithCode.PRODUCT) {
                PsProductCond cond = new PsProductCond();
                cond.setCodes(codes);
                List products = this.mcPsProductService.findByCond(cond);
                for (PsProductVO psProductVO : products) {
                    rt.add(Long.valueOf(psProductVO.getId()));
                }
            }
            return rt;
        }
        return null;
    }
}

