/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.channel.dao.impl;

import com.thebeastshop.pegasus.component.channel.Channel;
import com.thebeastshop.pegasus.component.channel.dao.ChannelDao;
import com.thebeastshop.pegasus.component.channel.dao.mapper.ChannelEntityMapper;
import com.thebeastshop.pegasus.component.channel.enums.ChannelType;
import com.thebeastshop.pegasus.component.channel.model.ChannelEntity;
import com.thebeastshop.pegasus.component.channel.model.ChannelEntityExample;
import com.thebeastshop.pegasus.component.channel.support.DefaultChannelImpl;
import com.thebeastshop.support.mark.Type;
import com.thebeastshop.support.util.EnumUtil;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ChannelDaoImpl
implements ChannelDao {
    @Autowired
    private ChannelEntityMapper mapper;

    private Channel entity2Domain(ChannelEntity entity) {
        if (entity != null) {
            DefaultChannelImpl domain = new DefaultChannelImpl();
            domain.setCode(entity.getCode());
            domain.setCreateTime(entity.getCreateTime());
            domain.setId(entity.getId());
            domain.setName(entity.getName());
            domain.setType((Type)EnumUtil.valueOf((Comparable)entity.getType(), ChannelType.class));
            domain.setWarehouseCode(entity.getWarehouseForSales());
            return domain;
        }
        return null;
    }

    @Override
    public Channel getById(long id) {
        return this.entity2Domain(this.mapper.selectByPrimaryKey(id));
    }

    @Override
    public Channel getByCode(String code) {
        ChannelEntityExample example = new ChannelEntityExample();
        example.createCriteria().andCodeEqualTo(code);
        List<ChannelEntity> list = this.mapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
            return this.entity2Domain(list.get(0));
        }
        return null;
    }
}

