/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.category.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.category.CampaignCategory;
import com.thebeastshop.pegasus.component.category.Category;
import com.thebeastshop.pegasus.component.category.dao.CategoryDao;
import com.thebeastshop.pegasus.component.category.service.CategoryService;
import com.thebeastshop.support.exception.NoSuchResourceException;
import com.thebeastshop.support.util.IdUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CategoryServiceImpl
implements CategoryService {
    @Autowired
    private CategoryDao categoryDao;

    @Override
    public Collection<Category> list() {
        return this.categoryDao.list();
    }

    @Override
    public Category getById(Long id) {
        return this.categoryDao.getById(id);
    }

    @Override
    public void modify(Category one) {
        this.categoryDao.modify(one);
    }

    @Override
    public void del(Category category) {
        this.categoryDao.del(category);
    }

    @Override
    public Category create(Category one) {
        return this.categoryDao.create(one);
    }

    @Override
    public Category checkOne(Long id) {
        Category one = this.getById(id);
        if (one == null) {
            throw new NoSuchResourceException("\u5206\u7c7b", (Object)id);
        }
        return one;
    }

    @Override
    public void del(Long id) {
        Category one = this.getById(id);
        if (one != null) {
            this.del(one);
        }
    }

    @Override
    public void del(Collection<Category> categories) {
        for (Category category : categories) {
            this.del(category);
        }
    }

    @Override
    public Collection<Category> directChildren(Category one) {
        return this.categoryDao.directChildren(one);
    }

    @Override
    public Collection<Category> subordinates(Category one) {
        return this.categoryDao.subordinates(one);
    }

    @Override
    public boolean isRoot(Category one) {
        return one.getParentId() == null;
    }

    @Override
    public Category getParent(Category one) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.debug(this.getClass().getSimpleName() + ".getParent(Category) start:" + one);
        Category rt = this.isRoot(one) ? null : this.getById(one.getParentId());
        logger.debug(this.getClass().getSimpleName() + ".getParent(Category) end:" + rt);
        return rt;
    }

    @Override
    public List<Category> ancestors(Category one) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.debug(this.getClass().getSimpleName() + ".ancestors(Category) start:" + one);
        ArrayList rt = Lists.newArrayList();
        Category o = one;
        while (o != null) {
            Category parent = this.getParent(o);
            if (parent == null) continue;
            rt.add(parent);
            o = parent;
        }
        logger.debug(this.getClass().getSimpleName() + ".ancestors(Category) end:" + rt);
        return rt;
    }

    @Override
    public boolean isAncestor(Category bigger, Category smaller) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.debug(this.getClass().getSimpleName() + ".isAncestor start:" + bigger + ", " + smaller);
        List<Category> ancestors = this.ancestors(smaller);
        boolean b = IdUtil.toIds(ancestors).contains(bigger.getId());
        logger.debug(this.getClass().getSimpleName() + ".isAncestor end:" + b);
        return b;
    }

    @Override
    public List<CampaignCategory> getCategoryByCampaignId(Long campaignId, Boolean temp) {
        return this.categoryDao.getCategoryByCampaignId(campaignId, temp);
    }

    @Override
    public List<CampaignCategory> getAllCategories() {
        return this.categoryDao.getAllCategories();
    }

    @Override
    public List<Long> getTreeNode(List<Long> categories) {
        return this.categoryDao.getTreeNode(categories);
    }

    @Override
    public String getCodeById(Long bindingId) {
        return this.categoryDao.getCodeById(bindingId);
    }

    @Override
    public List<String> getCategoryIdsByCampaignId(Long campaignId, Boolean temp) {
        return this.categoryDao.getCategoryIdsByCampaignId(campaignId, temp);
    }
}

