/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.category.dao.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.category.CampaignCategory;
import com.thebeastshop.pegasus.component.category.Category;
import com.thebeastshop.pegasus.component.category.dao.CategoryDao;
import com.thebeastshop.pegasus.component.category.dao.mapper.CategoryEntityMapper;
import com.thebeastshop.pegasus.component.category.model.CategoryEntity;
import com.thebeastshop.pegasus.component.category.model.CategoryEntityExample;
import com.thebeastshop.pegasus.component.category.support.DefaultCampaignCategory;
import com.thebeastshop.pegasus.component.category.support.OldModelAdaptorCategory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CategoryDaoImpl
implements CategoryDao {
    @Autowired
    private CategoryEntityMapper categoryMapper;

    private OldModelAdaptorCategory adapt(CategoryEntity entity) {
        return new OldModelAdaptorCategory(entity);
    }

    @Override
    public Category create(Category one) {
        CategoryEntity oldModel = new CategoryEntity();
        oldModel.setParentId(one.getId());
        oldModel.setInUse(OldModelAdaptorCategory.validToInUse(one));
        oldModel.setName(one.getName());
        oldModel.setParentId(one.getParentId());
        this.categoryMapper.insert(oldModel);
        return this.adapt(oldModel);
    }

    @Override
    public void modify(Category one) {
        CategoryEntity exist = new CategoryEntity();
        exist.setId(one.getId());
        exist.setInUse(OldModelAdaptorCategory.validToInUse(one));
        exist.setName(one.getName());
        exist.setParentId(one.getParentId());
        this.categoryMapper.updateByPrimaryKey(exist);
    }

    @Override
    public void del(Category category) throws UnsupportedOperationException {
        this.categoryMapper.deleteByPrimaryKey(category.getId());
    }

    @Override
    public Category getById(Long id) {
        CategoryEntity pcsSkuCategory = this.categoryMapper.selectByPrimaryKey(id);
        return this.adapt(pcsSkuCategory);
    }

    @Override
    public Collection<Category> list() {
        List<CategoryEntity> entities = this.categoryMapper.selectByExample(new CategoryEntityExample());
        ArrayList list = Lists.newArrayList();
        for (CategoryEntity entity : entities) {
            list.add(this.adapt(entity));
        }
        return list;
    }

    private static CampaignCategory entity2Domain(CategoryEntity entity) {
        DefaultCampaignCategory domain = new DefaultCampaignCategory();
        domain.setId(String.valueOf(null == entity.getId() ? "" : entity.getId()));
        domain.setName(entity.getName());
        domain.setParent(String.valueOf(0 == entity.getIsLeaf() ? "root" : entity.getParentId()));
        if (0 == entity.getIsLeaf()) {
            domain.setType("first");
        } else {
            domain.setType("second");
        }
        return domain;
    }

    private void buildTreeNodeUp(List<CampaignCategory> list, CategoryEntity entity) {
        list.add(CategoryDaoImpl.entity2Domain(entity));
        if (1 == entity.getIsLeaf() && null != entity.getParentId()) {
            Boolean isExist = false;
            Long parentId = entity.getParentId();
            if (null != list) {
                for (CampaignCategory item : list) {
                    if (!item.getId().equals(String.valueOf(parentId))) continue;
                    isExist = true;
                    break;
                }
            }
            if (!isExist.booleanValue()) {
                this.buildTreeNodeUp(list, this.categoryMapper.selectByPrimaryKey(entity.getParentId()));
            }
        }
    }

    private void buildTreeNodeDown(List<CampaignCategory> list, CategoryEntity entity) {
        list.add(CategoryDaoImpl.entity2Domain(entity));
        if (1 != entity.getIsLeaf()) {
            CategoryEntityExample example = new CategoryEntityExample();
            example.createCriteria().andParentIdEqualTo(entity.getId());
            for (CategoryEntity categoryEntity : this.categoryMapper.selectByExample(example)) {
                this.buildTreeNodeDown(list, categoryEntity);
            }
        }
    }

    @Override
    public List<CampaignCategory> getCategoryByCampaignId(Long campaignId, Boolean temp) {
        List<CategoryEntity> entities = this.categoryMapper.getCategoryByCampaignId(campaignId, temp != false ? 1 : 0);
        ArrayList list = Lists.newArrayList();
        for (CategoryEntity entity : entities) {
            this.buildTreeNodeUp(list, entity);
        }
        return list;
    }

    @Override
    public List<CampaignCategory> getAllCategories() {
        List<CategoryEntity> entities = this.categoryMapper.getAllLeafCategory();
        ArrayList lists = Lists.newArrayList();
        for (CategoryEntity entity : entities) {
            this.buildTreeNodeUp(lists, entity);
        }
        return lists;
    }

    private void buildLastTreeNode(List<Long> result, CategoryEntity entity) {
        if (null != entity) {
            if (entity.getIsLeaf() == 1) {
                result.add(entity.getId());
            } else {
                CategoryEntityExample example = new CategoryEntityExample();
                example.createCriteria().andParentIdEqualTo(entity.getId());
                for (CategoryEntity categoryEntity : this.categoryMapper.selectByExample(example)) {
                    this.buildLastTreeNode(result, categoryEntity);
                }
            }
        }
    }

    @Override
    public List<Long> getTreeNode(List<Long> categories) {
        if (null == categories || categories.isEmpty()) {
            return null;
        }
        List<CategoryEntity> entities = this.categoryMapper.getCategoryByIds(categories);
        ArrayList result = Lists.newArrayList();
        for (CategoryEntity entity : entities) {
            if (null == entity || 1 != entity.getIsLeaf()) continue;
            result.add(entity.getId());
        }
        return result;
    }

    @Override
    public Collection<Category> directChildren(Category one) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.debug(this.getClass().getSimpleName() + ".directChildren(Category) start:" + one);
        Long id = one.getId();
        Collection<Category> list = this.list();
        ArrayList rt = Lists.newArrayList();
        for (Category category : list) {
            if (!id.equals(category.getParentId())) continue;
            rt.add(category);
        }
        logger.debug(this.getClass().getSimpleName() + ".directChildren(Category) end:" + rt);
        return rt;
    }

    @Override
    public Collection<Category> subordinates(Category one) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.debug(this.getClass().getSimpleName() + ".subordinates(Category) start:" + one);
        ArrayList rt = Lists.newArrayList();
        Collection<Category> children = this.directChildren(one);
        for (Category category : children) {
            rt.add(category);
            rt.addAll(this.subordinates(category));
        }
        logger.debug(this.getClass().getSimpleName() + ".subordinates(Category) end:" + rt);
        return rt;
    }

    @Override
    public String getCodeById(Long bindingId) {
        if (bindingId == null) {
            return null;
        }
        return this.categoryMapper.selectByPrimaryKey(bindingId).getCode();
    }

    @Override
    public List<String> getCategoryIdsByCampaignId(Long campaignId, Boolean temp) {
        List<CategoryEntity> entities = this.categoryMapper.getCategoryByCampaignId(campaignId, temp != false ? 1 : 0);
        ArrayList list = Lists.newArrayList();
        for (CategoryEntity entity : entities) {
            list.add(entity.getId().toString());
        }
        return list;
    }
}

