/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.cart.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.pegasus.component.campaign.service.CampaignService;
import com.thebeastshop.pegasus.component.cart.TempCart;
import com.thebeastshop.pegasus.component.cart.condition.TempCartPackCondition;
import com.thebeastshop.pegasus.component.cart.dao.TempCartPackDao;
import com.thebeastshop.pegasus.component.cart.service.TempCartService;
import com.thebeastshop.pegasus.component.cart.support.DefaultTempCartImpl;
import com.thebeastshop.pegasus.component.cart.support.TempCartProductPack;
import com.thebeastshop.pegasus.component.channel.Channel;
import com.thebeastshop.pegasus.merchandise.cond.PsProductCond;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.support.AccessWay;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.enums.MemberLevel;
import com.thebeastshop.support.exception.UnknownException;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.util.IdUtil;
import com.thebeastshop.support.util.PriceUtil;
import com.thebeastshop.support.vo.NameValuePair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TempCartServiceImpl
implements TempCartService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private TempCartPackDao dao;
    @Autowired
    private McPsSpvService mcPsSpvService;
    @Autowired
    private McPsProductService mcPsProductService;
    @Autowired
    private CampaignService campaignService;

    private List<TempCartProductPack> syncProductPackPrice(List<TempCartProductPack> packs, AccessWay accessWay) {
        ArrayList productIds = Lists.newArrayListWithExpectedSize((int)packs.size());
        ArrayList spvIds = Lists.newArrayListWithExpectedSize((int)packs.size());
        for (TempCartProductPack pack : packs) {
            if (pack.getProductId() != null) {
                productIds.add(pack.getProductId().toString());
            }
            if (pack.getSpvId() == null) continue;
            spvIds.add(pack.getSpvId());
        }
        PsProductCond cond = new PsProductCond();
        cond.setIds((List)productIds);
        cond.setAccessWay(accessWay.getId());
        cond.setMemberLevel(MemberLevel.NORMAL.getId());
        cond.setMatchCampaign(Boolean.valueOf(true));
        cond.setPagenum(Integer.valueOf(200));
        List products = this.mcPsProductService.findByCond(cond);
        HashMap prodMap = Maps.newHashMapWithExpectedSize((int)packs.size());
        for (PsProductVO psProductVO : products) {
            prodMap.put(psProductVO.getId(), psProductVO);
        }
        Map spvMap = this.mcPsSpvService.mapBySpvIds((List)spvIds);
        Iterator<TempCartProductPack> iterator = packs.iterator();
        while (iterator.hasNext()) {
            TempCartProductPack pack = iterator.next();
            PsProductVO product = (PsProductVO)prodMap.get(pack.getProductId().toString());
            PsSpvVO spv = (PsSpvVO)spvMap.get(pack.getSpvId());
            if (product == null || spv == null) {
                iterator.remove();
                continue;
            }
            pack.setSpv(spv);
            pack.setProduct(product);
            if (pack.getFactProductPrice().equals(spv.getSalesPrice())) continue;
            pack.setFactProductPrice(spv.getSalesPrice());
        }
        return packs;
    }

    private static Long checkSpv(TempCartProductPack pack) {
        Long spvId = pack.getSpvId();
        if (spvId == null) {
            throw new WrongArgException("\u6ca1\u6709\u6307\u5b9a\u5546\u54c1\u3002", "pack.spvId", (Object)spvId);
        }
        return spvId;
    }

    private TempCartProductPack findByBindingAndSpvIdAndSource(String binding, long spvId, CartPackSource packSource) {
        TempCartPackCondition condition = new TempCartPackCondition();
        condition.setBinding(binding);
        condition.setSource(packSource);
        condition.setSpvId(spvId);
        List<TempCartProductPack> packs = this.dao.findByCondition(condition);
        if (CollectionUtils.isNotEmpty(packs)) {
            return packs.get(0);
        }
        return null;
    }

    @Override
    public TempCart getByBinding(String binding, AccessWay accessWay) {
        List<TempCartProductPack> packs = this.syncProductPackPrice(this.dao.getByBinding(binding), accessWay);
        DefaultTempCartImpl rt = new DefaultTempCartImpl();
        rt.setProductPacks(packs);
        rt.setBinding(binding);
        rt.setCount(packs.size());
        rt.setPrice(PriceUtil.sumPrice(packs));
        return rt;
    }

    @Override
    public TempCartProductPack addPack(String binding, TempCartProductPack pack) {
        List<TempCartProductPack> packs = this.addPacks(binding, Arrays.asList(pack));
        if (CollectionUtils.isNotEmpty(packs)) {
            return packs.get(0);
        }
        throw new UnknownException("\u52a0\u5165\u4e34\u65f6\u8d2d\u7269\u8f66\u5931\u8d25");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional
    public List<TempCartProductPack> addPacks(String binding, List<TempCartProductPack> packs) {
        void var3_5;
        ArrayList arrayList = Lists.newArrayList();
        ArrayList toSaveList = Lists.newArrayList();
        ArrayList productIds = Lists.newArrayList();
        ArrayList spvIds = Lists.newArrayList();
        for (TempCartProductPack pack : packs) {
            if (pack.getId() != null) continue;
            productIds.add(pack.getProductId().toString());
            spvIds.add(pack.getSpvId());
        }
        for (TempCartProductPack pack : packs) {
            Long spvId = TempCartServiceImpl.checkSpv(pack);
            CartPackSource source = pack.getSource();
            TempCartProductPack findBySpvId = this.findByBindingAndSpvIdAndSource(binding, spvId, source);
            if (findBySpvId == null) {
                PsSpvVO spv;
                if (pack.getSource().equals((Object)CartPackSource.RAW)) {
                    spv = this.mcPsSpvService.findBySpvId(pack.getSpvId());
                    if (spv == null) throw new WrongArgException("\u52a0\u5165\u4e34\u65f6\u8d2d\u7269\u8f66,spv\u4e0d\u5b58\u5728!", "spvId", (Object)pack.getSpvId());
                    pack.setFactProductPrice(spv.getSalesPrice());
                } else if (pack.getSource().equals((Object)CartPackSource.CHEAPEN_OTHER)) {
                    spv = this.mcPsSpvService.findBySpvId(pack.getSpvId());
                    pack.setFactProductPrice(this.campaignService.getAdditionalPackPrice(spv.getProductId(), MemberLevel.NORMAL));
                    pack.setCount(1);
                }
                TempCartProductPack toSavePack = new TempCartProductPack(pack, binding);
                toSavePack.setCreateTime(new Date());
                toSavePack.setValid(true);
                toSaveList.add(toSavePack);
                continue;
            }
            if (!pack.getSource().equals((Object)CartPackSource.CHEAPEN_OTHER)) {
                findBySpvId.setCount(pack.getCount() + findBySpvId.getCount());
            }
            toSaveList.add(findBySpvId);
        }
        if (!CollectionUtils.isNotEmpty((Collection)toSaveList)) return var3_5;
        List<TempCartProductPack> list = this.dao.save(toSaveList);
        return var3_5;
    }

    @Override
    public void removePacksById(TempCart cart, Collection<Long> packIds) {
        if (CollectionUtils.isNotEmpty(packIds)) {
            String binding = cart.getBinding();
            List<TempCartProductPack> packs = this.dao.getByBinding(binding);
            this.logger.info("packs:{}", packs);
            ArrayList toDel = Lists.newArrayList();
            ArrayList<Long> packsIdsTemp = new ArrayList<Long>();
            for (TempCartProductPack productPack : packs) {
                packsIdsTemp.add(productPack.getId());
                if (!packIds.contains(productPack.getId())) continue;
                toDel.add(productPack);
            }
            for (Long packidt : packIds) {
                if (packsIdsTemp.contains(packidt)) continue;
                throw new WrongArgException("\u6b64\u5305\u88f9id \u4e0d\u5728\u5f53\u524d\u4eba\u7684\u8d2d\u7269\u8f66\u4e2d\uff01\uff01\uff01\u7cfb\u7edf\u653b\u51fb\uff01\uff01", new NameValuePair[0]);
            }
            if (toDel != null && !toDel.isEmpty()) {
                this.dao.delete(toDel);
            }
        }
    }

    @Override
    public void removeByBinding(String binding) {
        this.dao.deleteByBinding(binding);
    }

    @Override
    @Transactional
    public List<TempCartProductPack> modifyPack(TempCart cart, Collection<TempCartProductPack> packs, AccessWay accessWay) {
        List<TempCartProductPack> tempCartProductPacks = new ArrayList<TempCartProductPack>();
        String binding = cart.getBinding();
        if (binding == null) {
            throw new WrongArgException("\u8be5\u4e34\u65f6\u8d2d\u7269\u8f66\u65e0\u5173\u8054\u5bf9\u8c61", "tempCart.binding", null);
        }
        ArrayList toSave = Lists.newArrayList();
        for (TempCartProductPack pack : packs) {
            Long spvId = pack.getSpvId();
            if (spvId == null) {
                throw new WrongArgException("\u8bf7\u6307\u5b9a\u5546\u54c1", "spvId", null);
            }
            TempCartProductPack foundPack = this.dao.getById(pack.getId());
            if (foundPack == null) {
                throw new WrongArgException("\u4e34\u65f6\u8d2d\u7269\u8f66\u4e2d\u5546\u54c1\u4e0d\u5b58\u5728!", (Object)pack.getSource());
            }
            if (CartPackSource.CHEAPEN_OTHER.equals((Object)foundPack.getSource())) continue;
            int count = pack.getCount();
            if (count <= 0) {
                throw new WrongArgException("\u5546\u54c1\u6570\u91cf\u5c0f\u4e8e1", (Object)("spvId:" + pack.getSpvId() + " count:" + count));
            }
            foundPack.setSpvId(spvId);
            foundPack.setCount(count);
            toSave.add(foundPack);
        }
        if (!toSave.isEmpty()) {
            tempCartProductPacks = this.dao.save(toSave);
        }
        return this.syncProductPackPrice(tempCartProductPacks, accessWay);
    }

    @Override
    public Map<TempCartProductPack, PsSpvVO> separateInvalid(Collection<TempCartProductPack> sourcePacks, Collection<TempCartProductPack> validPacks, Collection<TempCartProductPack> invalidPacks, Channel channel) {
        HashMap rt = Maps.newHashMap();
        ArrayList spvIds = Lists.newArrayList();
        for (TempCartProductPack cartProductPack : sourcePacks) {
            spvIds.add(cartProductPack.getSpvId());
        }
        Map spvMap = this.mcPsSpvService.mapBySpvIds((List)spvIds);
        HashMap productSpvSkuMap = Maps.newHashMap();
        for (TempCartProductPack pack : sourcePacks) {
            boolean spvIsUsable;
            PsSpvVO spv = (PsSpvVO)spvMap.get(pack.getSpvId());
            if (spv == null) {
                this.logger.error("id\u4e3a" + pack.getId() + "\u7684\u5546\u54c1\u5305\uff0c\u5176\u5546\u54c1" + pack.getSpvId() + "\u4e0d\u5b58\u5728\u3002");
                continue;
            }
            rt.put(pack, spv);
            boolean bl = spvIsUsable = productSpvSkuMap.get(spv.getSpvId()) == null ? false : (Boolean)productSpvSkuMap.get(spv.getSpvId());
            if (spvIsUsable) {
                if (pack.isValid()) {
                    validPacks.add(pack);
                    continue;
                }
                invalidPacks.add(pack);
                continue;
            }
            invalidPacks.add(pack);
        }
        return rt;
    }

    @Override
    public void removePacks(TempCart cart, Collection<TempCartProductPack> packs) {
        this.removePacksById(cart, IdUtil.toIds(packs));
    }

    @Override
    public void clearInvalidPacks(String binding, AccessWay accessWay) {
        TempCart cart = this.getByBinding(binding, accessWay);
        List<TempCartProductPack> productPacks = cart.getProductPacks();
        ArrayList invalids = Lists.newArrayList();
        for (TempCartProductPack productPack : productPacks) {
            if (productPack.isValid()) continue;
            invalids.add(productPack);
        }
        this.removePacks(cart, invalids);
    }
}

