/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.cart.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.pegasus.component.campaign.service.CampaignService;
import com.thebeastshop.pegasus.component.cart.Cart;
import com.thebeastshop.pegasus.component.cart.condition.CartPackCondition;
import com.thebeastshop.pegasus.component.cart.dao.CartPackDao;
import com.thebeastshop.pegasus.component.cart.service.CartService;
import com.thebeastshop.pegasus.component.cart.support.CartProductPack;
import com.thebeastshop.pegasus.component.cart.support.DefaultCartImpl;
import com.thebeastshop.pegasus.component.channel.Channel;
import com.thebeastshop.pegasus.component.favorite.domain.Favorite;
import com.thebeastshop.pegasus.component.favorite.service.FavoriteService;
import com.thebeastshop.pegasus.component.member.domain.Member;
import com.thebeastshop.pegasus.merchandise.cond.PsProductCond;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.support.AccessWay;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.enums.FavoriteExtType;
import com.thebeastshop.support.enums.MemberLevel;
import com.thebeastshop.support.exception.UnknownException;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.util.EnumUtil;
import com.thebeastshop.support.util.IdUtil;
import com.thebeastshop.support.util.PriceUtil;
import com.thebeastshop.support.vo.cart.CartPacksTransferDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CartServiceImpl
implements CartService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private FavoriteService favoriteService;
    @Autowired
    private CartPackDao dao;
    @Autowired
    private McPsSpvService mcPsSpvService;
    @Autowired
    private McPsProductService mcPsProductService;
    @Autowired
    private CampaignService campaignService;

    private List<CartProductPack> syncProductPackPrice(List<CartProductPack> packs, AccessWay accessWay, Member member) {
        ArrayList productIds = Lists.newArrayListWithExpectedSize((int)packs.size());
        ArrayList spvIds = Lists.newArrayListWithExpectedSize((int)packs.size());
        for (CartProductPack pack : packs) {
            if (pack.getProductId() != null) {
                productIds.add(pack.getProductId().toString());
            }
            if (pack.getSpvId() == null) continue;
            spvIds.add(pack.getSpvId());
        }
        PsProductCond cond = new PsProductCond();
        cond.setIds((List)productIds);
        cond.setAccessWay(accessWay.getId());
        cond.setMemberLevel(member.getMemberLevel());
        cond.setMatchCampaign(Boolean.valueOf(true));
        cond.setPagenum(Integer.valueOf(200));
        List products = this.mcPsProductService.findByCond(cond);
        HashMap prodMap = Maps.newHashMapWithExpectedSize((int)packs.size());
        for (PsProductVO psProductVO : products) {
            prodMap.put(psProductVO.getId(), psProductVO);
        }
        Map spvMap = this.mcPsSpvService.mapBySpvIds((List)spvIds);
        Iterator<CartProductPack> iterator = packs.iterator();
        while (iterator.hasNext()) {
            CartProductPack pack = iterator.next();
            PsProductVO product = (PsProductVO)prodMap.get(pack.getProductId().toString());
            PsSpvVO spv = (PsSpvVO)spvMap.get(pack.getSpvId());
            if (product == null || spv == null) {
                iterator.remove();
                continue;
            }
            pack.setSpv(spv);
            pack.setProduct(product);
            if (!pack.getSource().equals((Object)CartPackSource.RAW) || pack.getFactProductPrice().equals(spv.getSalesPrice())) continue;
            pack.setFactProductPrice(spv.getSalesPrice());
        }
        return packs;
    }

    private static Long checkSpv(CartProductPack pack) {
        Long spvId = pack.getSpvId();
        if (spvId == null) {
            throw new WrongArgException("\u6ca1\u6709\u6307\u5b9a\u5546\u54c1\u3002", "pack.spvId", (Object)spvId);
        }
        return spvId;
    }

    private static Long checkOwner(Member owner, CartProductPack pack) {
        Long ownerId = owner.getId();
        if (ownerId == null) {
            throw new WrongArgException("\u8be5\u8d2d\u7269\u8f66\u65e0\u4e3b", "cart.ownerId", null);
        }
        Long packOwnerId = pack.getOwnerId();
        if (packOwnerId != null && !Objects.equals(ownerId, packOwnerId)) {
            throw new WrongArgException("\u8be5\u5546\u54c1\u5305\u4e0d\u5c5e\u4e8e\u8be5\u4f1a\u5458", "pack.ownerId", (Object)packOwnerId);
        }
        return ownerId;
    }

    private CartProductPack findByOwnerIdAndSpvIdAndSource(long ownerId, long spvId, CartPackSource packSource) {
        CartPackCondition condition = new CartPackCondition();
        condition.setOwnerId(ownerId);
        condition.setSource(packSource);
        condition.setSpvId(spvId);
        List<CartProductPack> packs = this.dao.findByCondition(condition);
        if (CollectionUtils.isNotEmpty(packs)) {
            return packs.get(0);
        }
        return null;
    }

    @Override
    public Cart getByOwner(Member owner, AccessWay accessWay) {
        List<CartProductPack> packs = this.syncProductPackPrice(this.dao.getByOwnerId(owner.getId()), accessWay, owner);
        DefaultCartImpl rt = new DefaultCartImpl();
        rt.setProductPacks(packs);
        rt.setOwnerId(owner.getId());
        rt.setCount(packs.size());
        rt.setPrice(PriceUtil.sumPrice(packs));
        return rt;
    }

    @Override
    public CartProductPack getPacksById(Member owner, Long id, AccessWay accessWay) {
        List<CartProductPack> packs = this.getPacksByIds(owner, Lists.newArrayList((Object[])new Long[]{id}), accessWay);
        if (CollectionUtils.isNotEmpty(packs)) {
            return packs.get(0);
        }
        return null;
    }

    @Override
    public List<CartProductPack> getPacksByIds(Member owner, List<Long> ids, AccessWay accessWay) {
        return this.syncProductPackPrice(this.dao.getByIds(owner.getId(), ids), accessWay, owner);
    }

    @Override
    @Transactional
    public CartProductPack addPack(Member owner, CartProductPack pack) {
        List<CartProductPack> packs = this.addPacks(owner, Arrays.asList(pack));
        if (CollectionUtils.isNotEmpty(packs)) {
            return packs.get(0);
        }
        throw new UnknownException("\u52a0\u5165\u8d2d\u7269\u8f66\u5931\u8d25");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional
    public List<CartProductPack> addPacks(Member owner, List<CartProductPack> packs) {
        void var3_5;
        ArrayList arrayList = Lists.newArrayList();
        ArrayList toSaveList = Lists.newArrayList();
        ArrayList productIds = Lists.newArrayList();
        ArrayList spvIds = Lists.newArrayList();
        for (CartProductPack pack : packs) {
            if (pack.getId() != null) continue;
            productIds.add(pack.getProductId().toString());
            spvIds.add(pack.getSpvId());
        }
        for (CartProductPack pack : packs) {
            Long spvId = CartServiceImpl.checkSpv(pack);
            Long ownerId = CartServiceImpl.checkOwner(owner, pack);
            CartPackSource source = pack.getSource();
            CartProductPack findBySpvId = this.findByOwnerIdAndSpvIdAndSource(ownerId, spvId, source);
            if (findBySpvId == null) {
                PsSpvVO spv;
                if (pack.getSource().equals((Object)CartPackSource.RAW)) {
                    spv = this.mcPsSpvService.findBySpvId(pack.getSpvId());
                    if (spv == null) throw new WrongArgException("\u52a0\u5165\u8d2d\u7269\u8f66,spv\u4e0d\u5b58\u5728!", "spvId", (Object)pack.getSpvId());
                    pack.setFactProductPrice(spv.getSalesPrice());
                } else if (pack.getSource().equals((Object)CartPackSource.CHEAPEN_OTHER)) {
                    spv = this.mcPsSpvService.findBySpvId(pack.getSpvId());
                    pack.setFactProductPrice(this.campaignService.getAdditionalPackPrice(spv.getProductId(), (MemberLevel)EnumUtil.valueOf((Comparable)owner.getMemberLevel(), MemberLevel.class)));
                    pack.setCount(1);
                }
                pack.setProductId(pack.getProductId());
                CartProductPack toSavePack = new CartProductPack(pack, ownerId);
                toSavePack.setCreateTime(new Date());
                toSavePack.setValid(true);
                toSaveList.add(toSavePack);
                continue;
            }
            if (!pack.getSource().equals((Object)CartPackSource.CHEAPEN_OTHER)) {
                findBySpvId.setCount(pack.getCount() + findBySpvId.getCount());
            }
            toSaveList.add(findBySpvId);
        }
        if (!CollectionUtils.isNotEmpty((Collection)toSaveList)) return var3_5;
        List<CartProductPack> list = this.dao.save(toSaveList);
        return var3_5;
    }

    @Override
    public void removePacksById(Collection<Long> packIds) {
        ArrayList toDel = Lists.newArrayList();
        for (Long packId : packIds) {
            CartProductPack pack;
            if (packId == null || (pack = this.dao.getById(packId)) == null) continue;
            toDel.add(pack);
        }
        if (toDel != null && !toDel.isEmpty()) {
            this.dao.delete(toDel);
        }
    }

    @Override
    public void removePacksById(Cart cart, Collection<Long> packIds) {
        this.removePacksById(packIds);
    }

    @Override
    public void transfer(CartPacksTransferDTO transfer) {
        CartPacksTransferDTO.Destination to = transfer.getTo();
        List packIds = transfer.getPackIds();
        if (packIds == null || packIds.isEmpty()) {
            return;
        }
        if (to == CartPacksTransferDTO.Destination.FAVORITE) {
            Date now = new Date();
            List<CartProductPack> packs = this.dao.getByIds(transfer.getOwnerId(), packIds);
            if (packs == null || packs.isEmpty()) {
                return;
            }
            ArrayList prodIds = Lists.newArrayList();
            for (CartProductPack pack : packs) {
                if (pack == null || pack.getProductId() == null) continue;
                prodIds.add(pack.getProductId().toString());
            }
            Map productMap = this.mcPsProductService.mapByProdIds((List)prodIds);
            ArrayList favorites = Lists.newArrayList();
            for (CartProductPack pack : packs) {
                PsProductVO product = (PsProductVO)productMap.get(pack.getProductId().toString());
                if (product == null) {
                    throw new UnknownException("\u79fb\u5230\u6536\u85cf\u5939\u7684\u65f6\u5019\u53d1\u73b0\u5546\u54c1\u4e0d\u5b58\u5728\uff01spvId=" + pack.getSpvId());
                }
                Favorite favorite = new Favorite();
                favorite.setOwnerId(transfer.getOwnerId());
                favorite.setCreateTime(now);
                favorite.setExtId(Long.valueOf(product.getId()));
                favorite.setExtType(FavoriteExtType.PRODUCT);
                favorites.add(favorite);
            }
            this.favoriteService.create(favorites);
            this.dao.delete(packs);
        }
    }

    @Override
    @Transactional
    public List<CartProductPack> modifyPack(Cart cart, Collection<CartProductPack> packs, Member owner, AccessWay accessWay) {
        List<CartProductPack> cartProductPacks = new ArrayList<CartProductPack>();
        Long ownerId = cart.getOwnerId();
        if (ownerId == null) {
            throw new WrongArgException("\u8be5\u8d2d\u7269\u8f66\u65e0\u4e3b", "cart.ownerId", null);
        }
        ArrayList toSave = Lists.newArrayList();
        for (CartProductPack pack : packs) {
            Long spvId = pack.getSpvId();
            if (spvId == null) {
                throw new WrongArgException("\u8bf7\u6307\u5b9a\u5546\u54c1", "spvId", null);
            }
            CartProductPack foundPack = this.dao.getById(pack.getId());
            if (foundPack == null) {
                throw new WrongArgException("\u8d2d\u7269\u8f66\u4e2d\u5546\u54c1\u4e0d\u5b58\u5728!", (Object)pack.getSource());
            }
            if (CartPackSource.CHEAPEN_OTHER.equals((Object)foundPack.getSource())) continue;
            int count = pack.getCount();
            if (count <= 0) {
                throw new WrongArgException("\u5546\u54c1\u6570\u91cf\u5c0f\u4e8e1", (Object)("spvId:" + pack.getSpvId() + " count:" + count));
            }
            foundPack.setSpvId(spvId);
            foundPack.setCount(count);
            toSave.add(foundPack);
        }
        if (!toSave.isEmpty()) {
            cartProductPacks = this.dao.save(toSave);
        }
        return this.syncProductPackPrice(cartProductPacks, accessWay, owner);
    }

    @Override
    public Map<CartProductPack, PsSpvVO> separateInvalid(Collection<CartProductPack> sourcePacks, Collection<CartProductPack> validPacks, Collection<CartProductPack> invalidPacks, Channel channel) {
        HashMap rt = Maps.newHashMap();
        ArrayList spvIds = Lists.newArrayList();
        for (CartProductPack cartProductPack : sourcePacks) {
            spvIds.add(cartProductPack.getSpvId());
        }
        Map spvMap = this.mcPsSpvService.mapBySpvIds((List)spvIds);
        HashMap productSpvSkuMap = Maps.newHashMap();
        for (CartProductPack pack : sourcePacks) {
            boolean spvIsUsable;
            PsSpvVO spv = (PsSpvVO)spvMap.get(pack.getSpvId());
            if (spv == null) {
                this.logger.error("id\u4e3a" + pack.getId() + "\u7684\u5546\u54c1\u5305\uff0c\u5176\u5546\u54c1" + pack.getSpvId() + "\u4e0d\u5b58\u5728\u3002");
                continue;
            }
            rt.put(pack, spv);
            boolean bl = spvIsUsable = productSpvSkuMap.get(spv.getSpvId()) == null ? false : (Boolean)productSpvSkuMap.get(spv.getSpvId());
            if (spvIsUsable) {
                if (pack.isValid()) {
                    validPacks.add(pack);
                    continue;
                }
                invalidPacks.add(pack);
                continue;
            }
            invalidPacks.add(pack);
        }
        return rt;
    }

    @Override
    public void removePacks(Collection<CartProductPack> packs) {
        this.removePacksById(IdUtil.toIds(packs));
    }

    @Override
    public void removePacks(Cart cart, Collection<CartProductPack> packs) {
        this.removePacksById(cart, IdUtil.toIds(packs));
    }

    @Override
    public void clearInvalidPacks(Member owner, AccessWay accessWay) {
        Cart cart = this.getByOwner(owner, accessWay);
        List<CartProductPack> productPacks = cart.getProductPacks();
        ArrayList invalids = Lists.newArrayList();
        for (CartProductPack productPack : productPacks) {
            if (productPack.isValid()) continue;
            invalids.add(productPack);
        }
        this.removePacks(cart, invalids);
    }
}

