/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.cart.dao.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.pegasus.component.cart.condition.TempCartPackCondition;
import com.thebeastshop.pegasus.component.cart.dao.TempCartPackDao;
import com.thebeastshop.pegasus.component.cart.dao.mapper.TempCartPackEntityMapper;
import com.thebeastshop.pegasus.component.cart.model.TempCartPackEntity;
import com.thebeastshop.pegasus.component.cart.model.TempCartPackEntityExample;
import com.thebeastshop.pegasus.component.cart.support.TempCartProductPack;
import com.thebeastshop.pegasus.component.product.pack.ProductPack;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.util.EnumUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class TempCartPackDaoImpl
implements TempCartPackDao {
    private static final Comparator<TempCartPackEntity> CREATE_TIME_DESC = new Comparator<TempCartPackEntity>(){

        @Override
        public int compare(TempCartPackEntity o1, TempCartPackEntity o2) {
            return o2.getCreateTime().compareTo(o1.getCreateTime());
        }
    };
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private TempCartPackEntityMapper mapper;

    private TempCartPackEntity domain2Entity(TempCartProductPack productPack) {
        if (productPack != null) {
            TempCartPackEntity rt = new TempCartPackEntity();
            rt.setId(productPack.getId());
            rt.setCount(productPack.getCount());
            rt.setFactSpvPrice(productPack.getFactProductPrice());
            rt.setBinding(productPack.getBinding());
            rt.setSource(productPack.getSource().getId());
            rt.setSpvId(productPack.getSpvId());
            rt.setProductId(productPack.getProductId());
            rt.setValid(productPack.isValid());
            rt.setCreateTime(productPack.getCreateTime());
            return rt;
        }
        return null;
    }

    private TempCartProductPack entity2Domain(TempCartPackEntity e) {
        if (e != null) {
            TempCartProductPack domain = new TempCartProductPack();
            domain.setCount(e.getCount());
            domain.setCreateTime(e.getCreateTime());
            domain.setFactProductPrice(e.getFactSpvPrice());
            domain.setId(e.getId());
            domain.setBinding(e.getBinding());
            domain.setSource((CartPackSource)EnumUtil.valueOf((Comparable)e.getSource(), CartPackSource.class));
            domain.setSpvId(e.getSpvId());
            domain.setProductId(e.getProductId());
            domain.setValid(e.getValid());
            return domain;
        }
        return null;
    }

    private List<TempCartProductPack> entity2Domain(List<TempCartPackEntity> entities) {
        ArrayList list = Lists.newArrayList();
        for (TempCartPackEntity entity : entities) {
            list.add(this.entity2Domain(entity));
        }
        return list;
    }

    private void fillCriteria(TempCartPackEntityExample.Criteria criteria, TempCartPackCondition condition) {
        if (condition.getBinding() != null) {
            criteria.andBindingEqualTo(condition.getBinding());
        }
        if (condition.getSource() != null) {
            criteria.andSourceEqualTo(condition.getSource().getId());
        }
        if (condition.getSpvId() != null) {
            criteria.andSpvIdEqualTo(condition.getSpvId());
        }
    }

    @Override
    public List<TempCartProductPack> getByBinding(String binding) {
        TempCartPackEntityExample example = new TempCartPackEntityExample();
        example.createCriteria().andBindingEqualTo(binding);
        List<TempCartPackEntity> entities = this.mapper.selectByExample(example);
        Collections.sort(entities, CREATE_TIME_DESC);
        return this.entity2Domain(entities);
    }

    @Override
    @Transactional
    public void delete(Collection<? extends ProductPack> packs) {
        TempCartPackEntityExample example = new TempCartPackEntityExample();
        ArrayList ids = Lists.newArrayList();
        for (ProductPack productPack : packs) {
            ids.add(productPack.getId());
        }
        example.createCriteria().andIdIn((List)ids);
        this.mapper.deleteByExample(example);
    }

    @Override
    public void deleteByBinding(String binding) {
        TempCartPackEntityExample example = new TempCartPackEntityExample();
        example.createCriteria().andBindingEqualTo(binding);
        this.mapper.deleteByExample(example);
    }

    @Override
    public TempCartProductPack getById(long packId) {
        return this.entity2Domain(this.mapper.selectByPrimaryKey(packId));
    }

    @Override
    @Transactional
    public TempCartProductPack save(TempCartProductPack productPack) {
        this.logger.error("====source:" + productPack.getSource() + " " + productPack);
        TempCartPackEntity entity = this.domain2Entity(productPack);
        if (entity.getId() == null) {
            this.mapper.insert(entity);
        } else {
            this.mapper.updateByPrimaryKey(entity);
        }
        return this.entity2Domain(entity);
    }

    @Override
    @Transactional
    public List<TempCartProductPack> save(List<TempCartProductPack> toSave) {
        ArrayList toInsert = Lists.newArrayList();
        ArrayList toUpdate = Lists.newArrayList();
        HashMap idMap = Maps.newHashMap();
        for (TempCartProductPack pack : toSave) {
            Long id = pack.getId();
            if (id == null) {
                toInsert.add(this.domain2Entity(pack));
                continue;
            }
            toUpdate.add(this.domain2Entity(pack));
            idMap.put(id, pack);
        }
        this.logger.info("------------" + toInsert + "-----------" + toUpdate);
        ArrayList rt = Lists.newArrayList();
        if (!toInsert.isEmpty()) {
            for (TempCartPackEntity entity : toInsert) {
                this.mapper.insertSelective(entity);
                rt.add(this.entity2Domain(entity));
            }
        }
        if (!toUpdate.isEmpty()) {
            for (TempCartPackEntity record : toUpdate) {
                this.mapper.updateByPrimaryKey(record);
                rt.add(this.entity2Domain(record));
            }
        }
        return rt;
    }

    @Override
    public List<TempCartProductPack> getByIds(String binding, List<Long> ids) {
        TempCartPackEntityExample example = new TempCartPackEntityExample();
        example.createCriteria().andIdIn((List)ids).andBindingEqualTo(binding);
        List<TempCartPackEntity> entities = this.mapper.selectByExample(example);
        return this.entity2Domain(entities);
    }

    @Override
    public List<TempCartProductPack> findByCondition(TempCartPackCondition condition) {
        TempCartPackEntityExample example = new TempCartPackEntityExample();
        this.fillCriteria(example.createCriteria(), condition);
        List<TempCartPackEntity> entities = this.mapper.selectByExample(example);
        return this.entity2Domain(entities);
    }
}

