/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.cart.dao.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.pegasus.component.cart.condition.CartPackCondition;
import com.thebeastshop.pegasus.component.cart.dao.CartPackDao;
import com.thebeastshop.pegasus.component.cart.dao.mapper.CartPackEntityMapper;
import com.thebeastshop.pegasus.component.cart.model.CartPackEntity;
import com.thebeastshop.pegasus.component.cart.model.CartPackEntityExample;
import com.thebeastshop.pegasus.component.cart.support.CartProductPack;
import com.thebeastshop.pegasus.component.product.pack.ProductPack;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.util.EnumUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CartPackDaoImpl
implements CartPackDao {
    private static final Comparator<CartPackEntity> CREATE_TIME_DESC = new Comparator<CartPackEntity>(){

        @Override
        public int compare(CartPackEntity o1, CartPackEntity o2) {
            return o2.getCreateTime().compareTo(o1.getCreateTime());
        }
    };
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CartPackEntityMapper mapper;

    private CartPackEntity domain2Entity(CartProductPack productPack) {
        if (productPack != null) {
            CartPackEntity rt = new CartPackEntity();
            rt.setId(productPack.getId());
            rt.setCount(productPack.getCount());
            rt.setFactSpvPrice(productPack.getFactProductPrice());
            rt.setOwnerId(productPack.getOwnerId());
            rt.setSource(productPack.getSource().getId());
            rt.setSpvId(productPack.getSpvId());
            rt.setProductId(productPack.getProductId());
            rt.setValid(productPack.isValid());
            rt.setCreateTime(productPack.getCreateTime());
            return rt;
        }
        return null;
    }

    private CartProductPack entity2Domain(CartPackEntity e) {
        if (e != null) {
            CartProductPack domain = new CartProductPack();
            domain.setCount(e.getCount());
            domain.setCreateTime(e.getCreateTime());
            domain.setFactProductPrice(e.getFactSpvPrice());
            domain.setId(e.getId());
            domain.setOwnerId(e.getOwnerId());
            domain.setSource((CartPackSource)EnumUtil.valueOf((Comparable)e.getSource(), CartPackSource.class));
            domain.setSpvId(e.getSpvId());
            domain.setProductId(e.getProductId());
            domain.setValid(e.getValid());
            return domain;
        }
        return null;
    }

    private List<CartProductPack> entity2Domain(List<CartPackEntity> entities) {
        ArrayList list = Lists.newArrayList();
        for (CartPackEntity entity : entities) {
            list.add(this.entity2Domain(entity));
        }
        return list;
    }

    private void fillCriteria(CartPackEntityExample.Criteria criteria, CartPackCondition condition) {
        if (condition.getOwnerId() != null) {
            criteria.andOwnerIdEqualTo(condition.getOwnerId());
        }
        if (condition.getSource() != null) {
            criteria.andSourceEqualTo(condition.getSource().getId());
        }
        if (condition.getSpvId() != null) {
            criteria.andSpvIdEqualTo(condition.getSpvId());
        }
    }

    @Override
    public List<CartProductPack> getByOwnerId(long ownerId) {
        CartPackEntityExample example = new CartPackEntityExample();
        example.createCriteria().andOwnerIdEqualTo(ownerId);
        List<CartPackEntity> entities = this.mapper.selectByExample(example);
        Collections.sort(entities, CREATE_TIME_DESC);
        return this.entity2Domain(entities);
    }

    @Override
    @Transactional
    public void delete(Collection<? extends ProductPack> packs) {
        CartPackEntityExample example = new CartPackEntityExample();
        ArrayList ids = Lists.newArrayList();
        for (ProductPack productPack : packs) {
            ids.add(productPack.getId());
        }
        example.createCriteria().andIdIn((List)ids);
        this.mapper.deleteByExample(example);
    }

    @Override
    public CartProductPack getById(long packId) {
        return this.entity2Domain(this.mapper.selectByPrimaryKey(packId));
    }

    @Override
    @Transactional
    public CartProductPack save(CartProductPack productPack) {
        this.logger.error("====source:" + productPack.getSource() + " " + productPack);
        CartPackEntity entity = this.domain2Entity(productPack);
        if (entity.getId() == null) {
            this.mapper.insert(entity);
        } else {
            this.mapper.updateByPrimaryKey(entity);
        }
        return this.entity2Domain(entity);
    }

    @Override
    @Transactional
    public List<CartProductPack> save(List<CartProductPack> toSave) {
        ArrayList toInsert = Lists.newArrayList();
        ArrayList toUpdate = Lists.newArrayList();
        HashMap idMap = Maps.newHashMap();
        for (CartProductPack pack : toSave) {
            Long id = pack.getId();
            if (id == null) {
                toInsert.add(this.domain2Entity(pack));
                continue;
            }
            toUpdate.add(this.domain2Entity(pack));
            idMap.put(id, pack);
        }
        this.logger.info("------------" + toInsert + "-----------" + toUpdate);
        ArrayList rt = Lists.newArrayList();
        if (!toInsert.isEmpty()) {
            for (CartPackEntity entity : toInsert) {
                this.mapper.insertSelective(entity);
                rt.add(this.entity2Domain(entity));
            }
        }
        if (!toUpdate.isEmpty()) {
            for (CartPackEntity record : toUpdate) {
                this.mapper.updateByPrimaryKey(record);
                rt.add(this.entity2Domain(record));
            }
        }
        return rt;
    }

    @Override
    public List<CartProductPack> getByIds(Long ownerId, List<Long> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            CartPackEntityExample example = new CartPackEntityExample();
            example.createCriteria().andIdIn((List)ids).andOwnerIdEqualTo(ownerId);
            List<CartPackEntity> entities = this.mapper.selectByExample(example);
            return this.entity2Domain(entities);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<CartProductPack> findByCondition(CartPackCondition condition) {
        CartPackEntityExample example = new CartPackEntityExample();
        this.fillCriteria(example.createCriteria(), condition);
        List<CartPackEntity> entities = this.mapper.selectByExample(example);
        return this.entity2Domain(entities);
    }
}

