/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.campaign.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.pegasus.component.campaign.AddCampaign;
import com.thebeastshop.pegasus.component.campaign.ApprovalState;
import com.thebeastshop.pegasus.component.campaign.Campaign;
import com.thebeastshop.pegasus.component.campaign.CampaignCreator;
import com.thebeastshop.pegasus.component.campaign.CampaignHandler;
import com.thebeastshop.pegasus.component.campaign.CampaignProduct;
import com.thebeastshop.pegasus.component.campaign.CampaignResult;
import com.thebeastshop.pegasus.component.campaign.CampaignSection;
import com.thebeastshop.pegasus.component.campaign.CampaignSectionProduct;
import com.thebeastshop.pegasus.component.campaign.CampaignState;
import com.thebeastshop.pegasus.component.campaign.ProductScope;
import com.thebeastshop.pegasus.component.campaign.condition.CampaignCondition;
import com.thebeastshop.pegasus.component.campaign.condition.PendingCampaignCondition;
import com.thebeastshop.pegasus.component.campaign.dao.CampaignDao;
import com.thebeastshop.pegasus.component.campaign.model.CampaignEntity;
import com.thebeastshop.pegasus.component.campaign.service.CampaignProductService;
import com.thebeastshop.pegasus.component.campaign.service.CampaignSectionProductService;
import com.thebeastshop.pegasus.component.campaign.service.CampaignSectionService;
import com.thebeastshop.pegasus.component.campaign.service.CampaignService;
import com.thebeastshop.pegasus.component.campaign.service.CampaignTempService;
import com.thebeastshop.pegasus.component.campaign.service.impl.BaseServiceImpl;
import com.thebeastshop.pegasus.component.campaign.support.DefaultCampaignImpl;
import com.thebeastshop.pegasus.component.campaign.support.DefaultCampaignSectionProductImpl;
import com.thebeastshop.pegasus.component.channel.Channel;
import com.thebeastshop.pegasus.component.discount.DiscountType;
import com.thebeastshop.pegasus.component.product.pack.ProductPack;
import com.thebeastshop.pegasus.component.product.pack.support.DefaultProductPackImpl;
import com.thebeastshop.pegasus.component.product.warehouse.service.ProductWarehouseService;
import com.thebeastshop.pegasus.component.support.service.RedisService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.support.AccessWay;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.enums.MemberLevel;
import com.thebeastshop.support.exception.BusinessLogicNotExpectedException;
import com.thebeastshop.support.exception.NoSuchResourceException;
import com.thebeastshop.support.util.PriceUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CampaignServiceImpl
extends BaseServiceImpl
implements CampaignService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CampaignDao dao;
    @Autowired
    private CampaignSectionService campaignSectionService;
    @Autowired
    private CampaignProductService campaignProductService;
    @Autowired
    private CampaignSectionProductService campaignSectionProductService;
    @Autowired
    private McPsSpvService mcPsSpvService;
    @Autowired
    private McPsProductService mcPsProductService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private ProductWarehouseService productWarehouseService;
    @Autowired
    private CampaignTempService campaignTempService;

    private List<CampaignHandler> sortCampaignHandlers(List<CampaignHandler> handlers) {
        Collections.sort(handlers, new Comparator<CampaignHandler>(){

            @Override
            public int compare(CampaignHandler o1, CampaignHandler o2) {
                Campaign campaign1 = o1.getCampaign();
                Campaign campaign2 = o2.getCampaign();
                DiscountType discountType1 = campaign1.getDiscountType();
                DiscountType discountType2 = campaign2.getDiscountType();
                int i = discountType1.getSort().compareTo(discountType2.getSort());
                if (i == 0 && (i = campaign1.getProductScope().getId().compareTo(campaign2.getProductScope().getId())) == 0 && campaign1.getCreateTime() != null && campaign2.getCreateTime() != null) {
                    i = campaign1.getCreateTime().compareTo(campaign2.getCreateTime());
                }
                return i;
            }
        });
        return handlers;
    }

    private CampaignResult handleOneCampaign(CampaignHandler handler, Map<ProductPack, BigDecimal> preFinalPriceMap, Channel channel) {
        Campaign campaign = handler.getCampaign();
        List<ProductPack> participatingPacks = handler.getParticipatingPacks();
        List<ProductPack> nonParticipatingPacks = handler.getNonParticipatingPacks();
        if (participatingPacks.isEmpty()) {
            return CampaignServiceImpl.empty(campaign, nonParticipatingPacks, preFinalPriceMap);
        }
        return this.checkCondition(campaign, participatingPacks, nonParticipatingPacks, preFinalPriceMap, channel);
    }

    private static List<CampaignSection> matchedConditionSections(Campaign campaign, BigDecimal price, int count) {
        List<CampaignSection> campaignSections = campaign.getCampaignSections();
        ArrayList rt = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(campaignSections)) {
            CampaignSection maxLineSection = null;
            for (CampaignSection campaignSection : campaignSections) {
                if (!campaignSection.getConditionType().matchCondition(price, count, campaignSection.getLine()) || maxLineSection != null && maxLineSection.getLine().compareTo(campaignSection.getLine()) != -1) continue;
                maxLineSection = campaignSection;
            }
            if (maxLineSection != null) {
                rt.add(maxLineSection);
            }
            Collections.sort(rt, CampaignSection.DESC);
        }
        return rt;
    }

    private static CampaignSection findFirstMatch(Collection<CampaignSection> campaignSections, BigDecimal price, int count) {
        for (CampaignSection e : campaignSections) {
            if (!e.getConditionType().matchCondition(price, count, e.getLine())) continue;
            return e;
        }
        return null;
    }

    private CampaignResult checkCondition(Campaign campaign, List<ProductPack> participatingPacks, Collection<ProductPack> nonParticipatingPacks, Map<ProductPack, BigDecimal> preFinalPriceMap, Channel channel) {
        List<CampaignSection> campaignSections;
        BigDecimal participatingPrice = BigDecimal.ZERO;
        int participatingCount = 0;
        if (CollectionUtils.isNotEmpty(participatingPacks)) {
            for (ProductPack productPack : participatingPacks) {
                participatingCount += productPack.getCount();
                BigDecimal finalPrice = preFinalPriceMap.get(productPack);
                if (finalPrice == null) {
                    participatingPrice = participatingPrice.add(productPack.getPrice());
                    continue;
                }
                participatingPrice = participatingPrice.add(finalPrice.multiply(BigDecimal.valueOf(productPack.getCount())));
            }
        }
        if ((campaignSections = CampaignServiceImpl.matchedConditionSections(campaign, participatingPrice = PriceUtil.keepToCent((BigDecimal)participatingPrice), participatingCount)).isEmpty()) {
            return CampaignServiceImpl.notReach(campaign, participatingPacks, nonParticipatingPacks, participatingPrice, participatingCount, preFinalPriceMap);
        }
        return this.campaignAffect(campaign, participatingPrice, participatingCount, participatingPacks, nonParticipatingPacks, campaignSections, preFinalPriceMap, channel);
    }

    private static CampaignResult notReach(Campaign campaign, Collection<ProductPack> participatePacks, Collection<ProductPack> nonParticipatingPacks, BigDecimal participatePrice, int participateCount, Map<ProductPack, BigDecimal> preFinalPriceMap) {
        return new CampaignResult.DefaultCampaignResultImpl(campaign, false, participatePacks, participatePrice, preFinalPriceMap, preFinalPriceMap, nonParticipatingPacks, participatePrice, Lists.newArrayList());
    }

    private static void addRawPriceToFinalPriceMap(Map<ProductPack, BigDecimal> finalPriceMap, List<? extends ProductPack> packs) {
        for (ProductPack productPack : packs) {
            finalPriceMap.put(productPack, productPack.getFactProductPrice());
        }
    }

    private CampaignResult campaignAffect(Campaign campaign, BigDecimal participatingPrice, int participatingCount, List<ProductPack> participatingPacks, Collection<ProductPack> nonParticipatingPacks, List<CampaignSection> campaignSections, Map<ProductPack, BigDecimal> preFinalPriceMap, Channel channel) {
        BigDecimal participatedPrice = participatingPrice;
        ArrayList additionalPacks = Lists.newArrayList();
        HashMap finalPriceMap = Maps.newHashMap(preFinalPriceMap);
        DiscountType discountType = campaign.getDiscountType();
        if (campaign.isCumulative().booleanValue()) {
            CampaignSection campaignSection = CampaignServiceImpl.findFirstMatch(campaignSections, participatingPrice, participatingCount);
            assert (campaignSection != null);
            int times = campaignSection.getConditionType().cumulate(campaignSection.getLine(), participatingPrice, participatingCount);
            if (discountType.isForceParticipate()) {
                if (discountType.isAffectPrice()) {
                    participatedPrice = discountType.handlePrice(participatingPacks, campaignSection, participatingPrice, times, finalPriceMap, preFinalPriceMap);
                }
                this.affectAdditionalPacks(campaign, additionalPacks, campaignSection, times, channel);
            } else {
                this.affectAdditionalPacks(campaign, additionalPacks, campaignSection, times, channel);
            }
        } else {
            boolean first = true;
            for (CampaignSection campaignSection : campaignSections) {
                boolean times = true;
                if (discountType.isForceParticipate()) {
                    if (first) {
                        first = false;
                        if (discountType.isAffectPrice()) {
                            participatedPrice = discountType.handlePrice(participatingPacks, campaignSection, participatingPrice, 1, finalPriceMap, preFinalPriceMap);
                        }
                    }
                    this.affectAdditionalPacks(campaign, additionalPacks, campaignSection, 1, channel);
                    continue;
                }
                this.affectAdditionalPacks(campaign, additionalPacks, campaignSection, 1, channel);
            }
        }
        return new CampaignResult.DefaultCampaignResultImpl(campaign, true, participatingPacks, participatingPrice, preFinalPriceMap, finalPriceMap, nonParticipatingPacks, participatedPrice, additionalPacks);
    }

    private void affectAdditionalPacks(Campaign campaign, Collection<ProductPack> additionalPacks, CampaignSection campaignSection, int times, Channel channel) {
        List<CampaignSectionProduct> campaignSectionProducts = campaignSection.getCampaignSectionProducts();
        if (CollectionUtils.isNotEmpty(campaignSectionProducts)) {
            ArrayList productIds = Lists.newArrayList();
            for (CampaignSectionProduct temp : campaignSectionProducts) {
                productIds.add(temp.getAdditionalProductId());
            }
            for (int i = 0; i < campaignSectionProducts.size(); ++i) {
                ProductPack additionalPack;
                CampaignSectionProduct campaignSectionProduct = campaignSectionProducts.get(i);
                boolean isLastSectionProduct = false;
                if (i >= campaignSectionProducts.size() - 1) {
                    isLastSectionProduct = true;
                }
                if ((additionalPack = this.checkCampaignSectionProduct(campaign, campaignSection, campaignSectionProduct, times, channel, isLastSectionProduct)) == null) continue;
                additionalPacks.add(additionalPack);
                break;
            }
        }
    }

    private ProductPack checkCampaignSectionProduct(Campaign campaign, CampaignSection campaignSection, CampaignSectionProduct campaignSectionProduct, int times, Channel channel, boolean isLastSectionProduct) {
        Long additionalProductId = campaignSectionProduct.getAdditionalProductId();
        if (additionalProductId != null) {
            PsProductVO additionalProduct = this.mcPsProductService.findByProdId(additionalProductId);
            if (additionalProduct != null) {
                List spvs = this.mcPsSpvService.findByProdId(Long.valueOf(additionalProduct.getId()));
                if (CollectionUtils.isNotEmpty((Collection)spvs)) {
                    Map<PsSpvVO, Integer> spvStockMap = this.productWarehouseService.mapSpvsStock(spvs, channel.getWarehouseCode());
                    for (PsSpvVO spv : spvs) {
                        int count;
                        Integer stock = spvStockMap.get(spv);
                        if (stock == null || stock <= 0) continue;
                        DefaultProductPackImpl additionalPack = new DefaultProductPackImpl();
                        additionalPack.setProductId(Long.valueOf(additionalProduct.getId()));
                        additionalPack.setSpvId(spv.getSpvId());
                        BigDecimal additionalProductPrice = campaignSectionProduct.getAdditionalProductPrice();
                        if (additionalProductPrice == null) {
                            additionalPack.setFactProductPrice(additionalProduct.getListPrice());
                        } else {
                            additionalPack.setFactProductPrice(additionalProductPrice);
                        }
                        DiscountType discountType = campaign.getDiscountType();
                        if (discountType == DiscountType.GIFT) {
                            additionalPack.setSource(CartPackSource.GIFT);
                        } else if (discountType == DiscountType.CHEAPEN_OTHER) {
                            additionalPack.setSource(CartPackSource.CHEAPEN_OTHER);
                        }
                        int n = count = campaignSection.getFactor().intValue() <= 0 ? 1 : campaignSection.getFactor().intValue();
                        if ((count *= times) > stock) {
                            count = stock;
                        }
                        additionalPack.setCount(count >= 0 ? count : 0);
                        additionalPack.setSpv(spv);
                        additionalPack.setProduct(additionalProduct);
                        return additionalPack;
                    }
                }
                if (isLastSectionProduct) {
                    if (CollectionUtils.isEmpty((Collection)spvs)) {
                        throw new NoSuchResourceException("\u6821\u9a8c\u6d3b\u52a8\u533a\u95f4\u989d\u5916\u5546\u54c1\u662f\u5426\u6ee1\u8db3\u7684\u65b9\u6cd5\u51fa\u9519\u4e86, \u5546\u54c1\u4e0b\u9762\u7684spv\u90fd\u6ca1\u6709\u4e86", "productId", (Object)additionalProductId);
                    }
                    DefaultProductPackImpl additionalPack = new DefaultProductPackImpl();
                    PsSpvVO spv = (PsSpvVO)spvs.get(0);
                    additionalPack.setProductId(Long.valueOf(additionalProduct.getId()));
                    additionalPack.setSpvId(spv.getSpvId());
                    BigDecimal additionalProductPrice = campaignSectionProduct.getAdditionalProductPrice();
                    if (additionalProductPrice == null) {
                        additionalPack.setFactProductPrice(additionalProduct.getListPrice());
                    } else {
                        additionalPack.setFactProductPrice(additionalProductPrice);
                    }
                    DiscountType discountType = campaign.getDiscountType();
                    if (discountType == DiscountType.GIFT) {
                        additionalPack.setSource(CartPackSource.GIFT);
                    } else if (discountType == DiscountType.CHEAPEN_OTHER) {
                        additionalPack.setSource(CartPackSource.CHEAPEN_OTHER);
                    }
                    additionalPack.setCount(0);
                    additionalPack.setSpv(spv);
                    additionalPack.setProduct(additionalProduct);
                    return additionalPack;
                }
            } else {
                this.logger.warn("\u6d3b\u52a8\u6307\u5b9a\u7684\u989d\u5916\u5546\u54c1" + additionalProductId + "\u4e0d\u5b58\u5728");
            }
        }
        return null;
    }

    private static CampaignResult empty(Campaign campaign, Collection<ProductPack> nonParticipatingPacks, Map<ProductPack, BigDecimal> preFinalPriceMap) {
        return new CampaignResult.DefaultCampaignResultImpl(campaign, false, Lists.newArrayList(), BigDecimal.ZERO, preFinalPriceMap, preFinalPriceMap, nonParticipatingPacks, BigDecimal.ZERO, Lists.newArrayList());
    }

    @Override
    public List<Campaign> getCampaigns() {
        return this.dao.getCampaigns();
    }

    @Override
    public List<Campaign> getGlobalCampaignList(CampaignCondition condition) {
        return this.dao.getGlobalCampaignList(condition);
    }

    @Override
    public List<Campaign> getByCondition(CampaignCondition condition) {
        if (condition.getContainsGlobal() != null && condition.getContainsGlobal().booleanValue() && condition.getProductScopeId() == ProductScope.GLOBAL.getId()) {
            return this.dao.getGlobalCampaignList(condition);
        }
        Integer stateId = condition.getStateId();
        if (stateId != null) {
            if (-1 == stateId) {
                return this.dao.getOnGoingCampaign();
            }
            if (-2 == stateId) {
                return this.dao.getWillStartCampaign();
            }
            if (-3 == stateId) {
                return this.dao.getEndedCampaign();
            }
        }
        return this.getByProductIdAndCategoryId(condition);
    }

    @Override
    public List<Campaign> getByProductIdAndCategoryId(CampaignCondition condition) {
        String key = condition.toString();
        int seconds = 10;
        List<Long> ids = (List<Long>)this.redisService.get(key, new TypeReference<List<Long>>(){}.getType());
        List<Object> list = null;
        if (ids != null) {
            if (CollectionUtils.isEmpty((Collection)ids)) {
                return Lists.newArrayList();
            }
            list = Lists.newArrayList();
            Integer stateId = condition.getStateId();
            for (Long id : ids) {
                Campaign campaign = this.getById(id, true);
                if (campaign == null || stateId != null && campaign.getState().getId() != stateId) continue;
                list.add(campaign);
            }
            return list;
        }
        list = this.dao.getByProductIdAndCategoryId(condition);
        if ((condition.getProductId() != null || condition.getCategoryId() != null) && (ids = this.fetchCampaignListIds((List<Campaign>)list)) != null) {
            this.redisService.set(key, ids, seconds);
        }
        list.addAll(this.findGlobalCampaigns(condition));
        return list;
    }

    private List<Campaign> findGlobalCampaigns(CampaignCondition condition) {
        if (condition.getContainsGlobal() == null || !condition.getContainsGlobal().booleanValue()) {
            return Lists.newArrayList();
        }
        return this.dao.getGlobalCampaignList(condition);
    }

    private List<Long> fetchCampaignListIds(List<Campaign> campaigns) {
        ArrayList ids = null;
        if (campaigns != null) {
            ids = Lists.newArrayList();
            for (Campaign campaign : campaigns) {
                ids.add(campaign.getId());
            }
        }
        return ids;
    }

    public Campaign getById(Long id, boolean fromRedis) {
        return this.dao.getCampaignById(id, fromRedis);
    }

    @Override
    public List<CampaignResult> match(List<CampaignHandler> handlers, List<? extends ProductPack> productPacks, Channel channel) {
        Date start = new Date();
        if (handlers.isEmpty()) {
            return Collections.emptyList();
        }
        handlers = this.sortCampaignHandlers(handlers);
        ArrayList rt = Lists.newArrayListWithExpectedSize((int)handlers.size());
        ArrayList preResultPacks = productPacks;
        Map<Object, Object> preFinalPriceMap = Maps.newHashMap();
        CampaignServiceImpl.addRawPriceToFinalPriceMap(preFinalPriceMap, preResultPacks);
        if (CollectionUtils.isNotEmpty(handlers)) {
            for (CampaignHandler handler : handlers) {
                CampaignResult campaignResult = this.handleOneCampaign(handler, preFinalPriceMap, channel);
                Collection<ProductPack> participators = campaignResult.getOwnedPacks();
                ArrayList curResultPacks = Lists.newArrayList(participators);
                if (CollectionUtils.isNotEmpty(preResultPacks)) {
                    for (ProductPack preResultPack : preResultPacks) {
                        if (participators.contains(preResultPack)) continue;
                        curResultPacks.add(preResultPack);
                    }
                }
                rt.add(campaignResult);
                preFinalPriceMap = campaignResult.getFinalPriceMap();
                preResultPacks = curResultPacks;
            }
        }
        Date end = new Date();
        this.logger.info("\u6d3b\u52a8\u5339\u914d\u82b1\u8d39\u65f6\u95f4\uff1a{}\u6beb\u79d2", (Object)(end.getTime() - start.getTime()));
        return rt;
    }

    @Override
    public List<ProductPack> getAdditionalPacks(List<CampaignHandler> handlers, Channel channel) {
        ArrayList rt = Lists.newArrayList();
        for (CampaignHandler handler : handlers) {
            CampaignResult campaignResult;
            Collection<ProductPack> additionalPacks;
            Campaign campaign = handler.getCampaign();
            DiscountType discountType = campaign.getDiscountType();
            if (!discountType.equals((Object)DiscountType.CHEAPEN_OTHER) && !discountType.equals((Object)DiscountType.GIFT) || !CollectionUtils.isNotEmpty(additionalPacks = (campaignResult = this.handleOneCampaign(handler, Maps.newHashMap(), channel)).getAdditionalPacks())) continue;
            for (ProductPack productPack : additionalPacks) {
                if (productPack.getCount() <= 0) continue;
                rt.add(productPack);
            }
        }
        return rt;
    }

    @Override
    public List<Campaign> getAvailableCampaigns(AccessWay accessWay) {
        return this.dao.getAvailableCampaigns(accessWay);
    }

    @Override
    public List<Campaign> getAvailableCampaigns(AccessWay accessWay, MemberLevel memberLevel) {
        return this.dao.getAvailableCampaigns(accessWay, memberLevel);
    }

    @Override
    public Campaign create(Campaign obj) {
        return this.dao.create(obj);
    }

    private static String generateCode(Object id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        String code = CodeGenerator.getInstance().generate("CAMPAIGN_CODE", params);
        return code;
    }

    private static List<CampaignSectionProduct> buildSectionProduct(List<CampaignSectionProduct> list, Long campaignId, List<Long> sectionIds, Boolean isTemp) {
        if (CollectionUtils.isNotEmpty(sectionIds) && CollectionUtils.isNotEmpty(list)) {
            ArrayList results = Lists.newArrayList();
            Double i = 1.0;
            for (Long sectionId : sectionIds) {
                for (CampaignSectionProduct item : list) {
                    if (!(item instanceof DefaultCampaignSectionProductImpl)) continue;
                    DefaultCampaignSectionProductImpl ditem = new DefaultCampaignSectionProductImpl();
                    ditem.setCampaignId(campaignId);
                    ditem.setCampaignSectionId(sectionId);
                    ditem.setAdditionalProductId(item.getAdditionalProductId());
                    ditem.setAdditionalProductPrice(item.getAdditionalProductPrice());
                    ditem.setAdditionalProductCount(item.getAdditionalProductCount());
                    Double d = i;
                    Double d2 = i = Double.valueOf(i + 1.0);
                    ditem.setRanking(d);
                    if (isTemp.booleanValue()) {
                        ditem.setTemp(1);
                    } else {
                        ditem.setTemp(0);
                    }
                    results.add(ditem);
                }
            }
            return results;
        }
        return null;
    }

    private List<CampaignProduct> buildProductList(List<CampaignProduct> productList, Long campaignId, Boolean isTemp) {
        if (null != productList) {
            for (CampaignProduct item : productList) {
                item.setCampaignId(campaignId);
                if (isTemp.booleanValue()) {
                    item.setTemp(1);
                    continue;
                }
                item.setTemp(0);
            }
        }
        return productList;
    }

    private void checkCampaignIllegal(AddCampaign domain) {
        List<CampaignProduct> notBlacklist = this.buildNotBlackListProductList(this.buildAllProductList(domain));
        Integer productScope = domain.getProductScope();
        Integer discountTypeId = domain.getDiscountType();
        if (!productScope.equals(ProductScope.GLOBAL.getId()) && CollectionUtils.isEmpty(notBlacklist)) {
            this.logger.info("\u672a\u6307\u5b9a\u9002\u7528\u5546\u54c1\u4e14\u672a\u52fe\u9009\u7c7b\u76ee");
            throw new BusinessLogicNotExpectedException("\u672a\u6307\u5b9a\u9002\u7528\u5546\u54c1\u4e14\u672a\u52fe\u9009\u7c7b\u76ee");
        }
        if (CollectionUtils.isEmpty(domain.getSectionList())) {
            this.logger.info("\u5fc5\u987b\u6307\u5b9a\u6d3b\u52a8\u7684\u4f18\u60e0\u533a\u95f4");
            throw new BusinessLogicNotExpectedException("\u5fc5\u987b\u6307\u5b9a\u6d3b\u52a8\u7684\u4f18\u60e0\u533a\u95f4");
        }
        if ((discountTypeId.equals(DiscountType.CHEAPEN_OTHER.getId()) || discountTypeId.equals(DiscountType.GIFT.getId())) && CollectionUtils.isEmpty(domain.getSectionProductList())) {
            this.logger.info("\u672a\u6307\u5b9a\u6d3b\u52a8\u7684\u8d60\u54c1\u6216\u8005\u6362\u8d2d\u5546\u54c1\u4fe1\u606f");
            throw new BusinessLogicNotExpectedException("\u672a\u6307\u5b9a\u6d3b\u52a8\u7684\u8d60\u54c1\u6216\u8005\u6362\u8d2d\u5546\u54c1\u4fe1\u606f");
        }
        if (!discountTypeId.equals(DiscountType.CHEAPEN_OTHER.getId()) && !discountTypeId.equals(DiscountType.GIFT.getId()) && this.isExistsMutexCampaign(domain, notBlacklist).booleanValue()) {
            this.logger.info("\u5b58\u5728\u4e92\u65a5\u6d3b\u52a8\uff0c\u521b\u5efa\u6d3b\u52a8\u5931\u8d25");
            throw new BusinessLogicNotExpectedException("\u5b58\u5728\u4e92\u65a5\u6d3b\u52a8");
        }
        if (domain.getAdvance() != null && domain.getAdvance().equals(1)) {
            this.checkIsExistsMutexAdvance(domain, notBlacklist);
        }
        if (discountTypeId.equals(DiscountType.CHEAPEN_OTHER.getId())) {
            List<String> productList;
            List<CampaignSectionProduct> sectionProductList = domain.getSectionProductList();
            CampaignEntity campaignEntity = new CampaignEntity();
            campaignEntity.setCode(domain.getCode());
            campaignEntity.setAccessWay(".*,(" + Joiner.on((String)"|").join(domain.getAccessWays()) + "),.*");
            campaignEntity.setStartTime(domain.getStartTime());
            campaignEntity.setExpireTime(domain.getExpireTime());
            if (CollectionUtils.isNotEmpty(sectionProductList) && CollectionUtils.isNotEmpty(productList = this.campaignSectionProductService.getSameAdditionalProduct(campaignEntity, sectionProductList))) {
                this.logger.info("\u5b58\u5728\u76f8\u540c\u6362\u8d2d\u5546\u54c1\u7684\u6d3b\u52a8:" + productList);
                throw new BusinessLogicNotExpectedException("\u5b58\u5728\u76f8\u540c\u6362\u8d2d\u5546\u54c1\u7684\u6d3b\u52a8:" + productList);
            }
        }
        this.checkDiscountIsIllegal(domain, notBlacklist);
    }

    @Override
    @Transactional
    public Boolean create(AddCampaign domain) {
        this.checkCampaignIllegal(domain);
        DefaultCampaignImpl campaign = CampaignServiceImpl.buildCampaign(domain);
        campaign.setState(CampaignState.WAIT_FOR_ONLINE);
        campaign.setApprovalState(ApprovalState.WAIT_FOR_APPROVE);
        Campaign after = this.dao.create(campaign);
        Long campaignId = after.getId();
        if (null == campaignId) {
            this.logger.error("\u6dfb\u52a0\u6d3b\u52a8\u51fa\u9519");
            throw new BusinessLogicNotExpectedException("\u6dfb\u52a0\u6d3b\u52a8\u51fa\u9519");
        }
        if (this.dao.updateCode(campaignId, CampaignServiceImpl.generateCode(campaignId)) <= 0) {
            this.logger.error("\u8bbe\u7f6e\u6d3b\u52a8\u7f16\u7801\u51fa\u9519");
            throw new BusinessLogicNotExpectedException("\u6dfb\u52a0\u6d3b\u52a8\u51fa\u9519");
        }
        this.addRelatedCampaignInfo(domain, campaignId, false);
        return true;
    }

    private void addRelatedCampaignInfo(AddCampaign domain, Long campaignId, Boolean isTemp) {
        Integer discountType;
        List<CampaignProduct> list = this.buildAllProductList(domain);
        List<CampaignProduct> productList = this.buildProductList(list, campaignId, isTemp);
        if (CollectionUtils.isNotEmpty(productList) && !this.campaignProductService.create(productList).booleanValue()) {
            throw new BusinessLogicNotExpectedException("\u6dfb\u52a0\u6d3b\u52a8\u9002\u7528\u5546\u54c1\u51fa\u9519");
        }
        List<Object> sectionIds = Lists.newArrayList();
        List<CampaignSection> campaignSections = CampaignServiceImpl.buildCampaignSection(domain, campaignId, isTemp);
        if (CollectionUtils.isNotEmpty(campaignSections)) {
            if (!this.campaignSectionService.create(campaignSections).booleanValue()) {
                throw new BusinessLogicNotExpectedException("\u6dfb\u52a0\u6d3b\u52a8\u4f18\u60e0\u533a\u95f4\u51fa\u9519");
            }
            sectionIds = this.campaignSectionService.getIdsByCampaignId(campaignId, isTemp);
        }
        if ((discountType = domain.getDiscountType()).equals(DiscountType.GIFT.getId()) || discountType.equals(DiscountType.CHEAPEN_OTHER.getId())) {
            List<CampaignSectionProduct> sectionProductList = domain.getSectionProductList();
            if (CollectionUtils.isNotEmpty(sectionProductList = CampaignServiceImpl.buildSectionProduct(sectionProductList, campaignId, sectionIds, isTemp)) && !this.campaignSectionProductService.create(sectionProductList).booleanValue()) {
                throw new BusinessLogicNotExpectedException("\u6dfb\u52a0\u6d3b\u52a8\u989d\u5916\u5546\u54c1\u51fa\u9519");
            }
        }
    }

    @Override
    public Campaign getCampaignById(Long id) {
        return this.dao.getCampaignById(id);
    }

    @Override
    public Campaign getCampaignDetailById(Long id, Boolean temp) {
        return this.dao.getCampaignDetailById(id, temp);
    }

    @Override
    public List<Campaign> getFirstApprovalCampaign(PendingCampaignCondition cond) {
        Integer type = cond.getType();
        if (null == type) {
            return null;
        }
        if (1 == type) {
            return this.dao.getFirstApprovedCampaign();
        }
        if (0 == type) {
            return this.dao.getFirstPendingCampaign();
        }
        return null;
    }

    @Override
    public List<Campaign> getSecondApprovalCampaign(PendingCampaignCondition cond) {
        Integer type = cond.getType();
        if (null == type) {
            return null;
        }
        if (1 == type) {
            return this.dao.getSecondApprovedCampaign();
        }
        if (0 == type) {
            return this.dao.getSecondPendingCampaign();
        }
        return null;
    }

    @Override
    public BigDecimal getAdditionalPackPrice(Long productId, MemberLevel level) {
        return this.dao.getAdditionalPackPrice(productId, level);
    }

    @Override
    public Boolean offLine(Long id) {
        Campaign campaign = this.dao.getCampaignById(id);
        this.campaignTempService.changeActiveByCode(campaign.getCode());
        return this.dao.changeCampaignState(id, CampaignState.OFFLINE);
    }

    @Override
    public Boolean onLine(Long id) {
        Campaign campaign = this.dao.getCampaignDetailById(id, false);
        this.campaignTempService.changeActiveByCode(campaign.getCode());
        AddCampaign addCampaign = campaign.convert2AddCampaign();
        List<CampaignProduct> whiteList = this.buildNotBlackListProductList(addCampaign.getProductList());
        if (this.isExistsMutexCampaign(addCampaign, whiteList).booleanValue()) {
            this.logger.info("\u5b58\u5728\u4e92\u65a5\u6d3b\u52a8\uff0c\u6d3b\u52a8\u4e0a\u7ebf\u5931\u8d25");
            throw new BusinessLogicNotExpectedException("\u5b58\u5728\u4e92\u65a5\u6d3b\u52a8\uff0c\u6d3b\u52a8\u4e0a\u7ebf\u5931\u8d25");
        }
        if (addCampaign.getAdvance() != null && addCampaign.getAdvance().equals(1)) {
            this.checkIsExistsMutexAdvance(addCampaign, whiteList);
        }
        if (!this.dao.changeCampaignState(id, CampaignState.ONLINE).booleanValue()) {
            this.logger.info("\u6d3b\u52a8\u4e0a\u7ebf\u65f6\u4fee\u6539\u72b6\u6001\u5931\u8d25");
            throw new BusinessLogicNotExpectedException("\u6d3b\u52a8\u4e0a\u7ebf\u65f6\u4fee\u6539\u72b6\u6001\u5931\u8d25");
        }
        return true;
    }

    @Override
    public List<CampaignCreator> getAllCampaignCreator() {
        return this.dao.getAllCampaignCreator();
    }

    @Override
    public List<Campaign> listCampaignByCondition(CampaignCondition condition) {
        return this.dao.listCampaignByCondition(condition);
    }

    @Override
    @Transactional
    public Boolean revoke(Long id) {
        Campaign campaign = this.dao.getCampaignById(id);
        if (campaign.getState().getId().equals(CampaignState.WAIT_FOR_ONLINE.getId())) {
            if (!this.dao.changeCampaignApprovalState(id, ApprovalState.DRAFT).booleanValue()) {
                this.logger.error("\u64a4\u56de\u7f16\u53f7\u4e3a" + id + "\u7684\u6d3b\u52a8\u7684\u4fee\u6539\u5ba1\u6279\u72b6\u6001\u4e3a\u8349\u7a3f\u5931\u8d25");
                throw new BusinessLogicNotExpectedException("\u64a4\u56de\u4fee\u6539\u72b6\u6001\u5931\u8d25");
            }
        } else {
            if (!this.campaignTempService.revoke(campaign.getCode()).booleanValue()) {
                this.logger.error("\u5c06\u7f16\u7801\u4e3a" + campaign.getCode() + "\u7684\u4e34\u65f6\u8bb0\u5f55\u8bbe\u7f6e\u4e3a\u4e0d\u53ef\u7528\u5931\u8d25");
                throw new BusinessLogicNotExpectedException("\u64a4\u56de\u5931\u8d25");
            }
            if (!this.dao.changeCampaignApprovalState(id, ApprovalState.APPROVAL_PASS).booleanValue()) {
                this.logger.error("\u4fee\u6539\u7f16\u53f7\u4e3a:" + id + "\u7684\u6d3b\u52a8\u7684\u5ba1\u6279\u72b6\u6001\u4e3a\u5ba1\u6279\u901a\u8fc7\u5931\u8d25");
                throw new BusinessLogicNotExpectedException("\u64a4\u56de\u4fee\u6539\u72b6\u6001\u5931\u8d25");
            }
        }
        return true;
    }

    @Override
    public Boolean saveAsDraft(AddCampaign domain) {
        DefaultCampaignImpl campaign = CampaignServiceImpl.buildCampaign(domain);
        campaign.setApprovalState(ApprovalState.DRAFT);
        campaign.setState(CampaignState.WAIT_FOR_ONLINE);
        Campaign after = this.dao.create(campaign);
        Long campaignId = after.getId();
        if (null == campaignId) {
            this.logger.error("\u6d3b\u52a8\u4fdd\u5b58\u8349\u7a3f\u51fa\u9519");
            throw new BusinessLogicNotExpectedException("\u6d3b\u52a8\u4fdd\u5b58\u8349\u7a3f\u51fa\u9519");
        }
        if (this.dao.updateCode(campaignId, CampaignServiceImpl.generateCode(campaignId)) <= 0) {
            this.logger.error("\u8bbe\u7f6e\u6d3b\u52a8\u8349\u7a3f\u7f16\u7801\u51fa\u9519");
            throw new BusinessLogicNotExpectedException("\u6d3b\u52a8\u4fdd\u5b58\u8349\u7a3f\u51fa\u9519");
        }
        this.addRelatedCampaignInfo(domain, campaignId, false);
        return true;
    }

    private Boolean checkIllegalChange(AddCampaign campaign, Campaign detail) {
        List<CampaignProduct> campaignProductList;
        if (!campaign.getDiscountType().equals(detail.getDiscountType().getId())) {
            return true;
        }
        if (campaign.getStartTime().getTime() != detail.getStartTime().getTime()) {
            return true;
        }
        if (campaign.getExpireTime().getTime() != detail.getExpireTime().getTime()) {
            return true;
        }
        if (!campaign.getProductScope().equals(detail.getProductScope().getId())) {
            return true;
        }
        if (CollectionUtils.isNotEmpty(campaign.getAccessWays()) != CollectionUtils.isNotEmpty(detail.getAccessWays())) {
            return true;
        }
        if (CollectionUtils.isNotEmpty(detail.getAccessWays())) {
            if (campaign.getAccessWays().size() != detail.getAccessWays().size()) {
                return true;
            }
            ArrayList accessWays = Lists.newArrayList();
            for (AccessWay accessWay : detail.getAccessWays()) {
                accessWays.add(accessWay.getId());
            }
            if (!StringUtils.join(campaign.getAccessWays(), (String)",").equals(StringUtils.join((Collection)accessWays, (String)","))) {
                return true;
            }
        }
        if (CollectionUtils.isNotEmpty(campaign.getMemberLevels()) != CollectionUtils.isNotEmpty(detail.getMemberLevels())) {
            return true;
        }
        if (CollectionUtils.isNotEmpty(campaign.getMemberLevels())) {
            if (campaign.getMemberLevels().size() != detail.getMemberLevels().size()) {
                return true;
            }
            ArrayList memberLevels = Lists.newArrayList();
            for (MemberLevel memberLevel : detail.getMemberLevels()) {
                memberLevels.add(memberLevel.getId());
            }
            if (!StringUtils.join(campaign.getMemberLevels(), (String)",").equals(StringUtils.join((Collection)memberLevels, (String)","))) {
                return true;
            }
        }
        if (campaign.getCumulative() != detail.isCumulative()) {
            return true;
        }
        if (!campaign.getCrossBorderFlag().equals(detail.getCrossBorderFlag())) {
            return true;
        }
        if (CollectionUtils.isNotEmpty(campaign.getSectionList()) != CollectionUtils.isNotEmpty(detail.getCampaignSections())) {
            return true;
        }
        if (CollectionUtils.isNotEmpty(campaign.getSectionList())) {
            List<CampaignSection> campaignSections = campaign.getSectionList();
            if (campaignSections.size() != detail.getCampaignSections().size()) {
                return true;
            }
            List<CampaignSection> campaignSections1 = detail.getCampaignSections();
            for (CampaignSection campaignSection : campaignSections) {
                if (campaignSections1.contains(campaignSection)) continue;
                return true;
            }
        }
        if (CollectionUtils.isNotEmpty(campaignProductList = this.buildAllProductList(campaign)) != CollectionUtils.isNotEmpty(detail.getCampaignProducts())) {
            return true;
        }
        if (CollectionUtils.isNotEmpty(campaignProductList)) {
            if (campaignProductList.size() != detail.getCampaignProducts().size()) {
                return true;
            }
            List<CampaignProduct> campaignProducts = detail.getCampaignProducts();
            for (CampaignProduct item : campaignProductList) {
                if (campaignProducts.contains(item)) continue;
                return true;
            }
        }
        List<Object> campaignSectionProducts = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(detail.getCampaignSections())) {
            campaignSectionProducts = detail.getCampaignSections().get(0).getCampaignSectionProducts();
        }
        if (CollectionUtils.isNotEmpty(campaign.getSectionProductList()) != CollectionUtils.isNotEmpty((Collection)campaignSectionProducts)) {
            return true;
        }
        if (CollectionUtils.isNotEmpty(campaign.getSectionProductList())) {
            List<CampaignSectionProduct> sectionProductList = campaign.getSectionProductList();
            if (sectionProductList.size() != campaignSectionProducts.size()) {
                return true;
            }
            for (CampaignSectionProduct sectionProduct : sectionProductList) {
                if (campaignSectionProducts.contains(sectionProduct)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Transactional
    public Boolean update(AddCampaign campaign) {
        Boolean temp = campaign.getTemp();
        Campaign domain = this.getCampaignByCode(campaign.getCode());
        Integer stateId = domain.getState().getId();
        Integer approvalStateId = domain.getApprovalState().getId();
        if (stateId.equals(CampaignState.WAIT_FOR_ONLINE.getId())) {
            if (!approvalStateId.equals(ApprovalState.DRAFT.getId()) && !approvalStateId.equals(ApprovalState.APPROVE_NOT_PASS.getId())) {
                this.logger.error("\u5f85\u4e0a\u7ebf\u7684\u975e\u8349\u7a3f\u548c\u975e\u5ba1\u6279\u4e0d\u901a\u8fc7\u7684\u6d3b\u52a8\u4e0d\u80fd\u4fee\u6539");
                throw new BusinessLogicNotExpectedException("\u8be5\u6d3b\u52a8\u72b6\u6001\u4e0b\u4e0d\u53ef\u4fee\u6539");
            }
            Boolean typeIsChanged = !domain.getDiscountType().getId().equals(campaign.getDiscountType());
            DefaultCampaignImpl campaignImpl = CampaignServiceImpl.buildCampaign(campaign);
            if (!temp.booleanValue()) {
                if (this.dao.update(campaignImpl) <= 0) {
                    this.logger.error("\u66f4\u65b0\u4fe1\u606f\u5931\u8d25");
                    throw new BusinessLogicNotExpectedException("\u66f4\u65b0\u6d3b\u52a8\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
                }
            } else if (this.campaignTempService.update(campaignImpl).booleanValue()) {
                this.logger.error("\u66f4\u65b0\u4fe1\u606f\u5931\u8d25");
                throw new BusinessLogicNotExpectedException("\u66f4\u65b0\u6d3b\u52a8\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
            }
            this.updateRelatedCampaignInfo(campaign, typeIsChanged, temp);
            return true;
        }
        if (!stateId.equals(CampaignState.ONLINE.getId()) && !stateId.equals(CampaignState.OFFLINE.getId())) {
            this.logger.error("\u6d3b\u52a8\u72b6\u6001\u6709\u8bef");
            throw new BusinessLogicNotExpectedException("\u6d3b\u52a8\u72b6\u6001\u6709\u8bef");
        }
        Campaign detail = this.getCampaignDetailByCode(campaign.getCode());
        if (this.checkIllegalChange(campaign, detail).booleanValue()) {
            this.logger.error("\u4fee\u6539\u4e86\u540d\u79f0\u3001\u6587\u6848\u53ca\u9884\u544a\u76f8\u5173\u4ee5\u5916\u7684\u9879\uff0c\u53ea\u80fd\u63d0\u4ea4\u5ba1\u6279");
            throw new BusinessLogicNotExpectedException("\u4fee\u6539\u4e86\u540d\u79f0\u3001\u6587\u6848\u53ca\u9884\u544a\u76f8\u5173\u4ee5\u5916\u7684\u9879,\u53ea\u80fd\u63d0\u4ea4\u5ba1\u6279");
        }
        if (!(campaign.getAdvance() == null || !campaign.getAdvance().equals(1) || detail.getAdvance() != null && campaign.getAdvanceStartTime().equals(detail.getAdvanceStartTime()) && campaign.getAdvanceEndTime().equals(detail.getAdvanceEndTime()))) {
            this.checkIsExistsMutexAdvance(campaign, this.buildNotBlackListProductList(campaign.getProductList()));
        }
        if (this.updateSelective(campaign) != false) return true;
        this.logger.error("\u66f4\u65b0\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25");
        throw new BusinessLogicNotExpectedException("\u66f4\u65b0\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25");
    }

    private void updateRelatedCampaignInfo(AddCampaign campaign, Boolean typeIsChanged, Boolean isTemp) {
        Long campaignId = campaign.getId();
        List<Object> sectionIds = Lists.newArrayList();
        List<CampaignSection> campaignSections = CampaignServiceImpl.buildCampaignSection(campaign, campaignId, isTemp);
        if ((typeIsChanged.booleanValue() || CollectionUtils.isNotEmpty(campaignSections)) && !this.campaignSectionService.deleteByCampaignId(campaignId, isTemp).booleanValue()) {
            this.logger.error("\u5220\u9664\u65e7\u7684\u4f18\u60e0\u533a\u95f4\u51fa\u9519");
            throw new BusinessLogicNotExpectedException("\u66f4\u65b0\u6d3b\u52a8\u4f18\u60e0\u533a\u95f4\u4fe1\u606f\u5931\u8d25");
        }
        if (CollectionUtils.isNotEmpty(campaignSections)) {
            if (!this.campaignSectionService.create(campaignSections).booleanValue()) {
                this.logger.error("\u6dfb\u52a0\u65b0\u7684\u4f18\u60e0\u533a\u95f4\u5931\u8d25");
                throw new BusinessLogicNotExpectedException("\u66f4\u65b0\u6d3b\u52a8\u4f18\u60e0\u533a\u95f4\u4fe1\u606f\u5931\u8d25");
            }
            sectionIds = this.campaignSectionService.getIdsByCampaignId(campaignId, isTemp);
        }
        if (!this.campaignProductService.deleteByCampaignId(campaignId, isTemp).booleanValue()) {
            this.logger.error("\u5220\u9664\u5df2\u5b58\u5728\u7684\u9002\u7528\u5546\u54c1\u6392\u9664\u5546\u54c1\u6216\u7c7b\u76ee\u5931\u8d25");
            throw new BusinessLogicNotExpectedException("\u66f4\u65b0\u6d3b\u52a8\u9002\u7528\u5546\u54c1\u548c\u7c7b\u76ee\u4fe1\u606f\u5931\u8d25");
        }
        List<CampaignProduct> list = this.buildAllProductList(campaign);
        List<CampaignProduct> productList = this.buildProductList(list, campaignId, isTemp);
        if (CollectionUtils.isNotEmpty(productList) && !this.campaignProductService.create(productList).booleanValue()) {
            this.logger.error("\u521b\u5efa\u65b0\u7684\u9002\u7528\u5546\u54c1\u3001\u6392\u9664\u5546\u54c1\u3001\u52fe\u9009\u7c7b\u76ee\u51fa\u9519");
            throw new BusinessLogicNotExpectedException("\u66f4\u65b0\u6d3b\u52a8\u9002\u7528\u5546\u54c1\u548c\u7c7b\u76ee\u4fe1\u606f\u5931\u8d25");
        }
        Integer discountType = campaign.getDiscountType();
        if (discountType.equals(DiscountType.GIFT.getId()) || discountType.equals(DiscountType.CHEAPEN_OTHER.getId())) {
            List<CampaignSectionProduct> sectionProductList = campaign.getSectionProductList();
            sectionProductList = CampaignServiceImpl.buildSectionProduct(sectionProductList, campaignId, sectionIds, isTemp);
            if ((typeIsChanged.booleanValue() || CollectionUtils.isNotEmpty(sectionProductList)) && !this.campaignSectionProductService.deleteByCampaignId(campaignId, isTemp).booleanValue()) {
                this.logger.error("\u5220\u9664\u5df2\u5b58\u5728\u989d\u5916\u5546\u54c1\u4fe1\u606f\u51fa\u9519");
                throw new BusinessLogicNotExpectedException("\u66f4\u65b0\u6d3b\u52a8\u5173\u8054\u7684\u989d\u5916\u5546\u54c1\u4fe1\u606f\u5931\u8d25");
            }
            if (CollectionUtils.isNotEmpty(sectionProductList) && !this.campaignSectionProductService.create(sectionProductList).booleanValue()) {
                this.logger.error("\u6dfb\u52a0\u65b0\u7684\u989d\u5916\u5546\u54c1\u4fe1\u606f\u51fa\u9519");
                throw new BusinessLogicNotExpectedException("\u66f4\u65b0\u6d3b\u52a8\u5173\u8054\u7684\u989d\u5916\u5546\u54c1\u4fe1\u606f\u5931\u8d25");
            }
        }
    }

    private Boolean checkProductFlag(List<CampaignProduct> products, Boolean flag) {
        if (CollectionUtils.isEmpty(products)) {
            return false;
        }
        for (CampaignProduct item : products) {
            if (item.isBlacklist() != flag) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean updateSelective(AddCampaign campaign) {
        return this.dao.updateSelective(campaign) > 0;
    }

    @Override
    @Transactional
    public Boolean commit2Approval(AddCampaign campaign) {
        DefaultCampaignImpl campaignImpl;
        Campaign detail;
        Campaign domain = this.dao.getCampaignByCode(campaign.getCode());
        if (domain == null) {
            throw new BusinessLogicNotExpectedException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u539f\u7eaa\u5f55");
        }
        this.checkCampaignIllegal(campaign);
        Integer stateId = domain.getState().getId();
        Integer approvalStateId = domain.getApprovalState().getId();
        if ((approvalStateId.equals(ApprovalState.APPROVE_NOT_PASS.getId()) || approvalStateId.equals(ApprovalState.APPROVAL_PASS.getId())) && !this.checkIllegalChange(campaign, detail = this.getCampaignDetailByCode(campaign.getCode())).booleanValue()) {
            this.logger.error("\u672a\u4fee\u6539\u540d\u79f0\u3001\u6587\u6848\u53ca\u9884\u544a\u76f8\u5173\u4ee5\u5916\u7684\u9879\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6279");
            throw new BusinessLogicNotExpectedException("\u672a\u4fee\u6539\u540d\u79f0\u3001\u6587\u6848\u53ca\u9884\u544a\u76f8\u5173\u4ee5\u5916\u7684\u9879,\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6279");
        }
        if (stateId.equals(CampaignState.WAIT_FOR_ONLINE.getId())) {
            campaignImpl = CampaignServiceImpl.buildCampaign(campaign);
            campaignImpl.setApprovalState(ApprovalState.WAIT_FOR_APPROVE);
            if (this.dao.update(campaignImpl) <= 0) {
                this.logger.error("\u66f4\u65b0\u4fe1\u606f\u5931\u8d25");
                throw new BusinessLogicNotExpectedException("\u66f4\u65b0\u6d3b\u52a8\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
            }
            Boolean typeIsChanged = !domain.getDiscountType().getId().equals(campaign.getDiscountType());
            this.updateRelatedCampaignInfo(campaign, typeIsChanged, false);
        } else if (stateId.equals(CampaignState.ONLINE.getId()) || stateId.equals(CampaignState.OFFLINE.getId())) {
            campaignImpl = CampaignServiceImpl.buildCampaign(campaign);
            campaignImpl.setState(CampaignState.WAIT_FOR_ONLINE);
            campaignImpl.setApprovalState(ApprovalState.WAIT_FOR_APPROVE);
            Campaign after = this.campaignTempService.create(campaignImpl);
            Long campaignId = after.getId();
            if (null == campaignId) {
                this.logger.error("\u66f4\u65b0\u6d3b\u52a8\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
                throw new BusinessLogicNotExpectedException("\u63d0\u4ea4\u5ba1\u6279\u51fa\u9519");
            }
            this.addRelatedCampaignInfo(campaign, campaignId, true);
            if (!this.dao.changeCampaignApprovalState(domain.getId(), ApprovalState.WAIT_FOR_APPROVE).booleanValue()) {
                this.logger.error("\u4fee\u6539\u539f\u7eaa\u5f55\u7684\u5ba1\u6279\u72b6\u6001\u5931\u8d25");
                throw new BusinessLogicNotExpectedException("\u63d0\u4ea4\u5ba1\u6279\u5931\u8d25");
            }
        } else {
            this.logger.error("\u539f\u7eaa\u5f55\u72b6\u6001\u6709\u8bef");
            throw new BusinessLogicNotExpectedException("\u539f\u7eaa\u5f55\u72b6\u6001\u6709\u8bef");
        }
        return true;
    }

    @Override
    public Campaign getCampaignDetailByCode(String code) {
        Campaign campaign = this.dao.getCampaignDetailByCode(code);
        if (campaign == null) {
            this.logger.error("\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u8bb0\u5f55");
            throw new BusinessLogicNotExpectedException("\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u8bb0\u5f55");
        }
        Integer stateId = campaign.getState().getId();
        if (stateId.equals(CampaignState.WAIT_FOR_ONLINE.getId())) {
            if (campaign.getProductScope() != null && campaign.getProductScope().getId().equals(ProductScope.SINGLE.getId())) {
                this.setProductCode(campaign, false);
            }
            return campaign;
        }
        if (stateId.equals(CampaignState.ONLINE.getId()) || stateId.equals(CampaignState.OFFLINE.getId())) {
            Integer approvalStateId = campaign.getApprovalState().getId();
            if (approvalStateId.equals(ApprovalState.APPROVAL_PASS.getId()) || approvalStateId.equals(ApprovalState.APPROVE_NOT_PASS.getId())) {
                if (campaign.getProductScope() != null && campaign.getProductScope().getId().equals(ProductScope.SINGLE.getId())) {
                    this.setProductCode(campaign, false);
                }
                return campaign;
            }
            Campaign campaignTemp = this.campaignTempService.getCampaignDetailByCode(code);
            if (campaign.getProductScope() != null && campaignTemp.getProductScope().getId().equals(ProductScope.SINGLE.getId())) {
                this.setProductCode(campaignTemp, true);
            }
            return campaignTemp;
        }
        this.logger.error("\u6d3b\u52a8\u4e0a\u4e0b\u7ebf\u72b6\u6001\u6709\u8bef");
        throw new BusinessLogicNotExpectedException("\u6d3b\u52a8\u4e0a\u4e0b\u7ebf\u72b6\u6001\u6709\u8bef");
    }

    private void setProductCode(Campaign campaign, Boolean isTemp) {
        if (campaign.getProductScope() != null && campaign.getProductScope().getId().equals(ProductScope.SINGLE.getId()) && campaign instanceof DefaultCampaignImpl) {
            DefaultCampaignImpl campaignImpl = (DefaultCampaignImpl)campaign;
            campaignImpl.setProductCode(this.campaignProductService.getProductCodeById(campaign.getId(), isTemp));
        }
    }

    @Override
    public Campaign getCampaignByCode(String code) {
        return this.dao.getCampaignByCode(code);
    }

    @Override
    public Campaign getFormalCampaignDetailByCode(String code) {
        return this.dao.getCampaignDetailByCode(code);
    }
}

