/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.campaign.service.impl;

import com.thebeastshop.pegasus.component.campaign.ApprovalState;
import com.thebeastshop.pegasus.component.campaign.Campaign;
import com.thebeastshop.pegasus.component.campaign.CampaignProduct;
import com.thebeastshop.pegasus.component.campaign.CampaignProductInfo;
import com.thebeastshop.pegasus.component.campaign.CampaignState;
import com.thebeastshop.pegasus.component.campaign.dao.CampaignProductDao;
import com.thebeastshop.pegasus.component.campaign.service.CampaignProductService;
import com.thebeastshop.pegasus.component.campaign.service.CampaignService;
import com.thebeastshop.pegasus.component.campaign.service.CampaignTempService;
import com.thebeastshop.pegasus.component.campaign.vo.CampaignProductVO;
import com.thebeastshop.support.exception.BusinessLogicNotExpectedException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CampaignProductServiceImpl
implements CampaignProductService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CampaignProductDao dao;
    @Autowired
    private CampaignService campaignService;
    @Autowired
    private CampaignTempService campaignTempService;

    @Override
    public CampaignProduct create(CampaignProduct obj) {
        return this.dao.create(obj);
    }

    @Override
    public Boolean create(List<CampaignProduct> objs) {
        return this.dao.create(objs) > 0;
    }

    @Override
    public List<Map<String, Object>> getMutexProduct(List<CampaignProduct> list, List<Map<String, Object>> mutexCampaignIds) {
        return this.dao.isExistsMutexProduct(list, mutexCampaignIds);
    }

    @Override
    public List<Map<String, Object>> getExistsCategoryList(List<Map<String, Object>> mutexCampaignIds) {
        return this.dao.getExistsCategoryList(mutexCampaignIds);
    }

    @Override
    public List<Long> getSelectedCategoryListNoBlack(List<Long> productIds, List<Map<String, Object>> mutexCampaignIds) {
        return this.dao.getSelectedCategoryListNoBlack(productIds, mutexCampaignIds);
    }

    @Override
    public Boolean getByType(Long id, Integer type, Integer temp) {
        return this.dao.getDataByType(id, type, temp) > 0;
    }

    @Override
    public Boolean deleteByCampaignId(Long campaignId, Boolean isTemp) {
        Integer temp = isTemp != false ? 1 : 0;
        return this.dao.deleteByCampaignId(campaignId, temp) >= 0;
    }

    @Override
    public Boolean deleteByCampaignId(Long campaignId, Boolean includeProductFlag, Boolean excludeProductFlag) {
        return this.dao.deleteByCampaignId(campaignId, includeProductFlag, excludeProductFlag) >= 0;
    }

    @Override
    public Boolean changeCampaignId(Long oldId, Long newId, Boolean isTemp) {
        return this.dao.changeCampaignId(oldId, newId, isTemp != false ? 1 : 0) >= 0;
    }

    @Override
    public List<CampaignProduct> getCampaignProductByCode(String code) {
        Long campaignId;
        Campaign campaign = this.campaignService.getCampaignByCode(code);
        Integer stateId = campaign.getState().getId();
        if (stateId.equals(CampaignState.WAIT_FOR_ONLINE.getId())) {
            campaignId = campaign.getId();
        } else if (stateId.equals(CampaignState.ONLINE.getId()) || stateId.equals(CampaignState.OFFLINE.getId())) {
            Integer approvalStateId = campaign.getApprovalState().getId();
            campaignId = approvalStateId.equals(ApprovalState.APPROVAL_PASS.getId()) || approvalStateId.equals(ApprovalState.APPROVE_NOT_PASS.getId()) ? campaign.getId() : this.campaignTempService.getCampaignByCode(code).getId();
        } else {
            throw new BusinessLogicNotExpectedException("\u6d3b\u52a8\u72b6\u6001\u6709\u8bef");
        }
        return this.dao.getProductByCampaignId(campaignId);
    }

    @Override
    public String getProductCodeById(Long campaignId, Boolean isTemp) {
        return this.dao.getProductCodeById(campaignId, isTemp != false ? 1 : 0);
    }

    @Override
    public List<CampaignProductInfo> getIncludeProductsByCampaignId(Long campaignId, Boolean temp) {
        return this.dao.getIncludeProductsByCampaignId(campaignId, temp);
    }

    @Override
    public List<CampaignProductInfo> getExcludeProductsByCampaignId(Long campaignId, Boolean temp) {
        return this.dao.getExcludeProductsByCampaignId(campaignId, temp);
    }

    @Override
    public Boolean getProductSkuInfoBySkuCodes(CampaignProductVO vo) {
        return this.dao.getProductSkuInfoBySkuCodes(vo);
    }
}

