/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.campaign.service.impl;

import com.thebeastshop.pegasus.component.campaign.ApprovalState;
import com.thebeastshop.pegasus.component.campaign.Campaign;
import com.thebeastshop.pegasus.component.campaign.CampaignState;
import com.thebeastshop.pegasus.component.campaign.dao.CampaignDao;
import com.thebeastshop.pegasus.component.campaign.service.CampaignApprovalService;
import com.thebeastshop.pegasus.component.campaign.service.CampaignProductService;
import com.thebeastshop.pegasus.component.campaign.service.CampaignSectionProductService;
import com.thebeastshop.pegasus.component.campaign.service.CampaignSectionService;
import com.thebeastshop.pegasus.component.campaign.service.CampaignTempService;
import com.thebeastshop.pegasus.component.campaign.support.DefaultCampaignImpl;
import com.thebeastshop.pegasus.component.coupon.domain.ApprovalRecord;
import com.thebeastshop.pegasus.component.coupon.domain.impl.DefaultApprovalRecordImpl;
import com.thebeastshop.pegasus.component.coupon.enums.ApprovalType;
import com.thebeastshop.pegasus.component.coupon.service.ApprovalRecordService;
import com.thebeastshop.pegasus.component.coupon.service.BaseService;
import com.thebeastshop.pegasus.component.coupon.support.CouponServiceLoader;
import com.thebeastshop.support.exception.BusinessLogicNotExpectedException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CampaignApprovalServiceImpl
extends BaseService
implements CampaignApprovalService {
    @Autowired
    private CampaignDao campaignDao;
    @Autowired
    private CampaignTempService campaignTempService;
    @Autowired
    private CampaignSectionService sectionService;
    @Autowired
    private CampaignSectionProductService sectionProductService;
    @Autowired
    private CampaignProductService campaignProductService;
    private ApprovalRecordService approvalRecordService = (ApprovalRecordService)CouponServiceLoader.getBean(ApprovalRecordService.class);

    @Override
    public List<ApprovalRecord> getApprovalCampaignBypendingId(Long pendingId) {
        return this.approvalRecordService.listApprovalRecordByPendingId(pendingId, ApprovalType.CAMPAIGN.getId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional
    public Boolean agreePendingCampaign(ApprovalRecord domain) {
        ApprovalRecord newCampaignApproval;
        if (domain == null) {
            throw new BusinessLogicNotExpectedException("\u5ba1\u6279\u53c2\u6570\u6709\u8bef");
        }
        String code = domain.getPendingCode();
        Campaign campaign = this.campaignDao.getCampaignByCode(code);
        Integer stateId = campaign.getState().getId();
        Integer approvalStateId = campaign.getApprovalState().getId();
        if (!approvalStateId.equals(ApprovalState.WAIT_FOR_APPROVE.getId()) && !approvalStateId.equals(ApprovalState.APPROVING.getId())) {
            this.logger.error("\u64cd\u4f5c\u5931\u8d25\uff0c\u7f16\u53f7\u4e3a:" + campaign.getId() + "\u7684\u6d3b\u52a8\u5df2\u7533\u8bf7\u64a4\u56de\u5ba1\u6279\u6216\u5df2\u88ab\u5ba1\u6279");
            throw new BusinessLogicNotExpectedException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8be5\u6d3b\u52a8\u5df2\u7533\u8bf7\u64a4\u56de\u5ba1\u6279");
        }
        Integer level = 0;
        if (domain.getCouponApprovalLevel().getId() != null) {
            level = domain.getCouponApprovalLevel().getId();
        }
        if (1 == level) {
            if (stateId.equals(CampaignState.WAIT_FOR_ONLINE.getId())) {
                if (!this.campaignDao.changeCampaignApprovalState(code, ApprovalState.APPROVING).booleanValue()) {
                    this.logger.error("\u4fee\u6539\u7f16\u7801\u4e3a" + code + "\u7684\u6d3b\u52a8\u7684\u4e00\u7ea7\u5ba1\u6279\u72b6\u6001\u51fa\u9519");
                    throw new BusinessLogicNotExpectedException("\u4fee\u6539\u5ba1\u6279\u72b6\u6001\u51fa\u9519");
                }
            } else {
                if (!stateId.equals(CampaignState.ONLINE.getId()) && !stateId.equals(CampaignState.OFFLINE.getId())) throw new BusinessLogicNotExpectedException("\u6d3b\u52a8\u72b6\u6001\u6709\u8bef");
                if (!this.campaignTempService.changeCampaignApprovalState(code, ApprovalState.APPROVING).booleanValue()) {
                    this.logger.error("\u4fee\u6539\u7f16\u7801\u4e3a" + code + "\u7684\u6d3b\u52a8\u7684\u4e34\u65f6\u8bb0\u5f55\u4e00\u7ea7\u5ba1\u6279\u72b6\u6001\u51fa\u9519");
                    throw new BusinessLogicNotExpectedException("\u4fee\u6539\u5ba1\u6279\u72b6\u6001\u51fa\u9519");
                }
                if (!this.campaignDao.changeCampaignApprovalState(code, ApprovalState.APPROVING).booleanValue()) {
                    this.logger.error("\u4fee\u6539\u7f16\u7801\u4e3a" + code + "\u7684\u6d3b\u52a8\u6b63\u5f0f\u8bb0\u5f55\u7684\u4e00\u7ea7\u5ba1\u6279\u72b6\u6001\u51fa\u9519");
                    throw new BusinessLogicNotExpectedException("\u4fee\u6539\u5ba1\u6279\u72b6\u6001\u51fa\u9519");
                }
            }
        } else if (2 == level) {
            if (stateId.equals(CampaignState.WAIT_FOR_ONLINE.getId())) {
                if (!this.campaignDao.changeCampaignApprovalState(code, ApprovalState.APPROVAL_PASS).booleanValue()) {
                    this.logger.error("\u4fee\u6539\u7f16\u53f7\u4e3a" + code + "\u7684\u6d3b\u52a8\u7684\u4e8c\u7ea7\u5ba1\u6279\u72b6\u6001\u51fa\u9519");
                    throw new BusinessLogicNotExpectedException("\u4fee\u6539\u5ba1\u6279\u72b6\u6001\u51fa\u9519");
                }
                if (!this.campaignDao.changeCampaignState(code, CampaignState.ONLINE).booleanValue()) {
                    this.logger.error("\u4fee\u6539\u7f16\u53f7\u4e3a" + code + "\u7684\u6d3b\u52a8\u7684\u4e0a\u4e0b\u7ebf\u72b6\u6001\u51fa\u9519");
                    throw new BusinessLogicNotExpectedException("\u4fee\u6539\u6d3b\u52a8\u4e0a\u4e0b\u7ebf\u72b6\u6001\u51fa\u9519");
                }
            } else {
                if (!stateId.equals(CampaignState.ONLINE.getId()) && !stateId.equals(CampaignState.OFFLINE.getId())) throw new BusinessLogicNotExpectedException("\u6d3b\u52a8\u72b6\u6001\u6709\u8bef");
                if (!this.campaignTempService.agreeSecondApproval(code).booleanValue()) {
                    this.logger.error("\u4fee\u6539\u7f16\u53f7\u4e3a" + code + "\u7684\u6d3b\u52a8\u7684\u4e34\u65f6\u8bb0\u5f55\u72b6\u6001\u51fa\u9519");
                    throw new BusinessLogicNotExpectedException("\u4fee\u6539\u6d3b\u52a8\u4e0a\u4e0b\u7ebf\u72b6\u6001\u51fa\u9519");
                }
                Integer version = this.campaignDao.getMaxVersionByCode(code);
                if (!this.campaignDao.changeActiveByCode(code).booleanValue()) {
                    this.logger.error("\u4fee\u6539\u7f16\u53f7\u4e3a" + code + "\u7684\u6d3b\u52a8\u7684\u6b63\u5f0f\u8bb0\u5f55\u4e3a\u4e0d\u53ef\u7528\u51fa\u9519");
                    throw new BusinessLogicNotExpectedException("\u4fee\u6539\u6d3b\u52a8\u4e0a\u4e0b\u7ebf\u72b6\u6001\u51fa\u9519");
                }
                Campaign tempCampaign = this.campaignTempService.getCampaignByCode(code);
                if (tempCampaign instanceof DefaultCampaignImpl) {
                    DefaultCampaignImpl tempCampaignImpl = (DefaultCampaignImpl)tempCampaign;
                    tempCampaignImpl.setVersion(version + 1);
                    tempCampaignImpl.setCreatorId(campaign.getCreatorId());
                    Campaign afterCampaign = this.campaignDao.create(tempCampaignImpl);
                    Long afterCampaignId = afterCampaign.getId();
                    if (afterCampaignId == null) {
                        this.logger.error("\u62f7\u8d1d\u4e34\u65f6\u8bb0\u5f55\u5230\u6b63\u5f0f\u8bb0\u5f55\u8868\u5931\u8d25");
                        throw new BusinessLogicNotExpectedException("\u901a\u8fc7\u5ba1\u6279\u5931\u8d25");
                    }
                    Long beforeCampaignId = tempCampaign.getId();
                    if (!this.sectionService.changeCampaignId(beforeCampaignId, afterCampaignId, true).booleanValue()) {
                        this.logger.error("\u4fee\u6539\u7f16\u53f7\u4e3a" + code + "\u7684\u6d3b\u52a8\u7684\u4f18\u60e0\u533a\u95f4\u51fa\u9519");
                        throw new BusinessLogicNotExpectedException("\u901a\u8fc7\u5ba1\u6279\u5931\u8d25");
                    }
                    if (!this.campaignProductService.changeCampaignId(beforeCampaignId, afterCampaignId, true).booleanValue()) {
                        this.logger.error("\u4fee\u6539\u7f16\u53f7\u4e3a" + code + "\u7684\u6d3b\u52a8\u7684\u9002\u7528\u5546\u54c1\u51fa\u9519");
                        throw new BusinessLogicNotExpectedException("\u901a\u8fc7\u5ba1\u6279\u5931\u8d25");
                    }
                    if (!this.sectionProductService.changeCampaignId(beforeCampaignId, afterCampaignId, true).booleanValue()) {
                        this.logger.error("\u4fee\u6539\u7f16\u53f7\u4e3a" + code + "\u7684\u6d3b\u52a8\u7684\u989d\u5916\u5546\u54c1\u4fe1\u606f\u51fa\u9519");
                        throw new BusinessLogicNotExpectedException("\u901a\u8fc7\u5ba1\u6279\u5931\u8d25");
                    }
                    if (!this.campaignTempService.changeActiveByCode(code).booleanValue()) {
                        this.logger.error("\u4fee\u6539\u7f16\u53f7\u4e3a" + code + "\u7684\u6d3b\u52a8\u7684\u4e34\u65f6\u8bb0\u5f55\u4e3a\u4e0d\u53ef\u7528\u51fa\u9519");
                        throw new BusinessLogicNotExpectedException("\u4fee\u6539\u6d3b\u52a8\u4e0a\u4e0b\u7ebf\u72b6\u6001\u51fa\u9519");
                    }
                } else {
                    this.logger.error("\u4fee\u6539\u7f16\u53f7\u4e3a" + code + "\u7684\u6d3b\u52a8\u7684\u4e34\u65f6\u8bb0\u5f55\u975e\u6cd5");
                    throw new BusinessLogicNotExpectedException("\u901a\u8fc7\u5ba1\u6279\u5931\u8d25");
                }
            }
        }
        if (domain instanceof DefaultApprovalRecordImpl) {
            DefaultApprovalRecordImpl domainImpl = (DefaultApprovalRecordImpl)domain;
            domainImpl.setPendingId(campaign.getId());
            domain = domainImpl;
        }
        if (null != (newCampaignApproval = this.approvalRecordService.create(domain)) && null != newCampaignApproval.getId()) return true;
        this.logger.info("\u63d2\u5165\u6d3b\u52a8\u5ba1\u6279\u8bb0\u5f55\u5931\u8d25");
        throw new BusinessLogicNotExpectedException("\u63d2\u5165\u6d3b\u52a8\u5ba1\u6279\u8bb0\u5f55\u5931\u8d25");
    }

    @Override
    @Transactional
    public Boolean rejectPendingCampaign(ApprovalRecord domain) {
        ApprovalRecord newCampaignApproval;
        String code = domain.getPendingCode();
        Campaign campaign = this.campaignDao.getCampaignByCode(code);
        Integer stateId = campaign.getState().getId();
        Integer approvalStateId = campaign.getApprovalState().getId();
        if (!approvalStateId.equals(ApprovalState.WAIT_FOR_APPROVE.getId()) && !approvalStateId.equals(ApprovalState.APPROVING.getId())) {
            this.logger.error("\u7f16\u53f7\u4e3a" + campaign.getId() + "\u6d3b\u52a8\u5df2\u7533\u8bf7\u64a4\u56de\u5ba1\u6279\u6216\u5df2\u88ab\u5ba1\u6279");
            throw new BusinessLogicNotExpectedException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8be5\u6d3b\u52a8\u5df2\u7533\u8bf7\u64a4\u56de\u5ba1\u6279");
        }
        Integer level = 0;
        if (null != domain.getCouponApprovalLevel().getId()) {
            level = domain.getCouponApprovalLevel().getId();
        }
        if (stateId.equals(CampaignState.WAIT_FOR_ONLINE.getId())) {
            if (!this.campaignDao.changeCampaignApprovalState(code, ApprovalState.APPROVE_NOT_PASS).booleanValue()) {
                this.logger.error("\u4fee\u6539\u5ba1\u6279\u7b49\u7ea7\u4e3a\uff1a" + level + "\u7684\u6d3b\u52a8\u72b6\u6001\u4e3a[\u5ba1\u6279\u4e0d\u901a\u8fc7]\u5931\u8d25");
                throw new BusinessLogicNotExpectedException("\u4fee\u6539\u5ba1\u6279\u72b6\u6001\u5931\u8d25");
            }
        } else if (stateId.equals(CampaignState.ONLINE.getId()) || stateId.equals(CampaignState.OFFLINE.getId())) {
            if (!this.campaignTempService.changeCampaignApprovalState(code, ApprovalState.APPROVE_NOT_PASS).booleanValue()) {
                this.logger.error("\u4fee\u6539\u5ba1\u6279\u7b49\u7ea7\u4e3a\uff1a" + level + "\u7684\u4e34\u65f6\u6d3b\u52a8\u8bb0\u5f55\u72b6\u6001\u4e3a[\u5ba1\u6279\u4e0d\u901a\u8fc7]\u5931\u8d25");
                throw new BusinessLogicNotExpectedException("\u4fee\u6539\u5ba1\u6279\u72b6\u6001\u5931\u8d25");
            }
            Campaign tempCampaign = this.campaignTempService.getCampaignByCode(code);
            DefaultApprovalRecordImpl domainImpl = (DefaultApprovalRecordImpl)domain;
            Long tempCampaignId = tempCampaign.getId();
            domainImpl.setPendingId(tempCampaignId);
            domain = domainImpl;
            if (!this.campaignTempService.changeActiveByCode(code).booleanValue()) {
                this.logger.error("\u5c06\u5ba1\u6279\u7b49\u7ea7\u4e3a\uff1a" + level + "\u7684\u4e34\u65f6\u6d3b\u52a8\u8bb0\u5f55\u7f6e\u4e3a\u4e0d\u53ef\u7528\u5931\u8d25");
                throw new BusinessLogicNotExpectedException("\u4fee\u6539\u5ba1\u6279\u72b6\u6001\u5931\u8d25");
            }
            if (!this.campaignProductService.deleteByCampaignId(tempCampaignId, true).booleanValue()) {
                this.logger.error("\u5ba1\u6279\u4e0d\u901a\u8fc7\uff0c\u5220\u9664\u4e34\u65f6\u8bb0\u5f55\u5bf9\u5e94\u7684\u9002\u7528\u5546\u54c1\u3001\u7c7b\u76ee\u7b49\u5931\u8d25");
                throw new BusinessLogicNotExpectedException("\u4fee\u6539\u5ba1\u6279\u72b6\u6001\u5931\u8d25");
            }
            if (!this.sectionService.deleteByCampaignId(tempCampaignId, true).booleanValue()) {
                this.logger.error("\u5ba1\u6279\u4e0d\u901a\u8fc7\uff0c\u5220\u9664\u4e34\u65f6\u8bb0\u5f55\u5bf9\u5e94\u7684\u4f18\u60e0\u533a\u95f4\u5931\u8d25");
                throw new BusinessLogicNotExpectedException("\u4fee\u6539\u5ba1\u6279\u72b6\u6001\u5931\u8d25");
            }
            if (!this.sectionProductService.deleteByCampaignId(tempCampaignId, true).booleanValue()) {
                this.logger.error("\u5ba1\u6279\u4e0d\u901a\u8fc7\uff0c\u5220\u9664\u4e34\u65f6\u8bb0\u5f55\u5bf9\u5e94\u7684\u8d60\u54c1\u6216\u8005\u6362\u8d2d\u5546\u54c1\u5931\u8d25");
                throw new BusinessLogicNotExpectedException("\u4fee\u6539\u5ba1\u6279\u72b6\u6001\u5931\u8d25");
            }
            if (!this.campaignDao.changeCampaignApprovalState(code, ApprovalState.APPROVE_NOT_PASS).booleanValue()) {
                this.logger.error("\u4fee\u6539\u5ba1\u6279\u7b49\u7ea7\u4e3a\uff1a" + level + "\u7684\u6d3b\u52a8\u72b6\u6001\u4e3a[\u5ba1\u6279\u4e0d\u901a\u8fc7]\u5931\u8d25");
                throw new BusinessLogicNotExpectedException("\u4fee\u6539\u5ba1\u6279\u72b6\u6001\u5931\u8d25");
            }
        } else {
            this.logger.info("\u6d3b\u52a8\u72b6\u6001\u6709\u8bef");
            throw new BusinessLogicNotExpectedException("\u6d3b\u52a8\u72b6\u6001\u6709\u8bef");
        }
        if (domain instanceof DefaultApprovalRecordImpl) {
            DefaultApprovalRecordImpl domainImpl = (DefaultApprovalRecordImpl)domain;
            domainImpl.setPendingId(campaign.getId());
            domain = domainImpl;
        }
        if (null == (newCampaignApproval = this.approvalRecordService.create(domain)) || null == newCampaignApproval.getId()) {
            this.logger.info("\u63d2\u5165\u6d3b\u52a8\u5ba1\u6279\u8bb0\u5f55\u5931\u8d25");
            throw new BusinessLogicNotExpectedException("\u4fee\u6539\u5ba1\u6279\u72b6\u6001\u5931\u8d25");
        }
        return true;
    }
}

