/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.campaign.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.campaign.AddCampaign;
import com.thebeastshop.pegasus.component.campaign.CampaignProduct;
import com.thebeastshop.pegasus.component.campaign.CampaignSection;
import com.thebeastshop.pegasus.component.campaign.ConditionType;
import com.thebeastshop.pegasus.component.campaign.FactorTypeEnum;
import com.thebeastshop.pegasus.component.campaign.ProductScope;
import com.thebeastshop.pegasus.component.campaign.dao.CampaignDao;
import com.thebeastshop.pegasus.component.campaign.service.CampaignProductService;
import com.thebeastshop.pegasus.component.campaign.support.DefaultCampaignImpl;
import com.thebeastshop.pegasus.component.campaign.support.DefaultCampaignSectionImpl;
import com.thebeastshop.pegasus.component.category.service.CategoryService;
import com.thebeastshop.pegasus.component.discount.DiscountType;
import com.thebeastshop.pegasus.merchandise.service.McOpProductService;
import com.thebeastshop.support.AccessWay;
import com.thebeastshop.support.enums.MemberLevel;
import com.thebeastshop.support.exception.BusinessLogicNotExpectedException;
import com.thebeastshop.support.util.EnumUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BaseServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(BaseServiceImpl.class);
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private CampaignDao dao;
    @Autowired
    private CampaignProductService campaignProductService;
    @Autowired
    private McOpProductService opProductService;

    protected List<CampaignProduct> buildAllProductList(AddCampaign domain) {
        List<Long> categories;
        List<CampaignProduct> categoryList;
        if (null == domain) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        if (null != domain.getProductList()) {
            result.addAll(domain.getProductList());
        }
        if (null != (categoryList = this.buildCategoryList(categories = domain.getCategories()))) {
            result.addAll(categoryList);
        }
        return result;
    }

    private List<CampaignProduct> buildCategoryList(List<Long> categories) {
        if (CollectionUtils.isEmpty(categories)) {
            return null;
        }
        categories = this.categoryService.getTreeNode(categories);
        ArrayList result = Lists.newArrayList();
        for (Long categoryId : categories) {
            CampaignProduct product = new CampaignProduct();
            product.setBindingId(categoryId);
            product.setBindingType((CampaignProduct.BindingType)EnumUtil.valueOf((Comparable)Integer.valueOf(1), CampaignProduct.BindingType.class));
            product.setBlacklist(false);
            result.add(product);
        }
        return result;
    }

    protected List<CampaignProduct> buildNotBlackListProductList(List<CampaignProduct> productList) {
        if (null == productList) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (CampaignProduct item : productList) {
            if (item.isBlacklist().booleanValue()) continue;
            result.add(item);
        }
        return result;
    }

    private List<Long> buildProductIds(List<CampaignProduct> notBlacklist) {
        if (CollectionUtils.isEmpty(notBlacklist)) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (CampaignProduct campaignProduct : notBlacklist) {
            if (!campaignProduct.getBindingType().equals((Object)CampaignProduct.BindingType.PRODUCT)) continue;
            result.add(campaignProduct.getBindingId());
        }
        return result;
    }

    protected Boolean isExistsMutexCampaign(AddCampaign domain, List<CampaignProduct> notBlacklist) {
        if (null == domain) {
            return false;
        }
        Integer productScope = domain.getProductScope();
        List<Map<String, Object>> mutexCampaignIds = this.dao.getMutexCampaignIds(domain);
        if (CollectionUtils.isNotEmpty(mutexCampaignIds)) {
            if (!productScope.equals(ProductScope.GLOBAL.getId())) {
                String mutexCategoryStr;
                if (CollectionUtils.isNotEmpty(notBlacklist)) {
                    List<CampaignProduct> checkList = this.buildWhiteCategoryList(notBlacklist, mutexCampaignIds);
                    List<Map<String, Object>> mutexProduct = this.campaignProductService.getMutexProduct(notBlacklist, mutexCampaignIds);
                    if (CollectionUtils.isNotEmpty(mutexProduct)) {
                        String illegalStr = this.getIllegalStr(mutexProduct);
                        logger.error("\u5f85\u521b\u5efa\u6d3b\u52a8\u4e2d\u6307\u5b9a\u7684\u9002\u7528\u5546\u54c1\u3001\u7c7b\u76ee\u4e0e" + illegalStr + "\u6709\u4e92\u65a5");
                        throw new BusinessLogicNotExpectedException("\u5b58\u5728\u4e92\u65a5\u6d3b\u52a8<br/><font style='font-size:14px;font-weight:normal;'>\u9002\u7528\u5546\u54c1\u3001\u52fe\u9009\u7c7b\u76ee\u4e0e<br/>" + illegalStr + "\u6709\u4e92\u65a5</font>");
                    }
                    mutexProduct = this.campaignProductService.getMutexProduct(checkList, mutexCampaignIds);
                    if (CollectionUtils.isNotEmpty(mutexProduct)) {
                        String illegalStr = this.getIllegalStr(mutexProduct);
                        logger.error("\u5f85\u521b\u5efa\u6d3b\u52a8\u4e2d\u6307\u5b9a\u7684\u9002\u7528\u5546\u54c1\u6240\u5bf9\u5e94\u7684\u7c7b\u76ee\u4e0e" + illegalStr + "\u4e2d\u7684\u7c7b\u76ee\u6709\u4e92\u65a5");
                        throw new BusinessLogicNotExpectedException("\u5b58\u5728\u4e92\u65a5\u6d3b\u52a8<br/><font style='font-size:14px;font-weight:normal;'>\u9002\u7528\u5546\u54c1\u6240\u5bf9\u5e94\u7684\u7c7b\u76ee\u4e0e<br/>" + illegalStr + "\u6709\u4e92\u65a5</font>");
                    }
                }
                if ((mutexCategoryStr = this.findMutexCategory(domain, mutexCampaignIds)) != null && mutexCategoryStr.length() > 0) {
                    logger.error("\u5f85\u521b\u5efa\u6d3b\u52a8\u4e2d" + mutexCategoryStr);
                    throw new BusinessLogicNotExpectedException("\u5b58\u5728\u4e92\u65a5<br/><font style='font-size:14px;font-weight:normal;'>" + mutexCategoryStr + "\u4e2d\u6307\u5b9a\u9002\u7528\u5546\u54c1\u6240\u5bf9\u5e94\u7684\u7c7b\u76ee\u6709\u4e92\u65a5</font>");
                }
            } else {
                StringBuilder sb = new StringBuilder();
                for (Map<String, Object> item : mutexCampaignIds) {
                    sb.append(item.get("id") + ",");
                }
                String info = sb.substring(0, sb.length() - 1);
                logger.error("\u5f85\u521b\u5efa\u6d3b\u52a8\u4e0e\u7f16\u53f7\u4e3a:" + info + "\u6d3b\u52a8\u5b58\u5728\u4e92\u65a5");
                throw new BusinessLogicNotExpectedException("\u4e0e\u7f16\u53f7\u4e3a:" + info + "\u7684\u5168\u573a\u6d3b\u52a8\u5b58\u5728\u4e92\u65a5");
            }
        }
        return false;
    }

    protected void checkIsExistsMutexAdvance(AddCampaign domain, List<CampaignProduct> notBlacklist) {
        if (domain == null) {
            throw new BusinessLogicNotExpectedException("\u53c2\u6570\u975e\u6cd5");
        }
        List<Map<String, Object>> mutexAdvanceCampaign = this.dao.getMutexAdvanceCampaign(domain);
        if (CollectionUtils.isNotEmpty(mutexAdvanceCampaign)) {
            Integer productScope = domain.getProductScope();
            if (!productScope.equals(ProductScope.GLOBAL.getId())) {
                List<CampaignProduct> checkList = this.buildWhiteCategoryList(notBlacklist, mutexAdvanceCampaign);
                List<Map<String, Object>> mutexProduct = this.campaignProductService.getMutexProduct(notBlacklist, mutexAdvanceCampaign);
                if (CollectionUtils.isNotEmpty(mutexProduct)) {
                    String illegalStr = this.getIllegalStr(mutexProduct);
                    logger.error("\u5f85\u521b\u5efa\u6d3b\u52a8\u4e2d\u6307\u5b9a\u7684\u9002\u7528\u5546\u54c1\u3001\u7c7b\u76ee\u4e0e" + illegalStr + "\u6709\u9884\u544a\u51b2\u7a81");
                    throw new BusinessLogicNotExpectedException("\u5b58\u5728\u51b2\u7a81\u6d3b\u52a8\u9884\u544a<br/><font style='font-size:14px;font-weight:normal;'>\u9002\u7528\u5546\u54c1\u3001\u52fe\u9009\u7c7b\u76ee\u4e0e<br/>" + illegalStr + "\u6709\u9884\u544a\u51b2\u7a81</font>");
                }
                mutexProduct = this.campaignProductService.getMutexProduct(checkList, mutexAdvanceCampaign);
                if (CollectionUtils.isNotEmpty(mutexProduct)) {
                    String illegalStr = this.getIllegalStr(mutexProduct);
                    logger.error("\u5f85\u521b\u5efa\u6d3b\u52a8\u4e2d\u6307\u5b9a\u7684\u9002\u7528\u5546\u54c1\u6240\u5bf9\u5e94\u7684\u7c7b\u76ee\u4e0e" + illegalStr + "\u4e2d\u7684\u7c7b\u76ee\u6709\u9884\u544a\u51b2\u7a81");
                    throw new BusinessLogicNotExpectedException("\u5b58\u5728\u4e92\u65a5\u6d3b\u52a8<br/><font style='font-size:14px;font-weight:normal;'>\u9002\u7528\u5546\u54c1\u6240\u5bf9\u5e94\u7684\u7c7b\u76ee\u4e0e<br/>" + illegalStr + "\u6709\u9884\u544a\u51b2\u7a81</font>");
                }
                String mutexCategoryStr = this.findMutexCategory(domain, mutexAdvanceCampaign);
                if (mutexCategoryStr != null && mutexCategoryStr.length() > 0) {
                    logger.error("\u5f85\u521b\u5efa\u6d3b\u52a8\u4e2d" + mutexCategoryStr);
                    throw new BusinessLogicNotExpectedException("\u5b58\u5728\u9884\u544a\u51b2\u7a81<br/><font style='font-size:14px;font-weight:normal;'>" + mutexCategoryStr + "\u4e2d\u6307\u5b9a\u9002\u7528\u5546\u54c1\u6240\u5bf9\u5e94\u7684\u7c7b\u76ee\u6709\u51b2\u7a81</font>");
                }
            } else {
                StringBuilder sb = new StringBuilder();
                for (Map<String, Object> item : mutexAdvanceCampaign) {
                    sb.append(item.get("id") + ",");
                }
                String info = sb.substring(0, sb.length() - 1);
                logger.error("\u5f85\u521b\u5efa\u6d3b\u52a8\u9884\u544a\u4e0e\u7f16\u53f7\u4e3a:" + info + "\u6d3b\u52a8\u9884\u544a\u51b2\u7a81");
                throw new BusinessLogicNotExpectedException("\u4e0e\u7f16\u53f7\u4e3a:" + info + "\u7684\u5168\u573a\u6d3b\u52a8\u9884\u544a\u51b2\u7a81");
            }
        }
    }

    private List<CampaignProduct> buildWhiteCategoryList(List<CampaignProduct> notBlacklist, List<Map<String, Object>> mutexCampaign) {
        List<Long> selectedCategoryList = this.campaignProductService.getSelectedCategoryListNoBlack(this.buildProductIds(notBlacklist), mutexCampaign);
        ArrayList checkList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(selectedCategoryList)) {
            for (Long item : selectedCategoryList) {
                CampaignProduct product = new CampaignProduct();
                product.setBindingId(item);
                product.setBindingType(CampaignProduct.BindingType.CATEGORY);
                product.setBlacklist(false);
                checkList.add(product);
            }
        }
        return checkList;
    }

    private String findMutexCategory(AddCampaign domain, List<Map<String, Object>> mutexCampaign) {
        List<Long> categories;
        if (domain.getProductScope().equals(ProductScope.MULTI.getId()) && CollectionUtils.isNotEmpty(categories = domain.getCategories())) {
            List<Map<String, Object>> resultList = this.campaignProductService.getExistsCategoryList(mutexCampaign);
            HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>();
            for (Map<String, Object> item : resultList) {
                resultMap.put(item.get("categoryId").toString(), item);
            }
            StringBuilder sb = new StringBuilder();
            for (Long category : categories) {
                Map item = (Map)resultMap.get(category.toString());
                if (item == null) continue;
                sb.append("\u52fe\u9009\u7c7b\u76ee").append(item.get("categoryId")).append("\u4e0e\u7f16\u53f7\u4e3a");
                sb.append(item.get("campaignId")).append("\u7684\u6d3b\u52a8");
                sb.append(Integer.parseInt(item.get("temp").toString()) == 1 ? "\u4e34\u65f6\u8bb0\u5f55<br/>" : "<br/>");
            }
            return sb.toString();
        }
        return null;
    }

    private String getIllegalStr(List<Map<String, Object>> mutexProduct) {
        StringBuilder sb = new StringBuilder();
        for (Map<String, Object> item : mutexProduct) {
            Long campaignId = (Long)item.get("campaignId");
            Integer bindingType = (Integer)item.get("bindingType");
            Long bindingId = (Long)item.get("bindingId");
            Integer temp = (Integer)item.get("temp");
            sb.append("\u7f16\u53f7\u4e3a").append(campaignId);
            sb.append("\u6d3b\u52a8");
            if (temp.equals(1)) {
                sb.append("\u4e34\u65f6\u8bb0\u5f55");
            }
            sb.append("\u4e2d\u7684");
            if (bindingType.equals(CampaignProduct.BindingType.CATEGORY.getId())) {
                sb.append("\u7c7b\u76ee").append(this.categoryService.getCodeById(bindingId)).append("<br/>");
                continue;
            }
            if (!bindingType.equals(CampaignProduct.BindingType.PRODUCT.getId())) continue;
            sb.append("\u5546\u54c1").append(this.opProductService.getCodeById(bindingId)).append("<br/>");
        }
        return sb.toString();
    }

    private void checkIsIllegal(AddCampaign domain, List<CampaignProduct> notBlacklist, Integer need2CheckProductScope, Integer checkType, String info) {
        if (CollectionUtils.isNotEmpty(notBlacklist)) {
            for (CampaignProduct item : notBlacklist) {
                if (!this.dao.checkDiscountIsIllegal(checkType, need2CheckProductScope, item.getBindingId(), domain).booleanValue()) continue;
                String productCode = this.opProductService.getCodeById(item.getBindingId());
                logger.info("Product\u7f16\u7801\u4e3a:" + productCode + "\u5df2\u5728\u5176\u4ed6\u6d3b\u52a8\u4e2d\u8bbe\u7f6e\u4e86" + info + ",\u6d3b\u52a8\u521b\u5efa\u5931\u8d25");
                throw new BusinessLogicNotExpectedException("Product\u7f16\u7801\u4e3a: " + productCode + " \u5df2\u5728\u5176\u4ed6\u6d3b\u52a8\u4e2d\u8bbe\u7f6e\u4e86" + info + ",\u6d3b\u52a8\u521b\u5efa\u5931\u8d25");
            }
        }
    }

    protected void checkDiscountIsIllegal(AddCampaign domain, List<CampaignProduct> notBlacklist) {
        if (null != domain && domain.getDiscountType() == 1 && CollectionUtils.isNotEmpty(domain.getSectionList())) {
            Integer need2CheckProductScope = domain.getProductScope().equals(1) ? 2 : 1;
            Integer checkType = 2;
            FactorTypeEnum factorType = domain.getSectionList().get(0).getFactorType();
            if (domain.getProductScope().equals(ProductScope.SINGLE.getId()) && factorType.getId().equals(FactorTypeEnum.DISCOUNT.getId())) {
                this.checkIsIllegal(domain, notBlacklist, need2CheckProductScope, checkType, "\u56fa\u5b9a\u4ef7\u683c");
            }
            if (factorType.getId().equals(FactorTypeEnum.FIXED_AMOUNT.getId())) {
                this.checkIsIllegal(domain, notBlacklist, need2CheckProductScope, checkType, "\u56fa\u5b9a\u4ef7\u683c");
            }
            if (domain.getProductScope().equals(ProductScope.MULTI.getId()) && factorType.getId().equals(FactorTypeEnum.FIXED_AMOUNT.getId())) {
                checkType = 1;
                this.checkIsIllegal(domain, notBlacklist, need2CheckProductScope, checkType, "\u7edf\u4e00\u6298\u6263");
            }
        }
    }

    protected static DefaultCampaignImpl buildCampaign(AddCampaign obj) {
        DefaultCampaignImpl domain = new DefaultCampaignImpl();
        domain.setId(obj.getId());
        if (null != obj.getDiscountType()) {
            domain.setDiscountType((DiscountType)EnumUtil.valueOf((Comparable)obj.getDiscountType(), DiscountType.class));
        }
        domain.setCode(obj.getCode());
        domain.setName(obj.getName());
        domain.setDescription(obj.getTitle());
        domain.setStartTime(obj.getStartTime());
        domain.setExpireTime(obj.getExpireTime());
        domain.setCrossBorderFlag(obj.getCrossBorderFlag());
        domain.setAdvance(obj.getAdvance());
        domain.setAdvanceName(obj.getAdvanceName());
        domain.setAdvanceTitle(obj.getAdvanceTitle());
        domain.setAdvanceStartTime(obj.getAdvanceStartTime());
        domain.setAdvanceEndTime(obj.getAdvanceEndTime());
        domain.setAdvancePriceTitle(obj.getAdvancePriceTitle());
        if (CollectionUtils.isNotEmpty(obj.getAccessWays())) {
            ArrayList accessWays = Lists.newArrayList();
            for (Integer item : obj.getAccessWays()) {
                accessWays.add(EnumUtil.valueOf((Comparable)item, AccessWay.class));
            }
            domain.setAccessWays(accessWays);
        }
        if (CollectionUtils.isNotEmpty(obj.getMemberLevels())) {
            ArrayList memberLevels = Lists.newArrayList();
            for (Integer item : obj.getMemberLevels()) {
                memberLevels.add(EnumUtil.valueOf((Comparable)item, MemberLevel.class));
            }
            domain.setMemberLevels(memberLevels);
        }
        if (null != obj.getProductScope()) {
            domain.setProductScope((ProductScope)EnumUtil.valueOf((Comparable)obj.getProductScope(), ProductScope.class));
        }
        domain.setCumulative(obj.getCumulative());
        domain.setCreatorId(obj.getCreatorId());
        if (obj.getVersion() != null) {
            domain.setVersion(obj.getVersion());
        } else {
            domain.setVersion(0);
        }
        return domain;
    }

    protected static List<CampaignSection> buildCampaignSection(AddCampaign obj, Long campaignId, Boolean isTemp) {
        if (CollectionUtils.isNotEmpty(obj.getSectionList())) {
            Integer discountType = obj.getDiscountType();
            List<CampaignSection> sectionList = obj.getSectionList();
            for (int i = 0; i < sectionList.size(); ++i) {
                CampaignSection section = sectionList.get(i);
                if (!(section instanceof DefaultCampaignSectionImpl)) continue;
                DefaultCampaignSectionImpl sectionImpl = (DefaultCampaignSectionImpl)section;
                if (discountType.equals(DiscountType.OFF.getId())) {
                    sectionImpl.setCampaignId(campaignId);
                    sectionImpl.setConditionType((ConditionType)EnumUtil.valueOf((Comparable)Integer.valueOf(1), ConditionType.class));
                    sectionImpl.setLine(BigDecimal.ZERO);
                } else {
                    sectionImpl.setCampaignId(campaignId);
                }
                sectionImpl.setRanking(i + 1);
                if (isTemp.booleanValue()) {
                    sectionImpl.setTemp(1);
                    continue;
                }
                sectionImpl.setTemp(0);
            }
        }
        return obj.getSectionList();
    }
}

