/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.campaign.dao.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.campaign.AddCampaign;
import com.thebeastshop.pegasus.component.campaign.ApprovalState;
import com.thebeastshop.pegasus.component.campaign.Campaign;
import com.thebeastshop.pegasus.component.campaign.CampaignState;
import com.thebeastshop.pegasus.component.campaign.ConditionType;
import com.thebeastshop.pegasus.component.campaign.FactorTypeEnum;
import com.thebeastshop.pegasus.component.campaign.ProductScope;
import com.thebeastshop.pegasus.component.campaign.dao.CampaignTempDao;
import com.thebeastshop.pegasus.component.campaign.dao.mapper.CampaignProductEntityMapper;
import com.thebeastshop.pegasus.component.campaign.dao.mapper.CampaignTempEntityMapper;
import com.thebeastshop.pegasus.component.campaign.model.CampaignProductEntity;
import com.thebeastshop.pegasus.component.campaign.model.CampaignSectionEntity;
import com.thebeastshop.pegasus.component.campaign.model.CampaignSectionProductEntity;
import com.thebeastshop.pegasus.component.campaign.model.CampaignTempEntity;
import com.thebeastshop.pegasus.component.campaign.model.CampaignTempEntityExample;
import com.thebeastshop.pegasus.component.campaign.support.DefaultCampaignImpl;
import com.thebeastshop.pegasus.component.campaign.support.DefaultCampaignSectionImpl;
import com.thebeastshop.pegasus.component.campaign.support.DefaultCampaignSectionProductImpl;
import com.thebeastshop.pegasus.component.discount.DiscountType;
import com.thebeastshop.support.AccessWay;
import com.thebeastshop.support.enums.MemberLevel;
import com.thebeastshop.support.mark.State;
import com.thebeastshop.support.util.EnumUtil;
import com.thebeastshop.support.util.IdUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CampaignTempDaoImpl
implements CampaignTempDao {
    private static final Logger logger = LoggerFactory.getLogger(CampaignTempDaoImpl.class);
    @Autowired
    private CampaignTempEntityMapper mapper;
    @Autowired
    private CampaignProductEntityMapper campaignProductEntityMapper;

    private CampaignTempEntity domain2Entity(Campaign domain) {
        if (domain != null) {
            CampaignTempEntity entity = new CampaignTempEntity();
            entity.setId(domain.getId());
            entity.setCode(domain.getCode());
            entity.setVersion(domain.getVersion());
            entity.setCreateTime(domain.getCreateTime());
            entity.setTitle(domain.getDescription());
            if (null != domain.getAccessWays()) {
                entity.setAccessWay("," + Joiner.on((String)",").join((Iterable)IdUtil.toIds(domain.getAccessWays())) + ",");
            }
            entity.setCumulative(domain.isCumulative());
            if (domain.getDiscountType() != null) {
                entity.setDiscountType(domain.getDiscountType().getId());
                if (null != domain.getMemberLevels()) {
                    entity.setMemberLevel("," + Joiner.on((String)",").join((Iterable)IdUtil.toIds(domain.getMemberLevels())) + ",");
                }
            }
            entity.setName(domain.getName());
            if (null != domain.getProductScope()) {
                entity.setProductScope(domain.getProductScope().getId());
            }
            entity.setCreatorId(domain.getCreatorId());
            entity.setStartTime(domain.getStartTime());
            entity.setExpireTime(domain.getExpireTime());
            if (null == domain.getState()) {
                entity.setState(0);
            } else {
                entity.setState(domain.getState().getId());
            }
            if (null == domain.getApprovalState()) {
                entity.setApprovalState(0);
            } else {
                entity.setApprovalState(domain.getApprovalState().getId());
            }
            entity.setCrossBorderFlag(domain.getCrossBorderFlag());
            entity.setIsAdvance(domain.getAdvance());
            entity.setAdvanceName(domain.getAdvanceName());
            entity.setAdvanceTitle(domain.getAdvanceTitle());
            entity.setAdvanceStartTime(domain.getAdvanceStartTime());
            entity.setAdvanceEndTime(domain.getAdvanceEndTime());
            entity.setAdvancePriceTitle(domain.getAdvancePriceTitle());
            return entity;
        }
        return null;
    }

    private Campaign entity2Domain(CampaignTempEntity entity) {
        if (entity != null) {
            DefaultCampaignImpl campaign = new DefaultCampaignImpl();
            campaign.setId(entity.getId());
            campaign.setCode(entity.getCode());
            campaign.setVersion(entity.getVersion());
            campaign.setCreateTime(entity.getCreateTime());
            campaign.setDescription(entity.getTitle());
            campaign.setCrossBorderFlag(entity.getCrossBorderFlag());
            if (entity.getAccessWay() != null) {
                String[] strAccessWays = entity.getAccessWay().split(",");
                ArrayList accessWays = Lists.newArrayList();
                for (String s : strAccessWays) {
                    if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{s})) continue;
                    accessWays.add(EnumUtil.valueOf((Comparable)Integer.valueOf(s), AccessWay.class));
                }
                campaign.setAccessWays(accessWays);
            }
            campaign.setCumulative(entity.getCumulative());
            if (entity.getDiscountType() != null) {
                campaign.setDiscountType((DiscountType)EnumUtil.valueOf((Comparable)entity.getDiscountType(), DiscountType.class));
            }
            if (entity.getMemberLevel() != null) {
                String[] strMemberLevels = entity.getMemberLevel().split(",");
                ArrayList memberLevels = Lists.newArrayList();
                for (String s : strMemberLevels) {
                    if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{s})) continue;
                    memberLevels.add(EnumUtil.valueOf((Comparable)Integer.valueOf(s), MemberLevel.class));
                }
                campaign.setMemberLevels(memberLevels);
            }
            campaign.setName(entity.getName());
            if (entity.getProductScope() != null) {
                campaign.setProductScope((ProductScope)EnumUtil.valueOf((Comparable)entity.getProductScope(), ProductScope.class));
            }
            campaign.setStartTime(entity.getStartTime());
            campaign.setExpireTime(entity.getExpireTime());
            campaign.setState((State)EnumUtil.valueOf((Comparable)entity.getState(), CampaignState.class));
            if (null != entity.getApprovalState()) {
                campaign.setApprovalState((State)EnumUtil.valueOf((Comparable)entity.getApprovalState(), ApprovalState.class));
            }
            campaign.setAdvance(entity.getIsAdvance());
            campaign.setAdvanceName(entity.getAdvanceName());
            campaign.setAdvanceTitle(entity.getAdvanceTitle());
            campaign.setAdvanceStartTime(entity.getAdvanceStartTime());
            campaign.setAdvanceEndTime(entity.getAdvanceEndTime());
            campaign.setAdvancePriceTitle(entity.getAdvancePriceTitle());
            new CampaignProductEntity();
            campaign.setCampaignProducts(CampaignProductEntity.convert2DomainList(this.campaignProductEntityMapper.getProductsByCampaignId(entity.getId(), 1)));
            if (CollectionUtils.isNotEmpty(entity.getCampaignSections())) {
                ArrayList sections = Lists.newArrayList();
                List<CampaignSectionEntity> sectionEntities = entity.getCampaignSections();
                for (CampaignSectionEntity item : sectionEntities) {
                    DefaultCampaignSectionImpl section = new DefaultCampaignSectionImpl();
                    section.setCampaignId(item.getCampaignId());
                    section.setId(item.getId());
                    if (null != item && null != item.getType()) {
                        section.setConditionType((ConditionType)EnumUtil.valueOf((Comparable)item.getType(), ConditionType.class));
                    }
                    section.setLine(item.getLine());
                    if (null != item.getFactorType()) {
                        section.setFactorType((FactorTypeEnum)EnumUtil.valueOf((Comparable)item.getFactorType(), FactorTypeEnum.class));
                    }
                    section.setFactor(item.getFactor());
                    section.setRanking(item.getSort().floatValue());
                    if (CollectionUtils.isNotEmpty(item.getCampaignSectionProducts())) {
                        ArrayList sectionProducts = Lists.newArrayList();
                        List<CampaignSectionProductEntity> sectionProductEntities = item.getCampaignSectionProducts();
                        for (CampaignSectionProductEntity sectionProductEntity : sectionProductEntities) {
                            DefaultCampaignSectionProductImpl product = new DefaultCampaignSectionProductImpl();
                            product.setId(sectionProductEntity.getId());
                            product.setCampaignId(sectionProductEntity.getCampaignId());
                            product.setCampaignSectionId(sectionProductEntity.getCampaignSectionId());
                            product.setAdditionalProductId(sectionProductEntity.getAdditionalProductId());
                            product.setAdditionalProductPrice(sectionProductEntity.getAdditionalProductPrice());
                            product.setAdditionalProductCount(sectionProductEntity.getAdditionalProductCount());
                            product.setRanking(sectionProductEntity.getSort().floatValue());
                            product.setProductCode(sectionProductEntity.getProductCode());
                            product.setProductName(sectionProductEntity.getProductName());
                            sectionProducts.add(product);
                        }
                        section.setCampaignSectionProducts(sectionProducts);
                    }
                    sections.add(section);
                }
                campaign.setCampaignSections(sections);
            }
            campaign.setCreatorName(entity.getCreatorName());
            campaign.setTemp(true);
            return campaign;
        }
        return null;
    }

    @Override
    public Boolean revoke(String code) {
        CampaignTempEntity entity = new CampaignTempEntity();
        entity.setActive(0);
        CampaignTempEntityExample example = new CampaignTempEntityExample();
        example.createCriteria().andCodeEqualTo(code).andActiveEqualTo(1);
        return this.mapper.updateByExampleSelective(entity, example) > 0;
    }

    @Override
    public Campaign create(Campaign campaign) {
        logger.info("creating campaign:" + campaign);
        CampaignTempEntity entity = this.domain2Entity(campaign);
        if (this.mapper.insertSelective(entity) > 0) {
            Campaign domain = this.entity2Domain(entity);
            logger.info("created campaign temp:" + campaign);
            return domain;
        }
        return null;
    }

    @Override
    public Campaign getCampaignByCode(String code) {
        CampaignTempEntityExample example = new CampaignTempEntityExample();
        example.createCriteria().andCodeEqualTo(code).andActiveEqualTo(1);
        List<CampaignTempEntity> campaignTempEntities = this.mapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(campaignTempEntities)) {
            return this.entity2Domain(campaignTempEntities.get(0));
        }
        return null;
    }

    @Override
    public Campaign getCampaignDetailByCode(String code) {
        return this.entity2Domain(this.mapper.getCampaignDetailByCode(code));
    }

    @Override
    public Integer update(DefaultCampaignImpl campaign) {
        CampaignTempEntity entity = this.domain2Entity(campaign);
        CampaignTempEntityExample example = new CampaignTempEntityExample();
        example.createCriteria().andCodeEqualTo(entity.getCode()).andActiveEqualTo(1);
        return this.mapper.updateByExampleSelective(entity, example);
    }

    @Override
    public Integer changeCampaignApprovalState(String code, ApprovalState approving) {
        CampaignTempEntity entity = new CampaignTempEntity();
        entity.setApprovalState(approving.getId());
        CampaignTempEntityExample example = new CampaignTempEntityExample();
        example.createCriteria().andCodeEqualTo(code).andActiveEqualTo(1);
        return this.mapper.updateByExampleSelective(entity, example);
    }

    @Override
    public Integer agreeSecondApproval(String code) {
        CampaignTempEntity entity = new CampaignTempEntity();
        entity.setState(CampaignState.ONLINE.getId());
        entity.setApprovalState(ApprovalState.APPROVAL_PASS.getId());
        CampaignTempEntityExample example = new CampaignTempEntityExample();
        example.createCriteria().andCodeEqualTo(code).andActiveEqualTo(1);
        return this.mapper.updateByExampleSelective(entity, example);
    }

    @Override
    public Integer changeActiveByCode(String code) {
        CampaignTempEntity entity = new CampaignTempEntity();
        entity.setActive(0);
        CampaignTempEntityExample example = new CampaignTempEntityExample();
        example.createCriteria().andCodeEqualTo(code).andActiveEqualTo(1);
        return this.mapper.updateByExampleSelective(entity, example);
    }

    @Override
    public Campaign getCampaignById(Long id) {
        return this.entity2Domain(this.mapper.selectByPrimaryKey(id));
    }

    @Override
    public Integer updateSelective(AddCampaign campaign) {
        CampaignTempEntity entity = new CampaignTempEntity();
        entity.setName(campaign.getName());
        entity.setTitle(campaign.getTitle());
        entity.setId(campaign.getId());
        return this.mapper.updateByPrimaryKeySelective(entity);
    }
}

