/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.campaign.dao.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.campaign.CampaignSectionProduct;
import com.thebeastshop.pegasus.component.campaign.dao.CampaignSectionProductDao;
import com.thebeastshop.pegasus.component.campaign.dao.mapper.CampaignSectionProductEntityMapper;
import com.thebeastshop.pegasus.component.campaign.model.CampaignEntity;
import com.thebeastshop.pegasus.component.campaign.model.CampaignSectionProductEntity;
import com.thebeastshop.pegasus.component.campaign.model.CampaignSectionProductEntityExample;
import com.thebeastshop.pegasus.component.campaign.support.DefaultCampaignSectionProductImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CampaignSectionProductDaoImpl
implements CampaignSectionProductDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CampaignSectionProductEntityMapper mapper;

    private CampaignSectionProduct entity2Domain(CampaignSectionProductEntity entity) {
        if (entity != null) {
            DefaultCampaignSectionProductImpl domain = new DefaultCampaignSectionProductImpl();
            domain.setCampaignId(entity.getCampaignId());
            domain.setAdditionalProductCount(entity.getAdditionalProductCount());
            domain.setAdditionalProductId(entity.getAdditionalProductId());
            domain.setAdditionalProductPrice(entity.getAdditionalProductPrice());
            domain.setCampaignSectionId(entity.getCampaignSectionId());
            domain.setId(entity.getId());
            domain.setRanking(entity.getSort().floatValue());
            return domain;
        }
        return null;
    }

    private List<CampaignSectionProduct> entity2Domain(List<CampaignSectionProductEntity> entities) {
        ArrayList list = Lists.newArrayList();
        for (CampaignSectionProductEntity entity : entities) {
            list.add(this.entity2Domain(entity));
        }
        return list;
    }

    private CampaignSectionProductEntity domain2Entity(CampaignSectionProduct domain) {
        if (domain != null) {
            CampaignSectionProductEntity entity = new CampaignSectionProductEntity();
            entity.setCampaignId(domain.getCampaignId());
            entity.setAdditionalProductCount(domain.getAdditionalProductCount());
            entity.setAdditionalProductId(domain.getAdditionalProductId());
            entity.setAdditionalProductPrice(domain.getAdditionalProductPrice());
            entity.setCampaignSectionId(domain.getCampaignSectionId());
            entity.setId(domain.getId());
            entity.setSort(Float.valueOf((float)domain.getRanking()));
            entity.setTemp(domain.getTemp());
            return entity;
        }
        return null;
    }

    @Override
    public List<CampaignSectionProduct> findByCampaignSectionId(long campaignSectionId) {
        CampaignSectionProductEntityExample example = new CampaignSectionProductEntityExample();
        example.createCriteria().andCampaignSectionIdEqualTo(campaignSectionId);
        List<CampaignSectionProductEntity> entities = this.mapper.selectByExample(example);
        Collections.sort(entities, new Comparator<CampaignSectionProductEntity>(){

            @Override
            public int compare(CampaignSectionProductEntity o1, CampaignSectionProductEntity o2) {
                return o1.getSort().compareTo(o2.getSort());
            }
        });
        return this.entity2Domain(entities);
    }

    @Override
    public CampaignSectionProduct create(CampaignSectionProduct obj) {
        this.logger.info("creating CampaignSectionProduct:" + obj);
        CampaignSectionProductEntity entity = this.domain2Entity(obj);
        if (this.mapper.insertSelective(entity) > 0) {
            obj = this.entity2Domain(entity);
            this.logger.info("created CampaignSectionProduct:" + obj);
            return obj;
        }
        return null;
    }

    @Override
    @Transactional
    public Integer create(List<CampaignSectionProduct> objs) {
        this.logger.info("creating campaignSectionProducts:" + objs);
        if (CollectionUtils.isEmpty(objs)) {
            return -1;
        }
        ArrayList list = Lists.newArrayList();
        for (CampaignSectionProduct obj : objs) {
            list.add(this.domain2Entity(obj));
        }
        Integer result = this.mapper.bachCreate(list);
        if (result > 0) {
            this.logger.info("created campaignSectionProducts:" + objs);
        }
        return result;
    }

    @Override
    public int getBalanceCount(CampaignSectionProduct product) {
        Integer assignedCount = this.mapper.getAssignedCount(product.getAdditionalProductId());
        if (assignedCount == null) {
            assignedCount = 0;
        }
        return product.getAdditionalProductCount() - assignedCount;
    }

    @Override
    public List<String> getSameAdditionalProductCount(CampaignEntity entity, List<CampaignSectionProduct> sectionProductList) {
        if (CollectionUtils.isEmpty(sectionProductList)) {
            return null;
        }
        List<String> result = this.mapper.getSameAdditionalProductCount(entity, sectionProductList);
        result.addAll(this.mapper.getSameTempAdditionalProductCount(entity, sectionProductList));
        return result;
    }

    @Override
    public Integer deleteByCampaignId(Long campaignId, Integer temp) {
        CampaignSectionProductEntityExample example = new CampaignSectionProductEntityExample();
        example.createCriteria().andCampaignIdEqualTo(campaignId).andTempEqualTo(temp);
        return this.mapper.deleteByExample(example);
    }

    @Override
    public Integer changeCampaignId(Long oldId, Long newId, Integer temp) {
        CampaignSectionProductEntity entity = new CampaignSectionProductEntity();
        entity.setCampaignId(newId);
        entity.setTemp(0);
        CampaignSectionProductEntityExample example = new CampaignSectionProductEntityExample();
        example.createCriteria().andCampaignIdEqualTo(oldId).andTempEqualTo(temp);
        return this.mapper.updateByExampleSelective(entity, example);
    }
}

