/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.campaign.dao.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.campaign.CampaignSection;
import com.thebeastshop.pegasus.component.campaign.ConditionType;
import com.thebeastshop.pegasus.component.campaign.FactorTypeEnum;
import com.thebeastshop.pegasus.component.campaign.dao.CampaignSectionDao;
import com.thebeastshop.pegasus.component.campaign.dao.CampaignSectionProductDao;
import com.thebeastshop.pegasus.component.campaign.dao.mapper.CampaignSectionEntityMapper;
import com.thebeastshop.pegasus.component.campaign.model.CampaignSectionEntity;
import com.thebeastshop.pegasus.component.campaign.model.CampaignSectionEntityExample;
import com.thebeastshop.pegasus.component.campaign.support.DefaultCampaignSectionImpl;
import com.thebeastshop.support.util.EnumUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CampaignSectionDaoImpl
implements CampaignSectionDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CampaignSectionEntityMapper mapper;
    @Autowired
    private CampaignSectionProductDao campaignSectionProductDao;

    private CampaignSection entity2Domain(CampaignSectionEntity entity) {
        if (entity != null) {
            DefaultCampaignSectionImpl domain = new DefaultCampaignSectionImpl();
            domain.setCampaignSectionProducts(this.campaignSectionProductDao.findByCampaignSectionId(entity.getId()));
            domain.setConditionType((ConditionType)EnumUtil.valueOf((Comparable)entity.getType(), ConditionType.class));
            domain.setFactorType((FactorTypeEnum)EnumUtil.valueOf((Comparable)entity.getFactorType(), FactorTypeEnum.class));
            domain.setFactor(entity.getFactor());
            domain.setId(entity.getId());
            domain.setLine(entity.getLine());
            domain.setRanking(entity.getSort().floatValue());
            domain.setCampaignId(entity.getCampaignId());
            return domain;
        }
        return null;
    }

    @Override
    public List<CampaignSection> entity2Domain(List<CampaignSectionEntity> entities) {
        ArrayList list = Lists.newArrayList();
        for (CampaignSectionEntity entity : entities) {
            list.add(this.entity2Domain(entity));
        }
        return list;
    }

    public CampaignSectionEntity domain2Entity(CampaignSection domain) {
        if (domain != null) {
            CampaignSectionEntity entity = new CampaignSectionEntity();
            if (null != domain.getConditionType()) {
                entity.setType(domain.getConditionType().getId());
            }
            if (null != domain.getFactorType()) {
                entity.setFactorType(domain.getFactorType().getId());
            } else {
                entity.setFactorType(1);
            }
            entity.setFactor(domain.getFactor());
            entity.setId(domain.getId());
            entity.setLine(domain.getLine());
            entity.setSort(Float.valueOf((float)domain.getRanking()));
            entity.setCampaignId(domain.getCampaignId());
            entity.setTemp(domain.getTemp());
            return entity;
        }
        return null;
    }

    @Override
    public List<CampaignSection> findByCampaignId(long campaignId) {
        CampaignSectionEntityExample example = new CampaignSectionEntityExample();
        example.createCriteria().andCampaignIdEqualTo(campaignId);
        List<CampaignSectionEntity> entities = this.mapper.selectByExample(example);
        Collections.sort(entities, new Comparator<CampaignSectionEntity>(){

            @Override
            public int compare(CampaignSectionEntity o1, CampaignSectionEntity o2) {
                return o1.getSort().compareTo(o2.getSort());
            }
        });
        return this.entity2Domain(entities);
    }

    @Override
    public CampaignSection create(CampaignSection obj) {
        this.logger.info("creating campaignSection:" + obj);
        CampaignSectionEntity entity = this.domain2Entity(obj);
        if (this.mapper.insertSelective(entity) > 0) {
            CampaignSection rt = this.entity2Domain(entity);
            this.logger.info("created campaignSection:" + rt);
            return rt;
        }
        return null;
    }

    @Override
    @Transactional
    public Integer create(List<CampaignSection> objs) {
        this.logger.info("creating CampaignSections:" + objs);
        if (CollectionUtils.isEmpty(objs)) {
            return -1;
        }
        ArrayList list = Lists.newArrayList();
        for (CampaignSection obj : objs) {
            list.add(this.domain2Entity(obj));
        }
        Integer result = this.mapper.batchCreate(list);
        if (result > 0) {
            this.logger.info("created CampaignSections:" + objs);
        }
        return result;
    }

    @Override
    public List<Long> getIdsByCampaignId(Long campaignId, Integer temp) {
        return this.mapper.getIdsByCampaignId(campaignId, temp);
    }

    @Override
    public List<CampaignSection> getCampaignSectionById(Long id) {
        CampaignSectionEntityExample example = new CampaignSectionEntityExample();
        example.createCriteria().andCampaignIdEqualTo(id);
        return this.entity2Domain(this.mapper.selectByExample(example));
    }

    @Override
    public Integer deleteByCampaignId(Long campaignId, Integer temp) {
        CampaignSectionEntityExample example = new CampaignSectionEntityExample();
        example.createCriteria().andCampaignIdEqualTo(campaignId).andTempEqualTo(temp);
        return this.mapper.deleteByExample(example);
    }

    @Override
    public Integer changeCampaignId(Long oldId, Long newId, Integer temp) {
        CampaignSectionEntity entity = new CampaignSectionEntity();
        entity.setCampaignId(newId);
        entity.setTemp(0);
        CampaignSectionEntityExample example = new CampaignSectionEntityExample();
        example.createCriteria().andCampaignIdEqualTo(oldId).andTempEqualTo(temp);
        return this.mapper.updateByExampleSelective(entity, example);
    }
}

