/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.campaign.dao.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.campaign.CampaignProduct;
import com.thebeastshop.pegasus.component.campaign.CampaignProductInfo;
import com.thebeastshop.pegasus.component.campaign.dao.CampaignProductDao;
import com.thebeastshop.pegasus.component.campaign.dao.mapper.CampaignProductEntityMapper;
import com.thebeastshop.pegasus.component.campaign.model.CampaignProductEntity;
import com.thebeastshop.pegasus.component.campaign.model.CampaignProductEntityExample;
import com.thebeastshop.pegasus.component.campaign.vo.CampaignProductVO;
import com.thebeastshop.support.util.EnumUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CampaignProductDaoImpl
implements CampaignProductDao {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CampaignProductEntityMapper mapper;

    private static CampaignProduct entity2Domain(CampaignProductEntity entity) {
        if (entity != null) {
            CampaignProduct rt = new CampaignProduct();
            rt.setId(entity.getId());
            rt.setBindingId(entity.getBindingId());
            if (null != entity.getBindingType()) {
                rt.setBindingType((CampaignProduct.BindingType)EnumUtil.valueOf((Comparable)entity.getBindingType(), CampaignProduct.BindingType.class));
            }
            rt.setBlacklist(entity.getBlacklist());
            rt.setCampaignId(entity.getCampaignId());
            return rt;
        }
        return null;
    }

    private static List<CampaignProduct> entity2Domain(List<CampaignProductEntity> entities) {
        ArrayList list = Lists.newArrayList();
        for (CampaignProductEntity entity : entities) {
            list.add(CampaignProductDaoImpl.entity2Domain(entity));
        }
        return list;
    }

    private CampaignProductEntity domain2Entity(CampaignProduct domain) {
        if (domain != null) {
            CampaignProductEntity entity = new CampaignProductEntity();
            entity.setId(domain.getId());
            entity.setBindingId(domain.getBindingId());
            if (null != domain.getBindingType()) {
                entity.setBindingType(domain.getBindingType().getId());
            }
            entity.setBlacklist(domain.isBlacklist());
            entity.setCampaignId(domain.getCampaignId());
            entity.setTemp(domain.getTemp());
            return entity;
        }
        return null;
    }

    private List<CampaignProductEntity> domain2Entity(List<CampaignProduct> domains) {
        ArrayList list = Lists.newArrayList();
        for (CampaignProduct domain : domains) {
            list.add(this.domain2Entity(domain));
        }
        return list;
    }

    @Override
    public List<CampaignProduct> findByCampaignId(Long id) {
        CampaignProductEntityExample example = new CampaignProductEntityExample();
        example.createCriteria().andCampaignIdEqualTo(id);
        List<CampaignProductEntity> entities = this.mapper.selectByExample(example);
        return CampaignProductDaoImpl.entity2Domain(entities);
    }

    @Override
    public CampaignProduct create(CampaignProduct obj) {
        this.logger.info("creating CampaignProduct:" + obj);
        CampaignProductEntity entity = this.domain2Entity(obj);
        if (this.mapper.insertSelective(entity) > 0) {
            obj = CampaignProductDaoImpl.entity2Domain(entity);
            this.logger.info("created CampaignProduct:" + obj);
            return obj;
        }
        return null;
    }

    @Override
    @Transactional
    public Integer create(List<CampaignProduct> objs) {
        this.logger.info("creating CampaignProducts : " + objs);
        if (CollectionUtils.isEmpty(objs)) {
            return -1;
        }
        ArrayList list = Lists.newArrayList();
        for (CampaignProduct obj : objs) {
            list.add(this.domain2Entity(obj));
        }
        Integer result = this.mapper.batchCreate(list);
        if (result > 0) {
            this.logger.info("created CampaignProducts : " + objs);
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> isExistsMutexProduct(List<CampaignProduct> list, List<Map<String, Object>> mutexCampaignIds) {
        if (CollectionUtils.isEmpty(list) || CollectionUtils.isEmpty(mutexCampaignIds)) {
            return null;
        }
        return this.mapper.isExistsMutexProduct(mutexCampaignIds, this.domain2Entity(list));
    }

    @Override
    public List<Map<String, Object>> getExistsCategoryList(List<Map<String, Object>> mutexCampaignIds) {
        if (CollectionUtils.isEmpty(mutexCampaignIds)) {
            return null;
        }
        return this.mapper.getExistsCategoryList(mutexCampaignIds);
    }

    @Override
    public List<Long> getSelectedCategoryListNoBlack(List<Long> productIds, List<Map<String, Object>> mutexCampaignIds) {
        if (CollectionUtils.isEmpty(productIds) || CollectionUtils.isEmpty(mutexCampaignIds)) {
            return null;
        }
        return this.mapper.getSelectedCategoryListNoBlack(productIds, mutexCampaignIds);
    }

    @Override
    public Integer getDataByType(Long id, Integer type, Integer temp) {
        return this.mapper.getDataByType(id, type, temp);
    }

    @Override
    public Integer deleteByCampaignId(Long campaignId, Integer temp) {
        CampaignProductEntityExample example = new CampaignProductEntityExample();
        example.createCriteria().andCampaignIdEqualTo(campaignId).andTempEqualTo(temp);
        return this.mapper.deleteByExample(example);
    }

    @Override
    public Integer deleteByCampaignId(Long campaignId, Boolean includeProductFlag, Boolean excludeProductFlag) {
        CampaignProductEntityExample example = new CampaignProductEntityExample();
        CampaignProductEntityExample.Criteria criteria = example.createCriteria().andCampaignIdEqualTo(campaignId);
        if (includeProductFlag.booleanValue() || excludeProductFlag.booleanValue()) {
            if (includeProductFlag.booleanValue()) {
                if (!excludeProductFlag.booleanValue()) {
                    criteria.andBlacklistEqualTo(false);
                }
            } else {
                criteria.andBlacklistEqualTo(true);
            }
        } else {
            criteria.andBindingTypeEqualTo(1);
        }
        return this.mapper.deleteByExample(example);
    }

    @Override
    public Integer changeCampaignId(Long oldId, Long newId, Integer temp) {
        CampaignProductEntity entity = new CampaignProductEntity();
        entity.setCampaignId(newId);
        entity.setTemp(0);
        CampaignProductEntityExample example = new CampaignProductEntityExample();
        example.createCriteria().andCampaignIdEqualTo(oldId).andTempEqualTo(temp);
        return this.mapper.updateByExampleSelective(entity, example);
    }

    @Override
    public List<CampaignProduct> getProductByCampaignId(Long campaignId) {
        CampaignProductEntityExample example = new CampaignProductEntityExample();
        example.createCriteria().andCampaignIdEqualTo(campaignId).andBindingTypeEqualTo(CampaignProduct.BindingType.PRODUCT.getId());
        return CampaignProductDaoImpl.entity2Domain(this.mapper.selectByExample(example));
    }

    @Override
    public String getProductCodeById(Long campaignId, Integer temp) {
        return this.mapper.getProductCodeById(campaignId, temp);
    }

    @Override
    public List<CampaignProductInfo> getIncludeProductsByCampaignId(Long campaignId, Boolean temp) {
        return this.mapper.getIncludeProductsByCampaignId(campaignId, temp != false ? 1 : 0);
    }

    @Override
    public List<CampaignProductInfo> getExcludeProductsByCampaignId(Long campaignId, Boolean temp) {
        return this.mapper.getExcludeProductsByCampaignId(campaignId, temp != false ? 1 : 0);
    }

    @Override
    public Boolean getProductSkuInfoBySkuCodes(CampaignProductVO vo) {
        return this.mapper.getProductSkuInfoBySkuCodes(vo) > 0;
    }
}

