/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.campaign.dao.impl;

import com.alibaba.fastjson.TypeReference;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.campaign.AddCampaign;
import com.thebeastshop.pegasus.component.campaign.ApprovalState;
import com.thebeastshop.pegasus.component.campaign.Campaign;
import com.thebeastshop.pegasus.component.campaign.CampaignCreator;
import com.thebeastshop.pegasus.component.campaign.CampaignState;
import com.thebeastshop.pegasus.component.campaign.ConditionType;
import com.thebeastshop.pegasus.component.campaign.FactorTypeEnum;
import com.thebeastshop.pegasus.component.campaign.ProductScope;
import com.thebeastshop.pegasus.component.campaign.condition.CampaignCondition;
import com.thebeastshop.pegasus.component.campaign.dao.CampaignDao;
import com.thebeastshop.pegasus.component.campaign.dao.mapper.CampaignEntityMapper;
import com.thebeastshop.pegasus.component.campaign.dao.mapper.CampaignProductEntityMapper;
import com.thebeastshop.pegasus.component.campaign.dao.mapper.CampaignSectionEntityMapper;
import com.thebeastshop.pegasus.component.campaign.model.CampaignEntity;
import com.thebeastshop.pegasus.component.campaign.model.CampaignEntityExample;
import com.thebeastshop.pegasus.component.campaign.model.CampaignProductEntity;
import com.thebeastshop.pegasus.component.campaign.model.CampaignProductEntityExample;
import com.thebeastshop.pegasus.component.campaign.model.CampaignSectionEntity;
import com.thebeastshop.pegasus.component.campaign.model.CampaignSectionEntityExample;
import com.thebeastshop.pegasus.component.campaign.model.CampaignSectionProductEntity;
import com.thebeastshop.pegasus.component.campaign.support.DefaultCampaignImpl;
import com.thebeastshop.pegasus.component.campaign.support.DefaultCampaignSectionImpl;
import com.thebeastshop.pegasus.component.campaign.support.DefaultCampaignSectionProductImpl;
import com.thebeastshop.pegasus.component.discount.DiscountType;
import com.thebeastshop.pegasus.component.support.service.RedisService;
import com.thebeastshop.support.AccessWay;
import com.thebeastshop.support.enums.MemberLevel;
import com.thebeastshop.support.mark.State;
import com.thebeastshop.support.util.EnumUtil;
import com.thebeastshop.support.util.IdUtil;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CampaignDaoImpl
implements CampaignDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CampaignEntityMapper mapper;
    @Autowired
    private CampaignSectionEntityMapper campaignSectionEntityMapper;
    @Autowired
    private RedisService redisService;
    @Autowired
    private CampaignProductEntityMapper campaignProductEntityMapper;

    private static String getKey(Long id) {
        return "CAMP_" + id;
    }

    private Campaign entity2Domain(CampaignEntity e, Integer ... state) {
        if (e != null) {
            DefaultCampaignImpl campaign = new DefaultCampaignImpl();
            campaign.setId(e.getId());
            campaign.setCode(e.getCode());
            campaign.setVersion(e.getVersion());
            campaign.setCreateTime(e.getCreateTime());
            campaign.setDescription(e.getTitle());
            if (e.getAccessWay() != null) {
                String[] strAccessWays;
                ArrayList accessWays = Lists.newArrayList();
                for (String s : strAccessWays = e.getAccessWay().split(",")) {
                    if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{s})) continue;
                    accessWays.add(EnumUtil.valueOf((Comparable)Integer.valueOf(s), AccessWay.class));
                }
                campaign.setAccessWays(accessWays);
            }
            campaign.setCumulative(e.getCumulative());
            if (e.getDiscountType() != null) {
                campaign.setDiscountType((DiscountType)EnumUtil.valueOf((Comparable)e.getDiscountType(), DiscountType.class));
            }
            if (e.getMemberLevel() != null) {
                String[] strMemberLevels;
                ArrayList memberLevels = Lists.newArrayList();
                for (String s : strMemberLevels = e.getMemberLevel().split(",")) {
                    if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{s})) continue;
                    memberLevels.add(EnumUtil.valueOf((Comparable)Integer.valueOf(s), MemberLevel.class));
                }
                campaign.setMemberLevels(memberLevels);
            }
            campaign.setName(e.getName());
            if (e.getProductScope() != null) {
                campaign.setProductScope((ProductScope)EnumUtil.valueOf((Comparable)e.getProductScope(), ProductScope.class));
            }
            campaign.setStartTime(e.getStartTime());
            campaign.setExpireTime(e.getExpireTime());
            if (null != state && state.length >= 1) {
                campaign.setState((State)EnumUtil.valueOf((Comparable)state[0], CampaignState.class));
            } else {
                campaign.setState((State)EnumUtil.valueOf((Comparable)e.getState(), CampaignState.class));
            }
            if (null != e.getApprovalState()) {
                campaign.setApprovalState((State)EnumUtil.valueOf((Comparable)e.getApprovalState(), ApprovalState.class));
            }
            campaign.setCategoryIds(e.getCategoryIds());
            campaign.setProductIds(e.getProductIds());
            campaign.setBlackIds(e.getBlackList());
            campaign.setCreatorId(e.getCreatorId());
            campaign.setCampaignProducts(CampaignProductEntity.convert2DomainList(this.campaignProductEntityMapper.getProductsByCampaignId(e.getId(), 0)));
            if (CollectionUtils.isNotEmpty(e.getCampaignSections())) {
                List<CampaignSectionEntity> sectionEntities = e.getCampaignSections();
                ArrayList sections = Lists.newArrayList();
                for (CampaignSectionEntity item : sectionEntities) {
                    DefaultCampaignSectionImpl section = new DefaultCampaignSectionImpl();
                    section.setId(item.getId());
                    section.setCampaignId(item.getCampaignId());
                    if (null != item && null != item.getType()) {
                        section.setConditionType((ConditionType)EnumUtil.valueOf((Comparable)item.getType(), ConditionType.class));
                    }
                    section.setLine(item.getLine());
                    if (null != item.getFactorType()) {
                        section.setFactorType((FactorTypeEnum)EnumUtil.valueOf((Comparable)item.getFactorType(), FactorTypeEnum.class));
                    }
                    section.setFactor(item.getFactor());
                    section.setRanking(item.getSort().floatValue());
                    if (CollectionUtils.isNotEmpty(item.getCampaignSectionProducts())) {
                        ArrayList sectionProducts = Lists.newArrayList();
                        List<CampaignSectionProductEntity> sectionProductEntities = item.getCampaignSectionProducts();
                        for (CampaignSectionProductEntity sectionProductEntity : sectionProductEntities) {
                            DefaultCampaignSectionProductImpl product = new DefaultCampaignSectionProductImpl();
                            product.setId(sectionProductEntity.getId());
                            product.setCampaignSectionId(sectionProductEntity.getCampaignSectionId());
                            product.setCampaignId(sectionProductEntity.getCampaignId());
                            product.setAdditionalProductId(sectionProductEntity.getAdditionalProductId());
                            product.setAdditionalProductPrice(sectionProductEntity.getAdditionalProductPrice());
                            product.setAdditionalProductCount(sectionProductEntity.getAdditionalProductCount());
                            product.setRanking(sectionProductEntity.getSort().floatValue());
                            product.setProductCode(sectionProductEntity.getProductCode());
                            product.setProductName(sectionProductEntity.getProductName());
                            sectionProducts.add(product);
                        }
                        section.setCampaignSectionProducts(sectionProducts);
                    }
                    sections.add(section);
                }
                campaign.setCampaignSections(sections);
            }
            campaign.setCreatorName(e.getCreatorName());
            campaign.setTemp(false);
            campaign.setCrossBorderFlag(e.getCrossBorderFlag());
            campaign.setAdvance(e.getIsAdvance());
            campaign.setAdvanceName(e.getAdvanceName());
            campaign.setAdvanceTitle(e.getAdvanceTitle());
            campaign.setAdvanceStartTime(e.getAdvanceStartTime());
            campaign.setAdvanceEndTime(e.getAdvanceEndTime());
            campaign.setAdvancePriceTitle(e.getAdvancePriceTitle());
            return campaign;
        }
        return null;
    }

    private List<Campaign> entity2Domain(List<CampaignEntity> entities, Integer ... state) {
        ArrayList list = Lists.newArrayList();
        for (CampaignEntity entity : entities) {
            list.add(this.entity2Domain(entity, state));
        }
        return list;
    }

    private CampaignEntity domain2Entity(Campaign domain) {
        if (domain != null) {
            CampaignEntity entity = new CampaignEntity();
            entity.setId(domain.getId());
            entity.setCode(domain.getCode());
            entity.setVersion(domain.getVersion());
            entity.setCreateTime(domain.getCreateTime());
            entity.setTitle(domain.getDescription());
            if (null != domain.getAccessWays()) {
                entity.setAccessWay("," + Joiner.on((String)",").join((Iterable)IdUtil.toIds(domain.getAccessWays())) + ",");
            }
            entity.setCumulative(domain.isCumulative());
            if (domain.getDiscountType() != null) {
                entity.setDiscountType(domain.getDiscountType().getId());
                if (null != domain.getMemberLevels()) {
                    entity.setMemberLevel("," + Joiner.on((String)",").join((Iterable)IdUtil.toIds(domain.getMemberLevels())) + ",");
                }
            }
            entity.setName(domain.getName());
            if (null != domain.getProductScope()) {
                entity.setProductScope(domain.getProductScope().getId());
            }
            entity.setCreatorId(domain.getCreatorId());
            entity.setStartTime(domain.getStartTime());
            entity.setExpireTime(domain.getExpireTime());
            entity.setCrossBorderFlag(domain.getCrossBorderFlag());
            entity.setIsAdvance(domain.getAdvance());
            entity.setAdvanceName(domain.getAdvanceName());
            entity.setAdvanceTitle(domain.getAdvanceTitle());
            entity.setAdvanceStartTime(domain.getAdvanceStartTime());
            entity.setAdvanceEndTime(domain.getAdvanceEndTime());
            entity.setAdvancePriceTitle(domain.getAdvancePriceTitle());
            if (domain.getState() != null) {
                entity.setState(domain.getState().getId());
            }
            if (domain.getApprovalState() != null) {
                entity.setApprovalState(domain.getApprovalState().getId());
            }
            return entity;
        }
        return null;
    }

    @Override
    public List<Campaign> getCampaigns() {
        int seconds = 600;
        CampaignEntityExample example = new CampaignEntityExample();
        List<CampaignEntity> entities = this.mapper.selectByExample(example);
        this.setCampaignSectionEntities(entities);
        for (CampaignEntity entity : entities) {
            this.redisService.set(CampaignDaoImpl.getKey(entity.getId()), entity, seconds);
        }
        return this.entity2Domain(entities, new Integer[0]);
    }

    @Override
    public List<Campaign> getByCondition(CampaignCondition condition) {
        int seconds = 600;
        CampaignEntityExample example = new CampaignEntityExample();
        condition.fillCriteria(example.createCriteria());
        List<CampaignEntity> entities = this.mapper.selectByExample(example);
        this.setCampaignSectionEntities(entities);
        for (CampaignEntity entity : entities) {
            this.redisService.set(CampaignDaoImpl.getKey(entity.getId()), entity, seconds);
        }
        return this.entity2Domain(entities, new Integer[0]);
    }

    @Override
    public List<Campaign> getGlobalCampaignList(CampaignCondition condition) {
        String key = "CAMP_GLOBAL";
        int seconds = 600;
        List<CampaignEntity> list = (List<CampaignEntity>)this.redisService.get(key, new TypeReference<List<CampaignEntity>>(){}.getType());
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return this.entity2Domain(this.filterCampaignList(condition, list), new Integer[0]);
        }
        condition.setProductScopeId(ProductScope.GLOBAL.getId());
        CampaignEntityExample example = new CampaignEntityExample();
        condition.fillCriteria(example.createCriteria());
        list = this.mapper.selectByExample(example);
        this.setCampaignSectionEntities(list);
        this.setCampaignProductEntities(list);
        for (CampaignEntity entity : list) {
            this.redisService.set(CampaignDaoImpl.getKey(entity.getId()), entity, seconds);
        }
        this.redisService.set(key, list, seconds);
        return this.entity2Domain(this.filterCampaignList(condition, list), new Integer[0]);
    }

    private List<CampaignEntity> filterCampaignList(CampaignCondition condition, List<CampaignEntity> campaignList) {
        if (condition == null) {
            return campaignList;
        }
        Integer stateId = condition.getStateId();
        Long productId = condition.getProductId();
        ArrayList<CampaignEntity> results = new ArrayList<CampaignEntity>();
        for (CampaignEntity campaign : campaignList) {
            boolean need = true;
            if (stateId != null && campaign.getState() != stateId || null != campaign.getCrossBorderFlag() && !campaign.getCrossBorderFlag().equals(condition.getCrossBorderFlag())) continue;
            if (campaign.getProductScope() == ProductScope.GLOBAL.getId()) {
                List<Long> blackList = campaign.getBlackList();
                if (productId != null && CollectionUtils.isNotEmpty(blackList)) {
                    for (Long bkId : blackList) {
                        if (!bkId.equals(productId)) continue;
                        need = false;
                    }
                }
            }
            if (!need) continue;
            results.add(campaign);
        }
        return results;
    }

    @Override
    public List<Campaign> getByProductIdAndCategoryId(CampaignCondition condition) {
        int seconds = 600;
        List<CampaignEntity> entities = this.mapper.selectByParams(condition);
        this.setCampaignSectionEntities(entities);
        for (CampaignEntity entity : entities) {
            this.redisService.set(CampaignDaoImpl.getKey(entity.getId()), entity, seconds);
        }
        List<Campaign> list = this.entity2Domain(entities, new Integer[0]);
        return list;
    }

    private List<Long> fetchCampaignIdList(List<CampaignEntity> entities) {
        ArrayList idList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(entities)) {
            for (CampaignEntity entity : entities) {
                idList.add(entity.getId());
            }
        }
        return idList;
    }

    @Override
    public List<Campaign> getCampaignsByIdList(List<Long> idList) {
        ArrayList campaignList = Lists.newArrayList();
        for (Long id : idList) {
            campaignList.add(this.getCampaignById(id));
        }
        return campaignList;
    }

    @Override
    public List<Campaign> getAvailableCampaigns(AccessWay accessWay) {
        Date now = new Date();
        CampaignEntityExample example = new CampaignEntityExample();
        CampaignEntityExample.Criteria criteria = example.createCriteria();
        if (accessWay != null) {
            criteria.andAccessWayLike("%" + accessWay.getId().toString() + "%");
        }
        criteria.andStateEqualTo(CampaignState.ONLINE.getId()).andStartTimeLessThanOrEqualTo(now).andExpireTimeGreaterThanOrEqualTo(now);
        List<CampaignEntity> entities = this.mapper.selectByExample(example);
        return this.entity2Domain(entities, new Integer[0]);
    }

    @Override
    public List<Campaign> getAvailableCampaigns(AccessWay accessWay, MemberLevel memberLevel) {
        Date now = new Date();
        CampaignEntityExample example = new CampaignEntityExample();
        CampaignEntityExample.Criteria criteria = example.createCriteria();
        criteria.andStateEqualTo(CampaignState.ONLINE.getId()).andStartTimeLessThanOrEqualTo(now).andExpireTimeGreaterThanOrEqualTo(now);
        if (accessWay != null) {
            criteria.andAccessWayLike("%" + accessWay.getId().toString() + "%");
        }
        if (memberLevel != null) {
            criteria.andMemberLevelLike("%" + memberLevel.getId().toString() + "%");
        }
        List<CampaignEntity> entities = this.mapper.selectByExample(example);
        return this.entity2Domain(entities, new Integer[0]);
    }

    @Override
    @Transactional
    public Campaign create(Campaign obj) {
        this.logger.info("creating campaign:" + obj);
        CampaignEntity entity = this.domain2Entity(obj);
        if (this.mapper.insertSelective(entity) > 0) {
            Campaign campaign = this.entity2Domain(entity, new Integer[0]);
            this.logger.info("created campaign:" + campaign);
            return campaign;
        }
        return null;
    }

    @Override
    public Campaign getCampaignById(Long id) {
        return this.getCampaignById(id, false);
    }

    private void setCampaignProductEntities(List<CampaignEntity> entities) {
        for (CampaignEntity entity : entities) {
            this.setCampaignProductEntity(entity);
        }
    }

    private void setCampaignProductEntity(CampaignEntity entity) {
        if (entity == null) {
            return;
        }
        CampaignProductEntityExample example = new CampaignProductEntityExample();
        example.createCriteria().andCampaignIdEqualTo(entity.getId());
        List<CampaignProductEntity> list = this.campaignProductEntityMapper.selectByExample(example);
        ArrayList<Long> categoryIds = new ArrayList<Long>();
        ArrayList<Long> productIds = new ArrayList<Long>();
        ArrayList<Long> blackList = new ArrayList<Long>();
        for (CampaignProductEntity productEntity : list) {
            if (productEntity.getBlacklist() != null && productEntity.getBlacklist().booleanValue()) {
                blackList.add(productEntity.getBindingId());
                continue;
            }
            if (productEntity.getBindingType() != null && productEntity.getBindingType().equals(1)) {
                categoryIds.add(productEntity.getBindingId());
                continue;
            }
            productIds.add(productEntity.getBindingId());
        }
        entity.setCategoryIds(categoryIds);
        entity.setProductIds(productIds);
        entity.setBlackList(blackList);
    }

    private void setCampaignSectionEntities(List<CampaignEntity> entities) {
        for (CampaignEntity entity : entities) {
            this.setCampaignSectionEntity(entity);
        }
    }

    private void setCampaignSectionEntity(CampaignEntity entity) {
        if (entity == null) {
            return;
        }
        CampaignSectionEntityExample example = new CampaignSectionEntityExample();
        example.createCriteria().andCampaignIdEqualTo(entity.getId());
        List<CampaignSectionEntity> entities = this.campaignSectionEntityMapper.selectByExample(example);
        Collections.sort(entities, new Comparator<CampaignSectionEntity>(){

            @Override
            public int compare(CampaignSectionEntity o1, CampaignSectionEntity o2) {
                return o1.getSort().compareTo(o2.getSort());
            }
        });
        entity.setCampaignSections(entities);
        if (CollectionUtils.isNotEmpty(entities)) {
            List<CampaignSectionEntity> sectionEntities = entity.getCampaignSections();
            ArrayList sections = Lists.newArrayList();
            for (CampaignSectionEntity item : sectionEntities) {
                DefaultCampaignSectionImpl section = new DefaultCampaignSectionImpl();
                section.setId(item.getId());
                section.setCampaignId(item.getCampaignId());
                if (null != item && null != item.getType()) {
                    section.setConditionType((ConditionType)EnumUtil.valueOf((Comparable)item.getType(), ConditionType.class));
                }
                section.setLine(item.getLine());
                section.setFactor(item.getFactor());
                section.setRanking(item.getSort().floatValue());
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("campaignId", entity.getId());
                params.put("campaignSectionId", item.getId());
                List<CampaignSectionProductEntity> sectionProductEntityList = this.campaignSectionEntityMapper.selectSectionProduct(params);
                item.setCampaignSectionProducts(sectionProductEntityList);
                if (CollectionUtils.isNotEmpty(item.getCampaignSectionProducts())) {
                    List<CampaignSectionProductEntity> sectionProductEntities = item.getCampaignSectionProducts();
                    ArrayList sectionProducts = Lists.newArrayList();
                    for (CampaignSectionProductEntity sectionProductEntity : sectionProductEntities) {
                        DefaultCampaignSectionProductImpl product = new DefaultCampaignSectionProductImpl();
                        product.setId(sectionProductEntity.getId());
                        product.setCampaignId(sectionProductEntity.getCampaignId());
                        product.setCampaignSectionId(sectionProductEntity.getCampaignSectionId());
                        product.setAdditionalProductId(sectionProductEntity.getAdditionalProductId());
                        product.setAdditionalProductPrice(sectionProductEntity.getAdditionalProductPrice());
                        product.setAdditionalProductCount(sectionProductEntity.getAdditionalProductCount());
                        product.setRanking(sectionProductEntity.getSort().floatValue());
                        sectionProducts.add(product);
                    }
                    section.setCampaignSectionProducts(sectionProducts);
                }
                sections.add(section);
            }
        }
    }

    @Override
    public Campaign getCampaignById(Long id, boolean fromRedis) {
        CampaignEntity entity;
        String key = CampaignDaoImpl.getKey(id);
        int seconds = 300;
        if (fromRedis && (entity = (CampaignEntity)this.redisService.get(key, (Type)((Object)CampaignEntity.class))) != null) {
            return this.entity2Domain(entity, new Integer[0]);
        }
        entity = this.mapper.selectByPrimaryKey(id);
        this.setCampaignSectionEntity(entity);
        Campaign campaign = this.entity2Domain(entity, new Integer[0]);
        this.redisService.set(key, entity, seconds);
        return campaign;
    }

    @Override
    public Campaign getCampaignDetailById(Long id, Boolean temp) {
        return this.entity2Domain(this.mapper.getCampaignById(id, temp != null && temp != false ? 1 : 0), new Integer[0]);
    }

    @Override
    public List<Campaign> getFirstPendingCampaign() {
        return this.entity2Domain(this.mapper.getFirstPendingCampaign(), new Integer[0]);
    }

    @Override
    public List<Campaign> getSecondPendingCampaign() {
        return this.entity2Domain(this.mapper.getSecondPendingCampaign(), new Integer[0]);
    }

    @Override
    public List<Campaign> getFirstApprovedCampaign() {
        return this.entity2Domain(this.mapper.getApprovedCampaign(1), new Integer[0]);
    }

    @Override
    public List<Campaign> getSecondApprovedCampaign() {
        return this.entity2Domain(this.mapper.getApprovedCampaign(2), new Integer[0]);
    }

    @Override
    public Boolean changeCampaignState(Long id, CampaignState state) {
        if (id == null) {
            return false;
        }
        CampaignEntity entity = new CampaignEntity();
        entity.setId(id);
        entity.setState(state.getId());
        return this.mapper.updateByPrimaryKeySelective(entity) > 0;
    }

    @Override
    public Boolean changeCampaignState(String code, CampaignState state) {
        if (code == null) {
            return false;
        }
        CampaignEntity entity = new CampaignEntity();
        entity.setState(state.getId());
        CampaignEntityExample example = new CampaignEntityExample();
        example.createCriteria().andCodeEqualTo(code).andActiveEqualTo(1);
        return this.mapper.updateByExampleSelective(entity, example) > 0;
    }

    @Override
    public Boolean changeCampaignApprovalState(Long id, ApprovalState state) {
        if (id == null) {
            return false;
        }
        CampaignEntity entity = new CampaignEntity();
        entity.setId(id);
        entity.setApprovalState(state.getId());
        return this.mapper.updateByPrimaryKeySelective(entity) > 0;
    }

    @Override
    public Boolean changeCampaignApprovalState(String code, ApprovalState state) {
        if (code == null) {
            return false;
        }
        CampaignEntity entity = new CampaignEntity();
        entity.setApprovalState(state.getId());
        CampaignEntityExample example = new CampaignEntityExample();
        example.createCriteria().andCodeEqualTo(code).andActiveEqualTo(1);
        return this.mapper.updateByExampleSelective(entity, example) > 0;
    }

    @Override
    public BigDecimal getAdditionalPackPrice(Long productId, MemberLevel level) {
        BigDecimal additionalPackPrice = this.mapper.getAdditionalPackPrice(productId, level.getId());
        if (additionalPackPrice == null) {
            additionalPackPrice = BigDecimal.ZERO;
        }
        return additionalPackPrice;
    }

    private CampaignEntity domain2Entity(AddCampaign domain) {
        CampaignEntity entity = new CampaignEntity();
        entity.setId(domain.getId());
        entity.setCode(domain.getCode());
        if (null == domain.getVersion()) {
            entity.setVersion(0);
        } else {
            entity.setVersion(domain.getVersion());
        }
        entity.setDiscountType(domain.getDiscountType());
        entity.setName(domain.getName());
        entity.setTitle(domain.getTitle());
        entity.setStartTime(domain.getStartTime());
        entity.setExpireTime(domain.getExpireTime());
        entity.setAccessWay(".*,(" + Joiner.on((String)"|").join(domain.getAccessWays()) + "),.*");
        entity.setMemberLevel(".*,(" + Joiner.on((String)"|").join(domain.getMemberLevels()) + "),.*");
        entity.setProductScope(domain.getProductScope());
        entity.setCreateTime(new Date());
        entity.setCumulative(domain.getCumulative());
        entity.setCrossBorderFlag(domain.getCrossBorderFlag());
        entity.setIsAdvance(domain.getAdvance());
        entity.setAdvanceName(domain.getAdvanceName());
        entity.setAdvanceTitle(domain.getAdvanceTitle());
        entity.setAdvanceStartTime(domain.getAdvanceStartTime());
        entity.setAdvanceEndTime(domain.getAdvanceEndTime());
        entity.setAdvancePriceTitle(domain.getAdvancePriceTitle());
        return entity;
    }

    @Override
    @Deprecated
    public List<Campaign> getOnGoingCampaign() {
        CampaignEntityExample example = new CampaignEntityExample();
        Date now = new Date();
        example.createCriteria().andStateEqualTo(1).andApprovalStateEqualTo(4).andStartTimeLessThanOrEqualTo(now).andExpireTimeGreaterThanOrEqualTo(now);
        List<CampaignEntity> entities = this.mapper.selectByExample(example);
        this.setCampaignSectionEntities(entities);
        List<Campaign> list = this.entity2Domain(entities, -1);
        return list;
    }

    @Override
    @Deprecated
    public List<Campaign> getWillStartCampaign() {
        CampaignEntityExample example = new CampaignEntityExample();
        Date now = new Date();
        example.createCriteria().andStateEqualTo(1).andApprovalStateEqualTo(4).andStartTimeGreaterThan(now);
        List<CampaignEntity> entities = this.mapper.selectByExample(example);
        this.setCampaignSectionEntities(entities);
        List<Campaign> list = this.entity2Domain(entities, -2);
        return list;
    }

    @Override
    public List<Campaign> getEndedCampaign() {
        CampaignEntityExample example = new CampaignEntityExample();
        Date now = new Date();
        example.createCriteria().andStateEqualTo(1).andApprovalStateEqualTo(4).andExpireTimeLessThan(now);
        List<CampaignEntity> entities = this.mapper.selectByExample(example);
        this.setCampaignSectionEntities(entities);
        List<Campaign> list = this.entity2Domain(entities, -3);
        return list;
    }

    @Override
    public List<Map<String, Object>> getMutexCampaignIds(AddCampaign domain) {
        return this.mapper.getMutexCampaignIds(this.domain2Entity(domain));
    }

    @Override
    public List<Map<String, Object>> getMutexAdvanceCampaign(AddCampaign domain) {
        return this.mapper.getMutexAdvanceCampaign(this.domain2Entity(domain));
    }

    @Override
    public Boolean checkDiscountIsIllegal(Integer checkType, Integer need2CheckProductScope, Long productId, AddCampaign domain) {
        CampaignEntity entity = this.domain2Entity(domain);
        return this.mapper.checkDiscountIsIllegal(checkType, need2CheckProductScope, productId, entity) > 0;
    }

    @Override
    public List<CampaignCreator> getAllCampaignCreator() {
        return CampaignEntity.convert2CampaignCreator(this.mapper.getAllCampaignCreator());
    }

    @Override
    public List<Campaign> listCampaignByCondition(CampaignCondition condition) {
        List<CampaignEntity> campaignEntities = this.mapper.listCampaignByCondition(condition);
        if (CollectionUtils.isNotEmpty(campaignEntities)) {
            for (CampaignEntity campaignEntity : campaignEntities) {
                campaignEntity.setCampaignSections(this.campaignSectionEntityMapper.getCampaignSectionById(campaignEntity.getId()));
            }
        }
        return this.entity2Domain(campaignEntities, new Integer[0]);
    }

    @Override
    public Integer updateCode(Long campaignId, String code) {
        CampaignEntity entity = new CampaignEntity();
        entity.setId(campaignId);
        entity.setCode(code);
        CampaignEntityExample example = new CampaignEntityExample();
        example.createCriteria().andIdEqualTo(campaignId);
        return this.mapper.updateByExampleSelective(entity, example);
    }

    @Override
    public Integer update(Campaign campaign) {
        CampaignEntity entity = this.domain2Entity(campaign);
        return this.mapper.updateByPrimaryKeySelective(entity);
    }

    @Override
    public Integer updateSelective(AddCampaign campaign) {
        CampaignEntity entity = new CampaignEntity();
        entity.setName(campaign.getName());
        entity.setTitle(campaign.getTitle());
        if (campaign.getDiscountType().equals(DiscountType.OFF.getId())) {
            entity.setIsAdvance(campaign.getAdvance());
            entity.setAdvanceName(campaign.getAdvanceName());
            entity.setAdvanceTitle(campaign.getAdvanceTitle());
            entity.setAdvanceStartTime(campaign.getAdvanceStartTime());
            entity.setAdvanceEndTime(campaign.getAdvanceEndTime());
            entity.setAdvancePriceTitle(campaign.getAdvancePriceTitle());
        }
        CampaignEntityExample example = new CampaignEntityExample();
        example.createCriteria().andCodeEqualTo(campaign.getCode()).andActiveEqualTo(1);
        return this.mapper.updateByExampleSelective(entity, example);
    }

    @Override
    public Campaign getCampaignByCode(String code) {
        CampaignEntityExample example = new CampaignEntityExample();
        example.createCriteria().andCodeEqualTo(code).andActiveEqualTo(1);
        List<CampaignEntity> campaignEntities = this.mapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(campaignEntities)) {
            return this.entity2Domain(campaignEntities.get(0), new Integer[0]);
        }
        return null;
    }

    @Override
    public Campaign getCampaignDetailByCode(String code) {
        return this.entity2Domain(this.mapper.getCampaignDetailByCode(code), new Integer[0]);
    }

    @Override
    public Integer getMaxVersionByCode(String code) {
        return this.mapper.getMaxVersionByCode(code);
    }

    @Override
    public Boolean changeActiveByCode(String code) {
        CampaignEntity entity = new CampaignEntity();
        entity.setActive(0);
        entity.setApprovalState(ApprovalState.APPROVAL_PASS.getId());
        CampaignEntityExample example = new CampaignEntityExample();
        example.createCriteria().andCodeEqualTo(code).andActiveEqualTo(1);
        return this.mapper.updateByExampleSelective(entity, example) > 0;
    }
}

