/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.campaign;

import com.thebeastshop.pegasus.component.campaign.CampaignSection;
import com.thebeastshop.support.mark.HasIdGetter;
import com.thebeastshop.support.mark.HasName;
import com.thebeastshop.support.util.PriceUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;

public enum FactorTypeEnum implements HasIdGetter.HasIntIdGetter,
HasName
{
    DISCOUNT(1, "\u7edf\u4e00\u6298\u6263"){

        @Override
        public BigDecimal calculate(BigDecimal basic, CampaignSection section) {
            return PriceUtil.keepToCent((BigDecimal)basic.multiply(section.getFactor().divide(BigDecimal.valueOf(10L), 2, RoundingMode.HALF_UP)));
        }
    }
    ,
    FIXED_AMOUNT(2, "\u56fa\u5b9a\u4ef7\u683c"){

        @Override
        public BigDecimal calculate(BigDecimal basic, CampaignSection section) {
            return section.getFactor();
        }
    };

    private Integer id;
    private String name;

    private FactorTypeEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal calculate(BigDecimal basic, CampaignSection section) {
        return basic;
    }
}

