/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.announcement.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.announcement.Announcement;
import com.thebeastshop.pegasus.component.announcement.dao.mapper.AnnouncementEntityMapper;
import com.thebeastshop.pegasus.component.announcement.model.AnnouncementEntity;
import com.thebeastshop.pegasus.component.announcement.model.AnnouncementEntityExample;
import com.thebeastshop.pegasus.component.announcement.service.AnnouncementService;
import com.thebeastshop.pegasus.component.announcement.support.DefaultAnnouncementImpl;
import com.thebeastshop.support.AccessWay;
import com.thebeastshop.support.enums.MemberLevel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AnnouncementServiceImpl
implements AnnouncementService {
    @Autowired
    private AnnouncementEntityMapper mapper;

    private Announcement entity2Domain(AnnouncementEntity entity) {
        if (entity != null) {
            DefaultAnnouncementImpl domain = new DefaultAnnouncementImpl();
            domain.setLink(entity.getLink());
            domain.setTitle(entity.getTitle());
            return domain;
        }
        return null;
    }

    private List<Announcement> entity2Domain(List<AnnouncementEntity> entities) {
        ArrayList domains = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(entities)) {
            for (AnnouncementEntity entity : entities) {
                domains.add(this.entity2Domain(entity));
            }
        }
        return domains;
    }

    @Override
    public List<Announcement> getAvailable(AccessWay accessWay, MemberLevel memberLevel) {
        Date now = new Date();
        AnnouncementEntityExample example = new AnnouncementEntityExample();
        example.createCriteria().andAccessWayEqualTo(accessWay.getId()).andMemberLevelEqualTo(memberLevel.getId()).andStartTimeLessThanOrEqualTo(now).andEndTimeGreaterThan(now);
        List<AnnouncementEntity> entities = this.mapper.selectByExample(example);
        return this.entity2Domain(entities);
    }
}

