/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.coupon.domain.impl;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.pegasus.component.coupon.domain.CouponContent;
import com.thebeastshop.pegasus.component.coupon.domain.impl.CouponSampleTemplate;
import com.thebeastshop.pegasus.component.coupon.domain.impl.FullCutPrice;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSampleState;
import com.thebeastshop.pegasus.component.coupon.enums.CouponSendWay;
import com.thebeastshop.pegasus.component.coupon.enums.CouponType;
import com.thebeastshop.pegasus.component.coupon.enums.ProductScope;
import com.thebeastshop.support.mark.State;
import com.thebeastshop.support.util.EnumUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;

public class DefaultCouponSampleImpl
extends CouponSampleTemplate {
    private Long id;
    private String name;
    private String title;
    private CouponType couponType;
    private String productDesc;
    private String couponContent;
    private int stateId;
    private Date createTime;
    private Date startTime;
    private Date expireTime;
    private String description;
    private String note;
    private Long creatorId;
    private Integer maxCount;
    private Integer balanceCount;
    private Integer maxPerMember;
    private CouponSendWay couponSendWay;
    private Collection<AccessWayEnum> accessWays;
    private Collection<Long> categoryIds;
    private Collection<Long> productIds;
    private Collection<Long> excludeProductIds;
    private String couponCode;
    private String nickName;
    private ProductScope productScope;
    private Integer dateWay;
    private Integer dateNum;
    private Integer crossBorder;
    private Integer weekFlower;
    private Collection<String> offlineStoreIds;
    private Integer skipType;
    private String skipValue;

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public CouponType getCouponType() {
        return this.couponType;
    }

    @Override
    public String getProductDesc() {
        return this.productDesc;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Integer getMaxCount() {
        return this.maxCount;
    }

    @Override
    public Integer getBalanceCount() {
        return this.balanceCount;
    }

    @Override
    public Integer getMaxPerMember() {
        return this.maxPerMember;
    }

    @Override
    public Collection<AccessWayEnum> getAccessWays() {
        return this.accessWays;
    }

    @Override
    public CouponSendWay getCouponSendWay() {
        return this.couponSendWay;
    }

    @Override
    public ProductScope getProductScope() {
        return this.productScope;
    }

    @Override
    public String getCouponContentJSON() {
        return this.couponContent;
    }

    @Override
    public CouponContent getCouponContent() {
        if (this.couponType == CouponType.CHEAPEN_LINE) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            mapper.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
            try {
                FullCutPrice content = (FullCutPrice)mapper.readValue(this.couponContent, FullCutPrice.class);
                return content;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public Collection<Long> getProductIds() {
        return this.productIds;
    }

    @Override
    public Collection<Long> getCategoryIds() {
        return this.categoryIds;
    }

    @Override
    public Collection<Long> getExcludeProductIds() {
        return this.excludeProductIds;
    }

    @Override
    public String getCouponCode() {
        return this.couponCode;
    }

    @Override
    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    @Override
    public int getStateId() {
        return this.stateId;
    }

    public Long getId() {
        return this.id;
    }

    public Long getCreatorId() {
        return this.creatorId;
    }

    public String getName() {
        return this.name;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getExpireTime() {
        return this.expireTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public String getNote() {
        return this.note;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCouponType(CouponType couponType) {
        this.couponType = couponType;
    }

    public void setProductDesc(String productDesc) {
        this.productDesc = productDesc;
    }

    public void setCouponContent(String couponContent) {
        this.couponContent = couponContent;
    }

    public void setStateId(int stateId) {
        this.stateId = stateId;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public void setCreatorId(Long creatorId) {
        this.creatorId = creatorId;
    }

    public void setMaxCount(Integer maxCount) {
        this.maxCount = maxCount;
    }

    public void setMaxPerMember(Integer maxPerMember) {
        this.maxPerMember = maxPerMember;
    }

    public void setCouponSendWay(CouponSendWay couponSendWay) {
        this.couponSendWay = couponSendWay;
    }

    public void setAccessWays(Collection<AccessWayEnum> accessWays) {
        this.accessWays = accessWays;
    }

    public void setProductIds(Collection<Long> productIds) {
        this.productIds = productIds;
    }

    public void setBalanceCount(Integer balanceCount) {
        this.balanceCount = balanceCount;
    }

    public void setCategoryIds(Collection<Long> categoryIds) {
        this.categoryIds = categoryIds;
    }

    public void setExcludeProductIds(Collection<Long> excludeProductIds) {
        this.excludeProductIds = excludeProductIds;
    }

    public void setProductScope(ProductScope productScope) {
        this.productScope = productScope;
    }

    @Override
    public String getNickName() {
        return this.nickName;
    }

    @Override
    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    @Override
    public Integer getDateWay() {
        return this.dateWay;
    }

    public void setDateWay(Integer dateWay) {
        this.dateWay = dateWay;
    }

    @Override
    public Integer getDateNum() {
        return this.dateNum;
    }

    public void setDateNum(Integer dateNum) {
        this.dateNum = dateNum;
    }

    @Override
    public Integer getCrossBorder() {
        return this.crossBorder;
    }

    public void setCrossBorder(Integer crossBorder) {
        this.crossBorder = crossBorder;
    }

    @Override
    public Integer getWeekFlower() {
        return this.weekFlower;
    }

    public void setWeekFlower(Integer weekFlower) {
        this.weekFlower = weekFlower;
    }

    @Override
    public State getState() {
        return (State)EnumUtil.valueOf((Comparable)Integer.valueOf(this.getStateId()), CouponSampleState.class);
    }

    @Override
    public boolean isForAllProducts() {
        return CollectionUtils.isEmpty(this.getProductIds()) && CollectionUtils.isEmpty(this.getCategoryIds());
    }

    public boolean isExpired() {
        return this.expireTime.before(new Date());
    }

    @Override
    public Collection<String> getOfflineStoreIds() {
        return this.offlineStoreIds;
    }

    public void setOfflineStoreIds(Collection<String> offlineStoreIds) {
        this.offlineStoreIds = offlineStoreIds;
    }

    @Override
    public Integer getSkipType() {
        return this.skipType;
    }

    public void setSkipType(Integer skipType) {
        this.skipType = skipType;
    }

    @Override
    public String getSkipValue() {
        return this.skipValue;
    }

    public void setSkipValue(String skipValue) {
        this.skipValue = skipValue;
    }
}

