package com.thebeastshop.pegasus.component.coupon.support;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * 优惠券组件服务加载器
 * 
 * @author Paul-xiong
 *
 */
public class CouponServiceLoader {

	private static final Logger LOGGER = LoggerFactory.getLogger(CouponServiceLoader.class);

	// 加载spring配置文件
	private static final ApplicationContext CONTEXT;

	static {
		LOGGER.info("initing coupon-spring.xml");
		CONTEXT = new ClassPathXmlApplicationContext("coupon/coupon-spring.xml");
	}

	public static <T> T getBean(final Class<T> paramClass) {
		return CONTEXT != null ? CONTEXT.getBean(paramClass) : null;
	}
}
