package com.thebeastshop.pegasus.component.utils;

import com.thebeastshop.pegasus.component.enums.ResultStatus;
import com.thebeastshop.pegasus.component.json.ApiResult;

/**
 * @author gongjun
 * @since 2016-06-30
 */
public class ApiUtils {

    public static boolean isSuccess(ApiResult result) {
        return result != null && result.getStatus() == ResultStatus.SUCCESS.getStatus();
    }

    public static boolean isError(ApiResult result) {
        return !isSuccess(result);
    }

    public static  <T> T getData(ApiResult<T> result) {
        if (isSuccess(result)) {
            return result.getData();
        }
        return null;
    }
}
