package com.thebeastshop.pegasus.component.coupon.client;

import com.thebeastshop.pegasus.component.campaign.vo.CampaignProductVO;
import com.thebeastshop.pegasus.component.coupon.vo.*;
import com.thebeastshop.pegasus.component.json.ApiResult;
import com.thebeastshop.pegasus.component.vo.StateVO;
import com.thebeastshop.pegasus.component.vo.TypeVO;
import org.forest.annotation.Request;
import org.forest.annotation.var.DataObject;
import org.forest.annotation.var.DataParam;

import java.util.List;

/**
 * Created by Administrator on 2016/6/30.
 * @author gongjun
 */
public interface CouponClient {

    /**
     * 根据id获取优惠券
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupon/${0}",
            type = "get",
            dataType = "json"
    )
    ApiResult<CouponVO> getCouponById(Long id);



    /**
     * 根据条件获取优惠券列表
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupons",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CouponVO>> listCoupon(@DataObject(jsonParam = "params") CouponCondVO condVO);

    /**
     * 根据条件获取优惠券列表
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1_1/coupons",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CouponVO>> v1_listCoupon(@DataObject CouponCondVO condVO);

    /**
     * 根据条件统计优惠券
     * @param condVO
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupons/count",
            type = "get",
            dataType = "json"
    )
    ApiResult<CouponCountVO> countCoupons(@DataObject CouponCondVO condVO);



    /**
     * 获取所有优惠券模板状态
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupon/sample/states",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<StateVO>> listAllCouponSampleStates();

    /**
     * 获取所有优惠券类型
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupon/sample/types",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<TypeVO>> listAllCouponTypes();


    /**
     * 获取所有优惠券派发方式
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupon/sendWays",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CouponSendWayVO>> listAllCouponSendWays();

    /**
     * 根据条件查询优惠券模板
     * @param cond
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1_1/coupon/samples",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CouponSampleVO>> v1_listCouponSample(@DataObject(jsonParam = "params") CouponSampleCondVO cond);

    @Request(
            url = "${couponBaseUrl}/v1/coupon/samples",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CouponSampleVO>> listCouponSample(@DataObject CouponSampleCondVO cond);

    /**
     * 根据ID查询优惠券模板
     * @param id
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupon/sample/${0}",
            type = "get",
            dataType = "json"
    )
    ApiResult<CouponSampleVO> getCouponSample(Long id);

    /**
     * 更新优惠券模板状态
     * @param id
     * @param stateId
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupon/sample/${0}/state",
            type = "post",
            dataType = "json"
    )
    ApiResult<String> updateCouponSampleState(@DataParam("id") Long id, @DataParam("stateId") Integer stateId);

    /**
     * 创建优惠券模板
     * @param couponSampleVO
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupon/sample",
            contentType = "application/json",
            type = "post",
            dataType = "json"
    )
    ApiResult<String> createCouponSample(@DataObject CouponSampleVO couponSampleVO);

    /**
     * 编辑优惠券模板
     * @param couponSampleVO
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupon/updatesample",
            contentType = "application/json",
            type = "post",
            dataType = "json"
    )
    ApiResult<String> updateCouponSample(@DataObject CouponSampleVO couponSampleVO);


    @Request(
            url = "${couponBaseUrl}/v1/coupon/code",
            type = "get",
            dataType = "json"
    )
    ApiResult<String> generateCouponCode();

    /**
     * 根据优惠券模板ID获取优惠口令
     * @param id
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupon/sample/${0}/code",
            type = "get",
            dataType = "json"
    )
    ApiResult<CouponCodeVO> getCouponCodeBySampleId(Long id);


    /**
     * 派发多个用户ID优惠券
     * @param sendCouponUserVO
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupon/send",
            contentType = "application/json",
            timeout = 999999,
            type = "post",
            dataType = "json"
    )
    ApiResult<String> sendCouponUsers(@DataObject SendCouponUserVO sendCouponUserVO);

    /**
     * 获取所有待第一级审批或已通过第一级审批的优惠券模板
     *
     * @return
     */
    @Request(
            url="${couponBaseUrl}/v1/coupon/sample/pending/first",
            type="get",
            dataType="json"
    )
    ApiResult<List<PendingCouponVO>> getFirstPendingCouponSample(@DataObject PendingCondVO vo);

    /**
     * 获取所有待第二级审批或已通过第二级审批的优惠券模板
     *
     * @return
     */
    @Request(
            url="${couponBaseUrl}/v1/coupon/sample/pending/second",
            type="get",
            dataType="json"
    )
    ApiResult<List<PendingCouponVO>> getSecondPendingCouponSample(@DataObject PendingCondVO vo);

    @Request(
            url = "${couponBaseUrl}/v1/coupon/sample/${0}/submit/approval",
            type = "post",
            dataType = "json"
    )
    ApiResult<String> submitApproval(Long id);


    /**
     * 通过口令 领取/兑换 优惠券
     * @param vo
     * @return
     */
    @Request(
            url="${couponBaseUrl}/v1/coupon/code/exchange",
            contentType = "application/json",
            timeout = 999999,
            type = "post",
            dataType = "json"
    )
    ApiResult<CouponCodeExchangeVO> exchangeCouponCode(@DataObject CouponCodeExchangeVO vo);
  
    /**
     * ezr单独发券接口
     * @param vo
     * @return
     */
    @Request(
    		url="${couponBaseUrl}/v1/coupon/send/couponSendForEZR",
            type = "post",
            dataType = "json"
    		)
    ApiResult<CouponVO> couponSendForEZR(@DataParam("couponId") Long couponId, @DataParam("memberId") Long memberId);


    @Request(
    		url = "${couponBaseUrl}/v1/campaign/getProductSkuInfoBySkuCodes",
    		type = "post",
    		dataType = "json",
    		contentType="application/json"
    		)
    ApiResult<Boolean> getProductSkuInfoBySkuCodes(@DataObject CampaignProductVO vo);

    /**
     * 创建套券模板
     * @param couponSetVO
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupon/createSet",
            contentType = "application/json",
            type = "post",
            dataType = "json"
    )
    ApiResult<String> createCouponSet(@DataObject CouponSetVO couponSetVO);

    /**
     * 编辑优惠券模板
     * @param couponSetVO
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupon/updateSet",
            contentType = "application/json",
            type = "post",
            dataType = "json"
    )
    ApiResult<String> updateCouponSet(@DataObject CouponSetVO couponSetVO);

    /**
     * 查询套券列表
     * @param couponSetCondVO
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/couponSet/listCouponSet",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CouponSetVO>> listCouponSet(@DataObject(jsonParam = "params") CouponSetCondVO couponSetCondVO);

}
