package com.thebeastshop.pegasus.component.coupon.client;

import com.thebeastshop.pegasus.component.coupon.vo.ApprovalRecordVO;
import com.thebeastshop.pegasus.component.coupon.vo.ApprovalVO;
import com.thebeastshop.pegasus.component.json.ApiResult;
import org.forest.annotation.Request;
import org.forest.annotation.var.DataObject;

import java.util.List;

/**
 * Desc:审批流程客户端
 * Created by hafiz.zhang on 2016/7/7.
 */
public interface CouponApprovalClient {

    /**
     * 获取所有审批记录信息
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/coupon/approval/list/${0}",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<ApprovalRecordVO>> listAllApproval(Long id);

    /**
     * 审批优惠券
     *
     * @param vo    审批信息
     *
     * @return
     */
    @Request(
            url="${couponBaseUrl}/v1/coupon/sample/approval",
            type="post",
            dataType = "json"
    )
    ApiResult<String> approvalCouponSample(@DataObject ApprovalVO vo);
}
