package com.thebeastshop.pegasus.component.client;

import com.thebeastshop.pegasus.component.campaign.vo.ProductScopeVO;
import com.thebeastshop.pegasus.component.json.ApiResult;
import com.thebeastshop.pegasus.component.vo.AccessWayVO;
import com.thebeastshop.pegasus.component.vo.MemberLevelVO;
import org.forest.annotation.Request;

import java.util.List;

/**
 * @author gongjun
 * @since 2016-07-12
 */
public interface CommonClient {

    /**
     * 获取所有适用平台
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/accessWays",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<AccessWayVO>> listAllAccessWays();


    /**
     * 获取所有会员等级
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/member/levels",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<MemberLevelVO>> listAllMemberLevels();


    /**
     * 获取所有商品返回
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/product/scope",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<ProductScopeVO>> listAllProductScope();

}
