package com.thebeastshop.pegasus.component.campaign.vo;

import com.thebeastshop.pegasus.component.vo.AccessWayVO;
import com.thebeastshop.pegasus.component.vo.MemberLevelVO;
import com.thebeastshop.pegasus.component.vo.StateVO;
import com.thebeastshop.pegasus.component.vo.TypeVO;

import java.util.Date;
import java.util.List;

/**
 * Desc:活动详情页面使用的VO类
 *
 * Created by hafiz.zhang on 2016/7/26.
 */
public class CampaignDetailVO {
    private Long id;                                            // 活动编号
    private TypeVO discountType;                                // 活动类型
    private String name;                                        // 活动名称
    private String code;                                        // 活动编码
    private String title;                                       // 活动标题
    private Date createTime;                                    // 活动创建时间
    private Date startTime;                                     // 活动开始时间
    private Date expireTime;                                    // 活动结束时间
    private List<AccessWayVO> accessWays;                       // 活动适用平台
    private List<MemberLevelVO> memberLevels;                   // 活动适用会员等级
    private ProductScopeVO productScope;                        // 活动商品范围
    private List<CampaignSectionVO> campaignSectionList;        // 活动优惠区间(包含所设计的额外商品)
    private Integer cumulative;                                 // 是否可累加
    private StateVO state;                                      // 活动上下线状态
    private StateVO approvalState;                              // 活动审批状态
    private String productCode;                                 // 单商品活动的适用商品Code
    private Boolean temp;                                       // 该记录是否为临时记录
    private Integer crossBorderFlag;                            // 是否为海淘活动
    private Integer advance;                                    // 是否预告
    private String advanceStr;                                  // 是否预告文字：是、否
    private String advanceName;                                 // 预告名称
    private String advanceTitle;                                // 预告文案
    private Date advanceStartTime;                              // 预告开始时间
    private Date advanceEndTime;                                // 预告结束时间
    private String advancePriceTitle;                           // 预告价格文案
    private Integer factorType;                                 // 折扣类型
    private String factorTypeStr = "";                          // 折扣类型描述
    private Integer panicBuyAmount;                             // 抢购数量
    private Integer limitAmount;                                // 折扣类型描述
    private Integer optionFlag;                                 // N元任选活动是否可以针对同一商品

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public TypeVO getDiscountType() {
        return discountType;
    }

    public void setDiscountType(TypeVO discountType) {
        this.discountType = discountType;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public List<AccessWayVO> getAccessWays() {
        return accessWays;
    }

    public void setAccessWays(List<AccessWayVO> accessWays) {
        this.accessWays = accessWays;
    }

    public List<MemberLevelVO> getMemberLevels() {
        return memberLevels;
    }

    public void setMemberLevels(List<MemberLevelVO> memberLevels) {
        this.memberLevels = memberLevels;
    }

    public ProductScopeVO getProductScope() {
        return productScope;
    }

    public void setProductScope(ProductScopeVO productScope) {
        this.productScope = productScope;
    }

    public List<CampaignSectionVO> getCampaignSectionList() {
        return campaignSectionList;
    }

    public void setCampaignSectionList(List<CampaignSectionVO> campaignSectionList) {
        this.campaignSectionList = campaignSectionList;
    }

    public Integer getCumulative() {
        return cumulative;
    }

    public void setCumulative(Integer cumulative) {
        this.cumulative = cumulative;
    }

    public StateVO getState() {
        return state;
    }

    public void setState(StateVO state) {
        this.state = state;
    }

    public StateVO getApprovalState() {
        return approvalState;
    }

    public void setApprovalState(StateVO approvalState) {
        this.approvalState = approvalState;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public Boolean getTemp() {
        return temp;
    }

    public void setTemp(Boolean temp) {
        this.temp = temp;
    }

    public Integer getCrossBorderFlag() {
        return crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    public String getAdvanceStr() {
        return advanceStr;
    }

    public void setAdvanceStr(String advanceStr) {
        this.advanceStr = advanceStr;
    }

    public Integer getAdvance() {
        return advance;
    }

    public void setAdvance(Integer advance) {
        this.advance = advance;
    }

    public String getAdvanceName() {
        return advanceName;
    }

    public void setAdvanceName(String advanceName) {
        this.advanceName = advanceName;
    }

    public String getAdvanceTitle() {
        return advanceTitle;
    }

    public void setAdvanceTitle(String advanceTitle) {
        this.advanceTitle = advanceTitle;
    }

    public Date getAdvanceStartTime() {
        return advanceStartTime;
    }

    public void setAdvanceStartTime(Date advanceStartTime) {
        this.advanceStartTime = advanceStartTime;
    }

    public Date getAdvanceEndTime() {
        return advanceEndTime;
    }

    public void setAdvanceEndTime(Date advanceEndTime) {
        this.advanceEndTime = advanceEndTime;
    }

    public String getAdvancePriceTitle() {
        return advancePriceTitle;
    }

    public void setAdvancePriceTitle(String advancePriceTitle) {
        this.advancePriceTitle = advancePriceTitle;
    }

    public Integer getFactorType() {
        return factorType;
    }

    public void setFactorType(Integer factorType) {
        this.factorType = factorType;
    }

    public String getFactorTypeStr() {
        return factorTypeStr;
    }

    public void setFactorTypeStr(String factorTypeStr) {
        this.factorTypeStr = factorTypeStr;
    }

    public Integer getPanicBuyAmount() {
        return panicBuyAmount;
    }

    public void setPanicBuyAmount(Integer panicBuyAmount) {
        this.panicBuyAmount = panicBuyAmount;
    }

    public Integer getLimitAmount() {
        return limitAmount;
    }

    public void setLimitAmount(Integer limitAmount) {
        this.limitAmount = limitAmount;
    }

    public Integer getOptionFlag() {
		return optionFlag;
	}

	public void setOptionFlag(Integer optionFlag) {
		this.optionFlag = optionFlag;
	}

	@Override
    public String toString() {
        return "CampaignDetailVO{" +
                "id=" + id +
                ", discountType=" + discountType +
                ", name='" + name + '\'' +
                ", code='" + code + '\'' +
                ", title='" + title + '\'' +
                ", createTime=" + createTime +
                ", startTime=" + startTime +
                ", expireTime=" + expireTime +
                ", accessWays=" + accessWays +
                ", memberLevels=" + memberLevels +
                ", productScope=" + productScope +
                ", campaignSectionList=" + campaignSectionList +
                ", cumulative=" + cumulative +
                ", state=" + state +
                ", approvalState=" + approvalState +
                ", productCode='" + productCode + '\'' +
                ", temp=" + temp +
                ", crossBorderFlag=" + crossBorderFlag +
                ", advance=" + advance +
                ", advanceStr='" + advanceStr + '\'' +
                ", advanceName='" + advanceName + '\'' +
                ", advanceTitle='" + advanceTitle + '\'' +
                ", advanceStartTime=" + advanceStartTime +
                ", advanceEndTime=" + advanceEndTime +
                ", advancePriceTitle='" + advancePriceTitle + '\'' +
                ", panicBuyAmount=" + panicBuyAmount +
                ", limitAmount=" + limitAmount +
                ", optionFlag='" + optionFlag +
                '}';
    }
}
