package com.thebeastshop.pegasus.component.campaign.vo;

import java.util.Date;
import java.util.List;

/**
 * Desc:创建活动的VO
 *
 * Created by hafiz.zhang on 2016/7/14.
 */
public class AddCampaignVO {
    private Long id;                                    // 活动编号
    private Integer type;                               // 活动类型  1.打折 2.满减 3.买赠 4.加价购
    private String name;                                // 活动名称
    private String code;                                // 活动编码
    private String title;                               // 活动文案
    private Date startTime;                             // 活动开始时间
    private Date expireTime;                            // 活动结束时间
    private List<Integer> accessWays;                   // 活动适用平台    0.未知  1.PC  2.APP  3.WAP  4.线下门店
    private List<Integer> memberLevels;                 // 活动适用会员等级  -1.注册会员 0.蚂蚁会员 1.小猫会员 2.老虎会员 3.大象会员
    private Integer productScope;                       // 活动适用商品范围  1.单品；2.多品；3.全场
    private List<Long> categories;                      // 活动适用商品类目编号
    private List<AddCampaignSectionVO> sectionList;     // 活动优惠区间
    private List<SectionProductVO> sectionProductList;  // 买赠类型的赠品集合、加价购类型的加价购商品的集合
    private List<AddCampaignProductVO> productList;     // 活动适用商品集合
    private Boolean cumulative = false;                 // 多次满足条件是否累积优惠
    private Long creatorId = -1L;                       // 创建者编号
    private Boolean temp = false;                       // 是否为临时记录
    private Integer crossBorderFlag = 0;                // 是否海淘   0 普通   1海淘
    private Integer factorType = -1;                    // 折扣类型 1.统一折扣 2.统一价格 3.不同折扣 4.不同价格
    private Integer isAdvance = 0;                      // 是否预告
    private String advanceName;                         // 预告名称
    private String advanceTitle;                        // 预告文案
    private Date advanceStartTime;                      // 预告开始时间
    private Date advanceEndTime;                        // 预告结束时间
    private String advancePriceTitle;                   // 预告价格文案
    private Integer panicBuyAmount;                     //抢购数量
    private Integer limitAmount;                        //限购数
    private Integer optionFlag;							// 任选活动是否可以针对同一商品

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public List<Integer> getAccessWays() {
        return accessWays;
    }

    public void setAccessWays(List<Integer> accessWays) {
        this.accessWays = accessWays;
    }

    public List<Integer> getMemberLevels() {
        return memberLevels;
    }

    public void setMemberLevels(List<Integer> memberLevels) {
        this.memberLevels = memberLevels;
    }

    public Integer getProductScope() {
        return productScope;
    }

    public void setProductScope(Integer productScope) {
        this.productScope = productScope;
    }

    public List<Long> getCategories() {
        return categories;
    }

    public void setCategories(List<Long> categories) {
        this.categories = categories;
    }

    public Boolean getCumulative() {
        return cumulative;
    }

    public void setCumulative(Boolean cumulative) {
        this.cumulative = cumulative;
    }

    public List<SectionProductVO> getSectionProductList() {
        return sectionProductList;
    }

    public void setSectionProductList(List<SectionProductVO> sectionProductList) {
        this.sectionProductList = sectionProductList;
    }

    public List<AddCampaignProductVO> getProductList() {
        return productList;
    }

    public void setProductList(List<AddCampaignProductVO> productList) {
        this.productList = productList;
    }

    public Long getCreatorId() {
        return creatorId;
    }

    public void setCreatorId(Long creatorId) {
        this.creatorId = creatorId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public List<AddCampaignSectionVO> getSectionList() {
        return sectionList;
    }

    public void setSectionList(List<AddCampaignSectionVO> sectionList) {
        this.sectionList = sectionList;
    }

    public Boolean getTemp() {
        return temp;
    }

    public void setTemp(Boolean temp) {
        this.temp = temp;
    }

    public Integer getCrossBorderFlag() {
        return crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    public Integer getFactorType() {
        return factorType;
    }

    public void setFactorType(Integer factorType) {
        this.factorType = factorType;
    }

    public Integer getIsAdvance() {
        return isAdvance;
    }

    public void setIsAdvance(Integer isAdvance) {
        this.isAdvance = isAdvance;
    }

    public String getAdvanceName() {
        return advanceName;
    }

    public void setAdvanceName(String advanceName) {
        this.advanceName = advanceName;
    }

    public String getAdvanceTitle() {
        return advanceTitle;
    }

    public void setAdvanceTitle(String advanceTitle) {
        this.advanceTitle = advanceTitle;
    }

    public Date getAdvanceStartTime() {
        return advanceStartTime;
    }

    public void setAdvanceStartTime(Date advanceStartTime) {
        this.advanceStartTime = advanceStartTime;
    }

    public Date getAdvanceEndTime() {
        return advanceEndTime;
    }

    public void setAdvanceEndTime(Date advanceEndTime) {
        this.advanceEndTime = advanceEndTime;
    }

    public String getAdvancePriceTitle() {
        return advancePriceTitle;
    }

    public void setAdvancePriceTitle(String advancePriceTitle) {
        this.advancePriceTitle = advancePriceTitle;
    }

    public Integer getPanicBuyAmount() {
        return panicBuyAmount;
    }

    public void setPanicBuyAmount(Integer panicBuyAmount) {
        this.panicBuyAmount = panicBuyAmount;
    }

    public Integer getLimitAmount() {
        return limitAmount;
    }

    public void setLimitAmount(Integer limitAmount) {
        this.limitAmount = limitAmount;
    }

    public Integer getOptionFlag() {
		return optionFlag;
	}

	public void setOptionFlag(Integer optionFlag) {
		this.optionFlag = optionFlag;
	}

	@Override
    public String toString() {
        return "AddCampaignVO{" +
                "id=" + id +
                ", type=" + type +
                ", name='" + name + '\'' +
                ", code='" + code + '\'' +
                ", title='" + title + '\'' +
                ", startTime=" + startTime +
                ", expireTime=" + expireTime +
                ", accessWays=" + accessWays +
                ", memberLevels=" + memberLevels +
                ", productScope=" + productScope +
                ", categories=" + categories +
                ", sectionList=" + sectionList +
                ", sectionProductList=" + sectionProductList +
                ", productList=" + productList +
                ", cumulative=" + cumulative +
                ", creatorId=" + creatorId +
                ", temp=" + temp +
                ", crossBorderFlag=" + crossBorderFlag +
                ", factorType=" + factorType +
                ", isAdvance=" + isAdvance +
                ", advanceName='" + advanceName + '\'' +
                ", advanceTitle='" + advanceTitle + '\'' +
                ", advanceStartTime=" + advanceStartTime +
                ", advanceEndTime=" + advanceEndTime +
                ", advancePriceTitle='" + advancePriceTitle + '\'' +
                ", panicBuyAmount=" + panicBuyAmount +
                ", limitAmount=" + limitAmount +
                ", optionFlag='" + optionFlag +
                '}';
    }
}
