package com.thebeastshop.pegasus.component.campaign.client;

import com.thebeastshop.pegasus.component.campaign.vo.*;
import com.thebeastshop.pegasus.component.coupon.vo.ApprovalRecordVO;
import com.thebeastshop.pegasus.component.coupon.vo.ApprovalVO;
import com.thebeastshop.pegasus.component.json.ApiResult;
import com.thebeastshop.pegasus.component.vo.CampaignCreatorVO;
import com.thebeastshop.pegasus.component.vo.StateVO;
import com.thebeastshop.pegasus.component.vo.TypeVO;
import org.forest.annotation.Request;
import org.forest.annotation.var.DataObject;
import org.forest.annotation.var.DataParam;

import java.util.List;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-07-04
 */
public interface CampaignClient {

    /**
     * 获取所有活动状态
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/states",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<StateVO>> listAllCampaignStates();

    @Request(
            url = "${couponBaseUrl}/v1/campaign/approvalStates",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<StateVO>> listAllApprovalStates();


    /**
     * 根据条件查询活动
     * @param cond
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaigns",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CampaignVO>> listCampaign(@DataObject(jsonParam = "params") CampaignCondVO cond);


    /**
     * 根据条件查询活动(结果与商品ID对应)
     * @param params
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/map/campaigns",
            type = "get",
            dataType = "json"
    )
    ApiResult<Map<Long, List<CampaignVO>>> mapListCampaign(@DataParam("params") String params);



    /**
     * 根据条件查询活动(结果与商品ID对应)
     * @version v1.0.1
     * @param params
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1_0_1/map/campaigns",
            type = "get",
            dataType = "json"
    )
    ApiResult<Map<Long, List<CampaignVO>>> mapListCampaign_V1_0_1(@DataParam("params") String params);



    /**
     * 获取所有活动类型
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/types",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<TypeVO>> listAllCampaignTypes();

    /**
     * 获取指定id的活动详情
     *
     * @param id    活动编号
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}",
            type = "get",
            dataType = "json"
    )
    ApiResult<CampaignVO> getCampaignById(Long id, @DataParam("temp")Boolean temp);

    /**
     * 根据活动编号获取活动详情（包括优惠区间以及额外商品）
     *
     * @param id 活动编号
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}/detail",
            type = "get",
            dataType = "json"
    )
    ApiResult<CampaignDetailVO> getCampaignDetailById(Long id, @DataParam("temp")Boolean temp);

    @Request(
            url = "${couponBaseUrl}/v1/campaign/code/${0}/detail",
            type = "get",
            dataType = "json"
    )
    ApiResult<CampaignDetailVO> getCampaignDetailByCode(String code);

    /**
     * 根据活动编号获取该活动关联的优惠区间信息
     *
     * @param id
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}/sections",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CampaignSectionVO>> getCampaignSectionById(Long id);

    /**
     * 获取所有待一级审批或者已通过一级审批的活动
     *
     * @param vo    查询条件
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/approval/first",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<PendingCampaignVO>> getFirstApprovalCampaign(@DataObject PendingCampaignCondVO vo);

    /**
     *  获取所有待二级审批或者已通过二级审批的活动
     *
     * @param vo    查询条件
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/approval/second",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<PendingCampaignVO>> getSecondApprovalCampaign(@DataObject PendingCampaignCondVO vo);

    /**
     * 根据活动编号获取活动适用商品集合
     *
     * @param id    活动编号
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}/product/include",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CampaignProductVO>> getIncludeProductList(Long id, @DataParam("temp")Boolean temp);

    /**
     * 根据活动编号获取活动适用商品集合
     *
     * @param id    活动编号
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}/sku/include",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CampaignProductVO>> getIncludeSkuList(Long id, @DataParam("temp")Boolean temp);

    /**
     * 根据活动编号获取活动排除商品
     *
     * @param id    活动编号
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}/product/exclude",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CampaignProductVO>> getExcludeProductList(Long id, @DataParam("temp")Boolean temp);

    /**
     * 根据活动编号获取活动排除商品
     *
     * @param id    活动编号
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}/sku/exclude",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CampaignProductVO>> getExcludeSkuList(Long id, @DataParam("temp")Boolean temp);

    /**
     * 根据活动编号查找该活动所涉及的所有分类目录
     *
     * @param id    活动编号
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}/category",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CampaignCategoryVO>> getCategoryListByCampaignId(Long id, @DataParam("temp")Boolean temp);

    /**
     * 根据活动编号查找该活动所涉及的所有分类类目编号集合
     * @param id
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}/categoryIds",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<String>> getCategoryIdsByCampaignId(Long id, @DataParam("temp")Boolean temp);

    /**
     * 获取所有的类目列表
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/category/list",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CampaignCategoryVO>> getAllCategories();

    /**
     * 创建活动
     *
     * @param vo    待创建活动实体
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign",
            contentType = "application/json",
            type = "post",
            dataType = "json"
    )
    ApiResult<String> addCampaign(@DataObject AddCampaignVO vo);

    @Request(
            url = "${couponBaseUrl}/v1/campaign/draft",
            contentType = "application/json",
            type = "post",
            dataType = "json"
    )
    ApiResult<String> saveAsDraft(@DataObject AddCampaignVO addCampaignVO);

    /**
     * 下线活动
     *
     * @param id 待下线活动编号
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}/offLine",
            type = "post",
            dataType = "json"
    )
    ApiResult<String> offLine(Long id);

    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}/onLine",
            type = "post",
            dataType = "json"
    )
    ApiResult<String> onLine(Long id);

    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}/revoke",
            type = "post",
            dataType = "json"
    )
    ApiResult<String> revoke(Long id);

    /**
     * 获取活动审批记录
     *
     * @param id 活动编号
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/approval/record/${0}",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<ApprovalRecordVO>> getApprovalRecords(Long id);

    /**
     * 获取所有创建过活动的人员
     *
     * @return
     */


    @Request(
            url = "${couponBaseUrl}/v1/campaign/creators",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<CampaignCreatorVO>> listAllCampaignCreators();

    @Request(
            url = "${couponBaseUrl}/v1/campaign/getProductSkuInfoBySkuCodes",
            type = "post",
            dataType = "json",
            contentType="application/json"
    )
    ApiResult<Boolean> getProductSkuInfoBySkuCodes(@DataObject CampaignProductVO vo);

    /**
     * 获取是否具有适用商品
     *
     * @param id 待查找活动编号
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}/hasIncludeProduct",
            type = "get",
            dataType = "json"
    )
    ApiResult<Boolean> hasIncludeProduct(Long id, @DataParam("temp")Boolean temp);

    /**
     * 获取是否具有排除商品
     *
     * @param id 待查找活动编号
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}/hasExcludeProduct",
            type = "get",
            dataType = "json"
    )
    ApiResult<Boolean> hasExcludeProduct(Long id, @DataParam("temp")Boolean temp);

    /**
     * 获取是否具有已勾选类目
     *
     * @param id 待查找活动编号
     *
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}/hasCategories",
            type = "get",
            dataType = "json"
    )
    ApiResult<Boolean> hasCategories(Long id, @DataParam("temp")Boolean temp);

    @Request(
            url = "${couponBaseUrl}/v1/campaign/update",
            contentType = "application/json",
            type = "post",
            dataType = "json"
    )
    ApiResult<String> updateCampaign(@DataObject AddCampaignVO vo);

    @Request(
            url = "${couponBaseUrl}/v1/campaign/commit2Approval",
            contentType = "application/json",
            type = "post",
            dataType = "json"
    )
    ApiResult<String> commit2Approval(@DataObject AddCampaignVO vo);

    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}/productList",
            type = "get",
            dataType = "json"
    )
    ApiResult<List<AddCampaignProductVO>> getCampaignProductByCode(String code);

    /**
     * 根据code查找活动的正式记录
     * @param code
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}/formal",
            type = "get",
            dataType = "json"
    )
    ApiResult<CampaignDetailVO> getFormalCampaignDetailByCode(String code);

    /**
     * 根据code查找活动的临时记录
     * @param code
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/${0}/temp",
            type = "get",
            dataType = "json"
    )
    ApiResult<CampaignDetailVO> getTempCampaignDetailByCode(String code);

    /**
     * 过滤活动所关联的商品
     * @param vo
     * @return
     */
    @Request(
            url = "${couponBaseUrl}/v1/campaign/filterCampaignProduct",
            type = "post",
            contentType = "application/json",
            dataType = "json"
    )
    ApiResult<Map<String, List<AddCampaignProductVO>>> filterCampaignProduct(@DataObject FilterCampaignProductCondVO vo);

    @Request(
            url = "${couponBaseUrl}/v1/campaign/filterCampaignSectionProduct",
            type = "post",
            contentType = "application/json",
            dataType = "json"
    )
    ApiResult<Map<String, List<SectionProductVO>>> filterCampaignSectionProduct(@DataObject FilterCampaignProductCondVO condVO);
}
