package com.thebeastshop.member.point.service;

import com.thebeastshop.member.point.vo.MemberPointTypeVO;

import java.util.Map;

/**
 * 会员类型
 * create by com.thebeastshop.member.point.service member :author lijing
 * User:lijing
 * DATE : 2016/12/5
 * TIME : 18:32
 * member.
 */
public interface MemberPointTypeService {

    /**
     * 删除会员积分类型
     * @param id
     * @throw RuntimeException()
     * @return
     */
    public Boolean deleteMemberPointTypeById(Integer id,String userName);

    /**
     * 查找会员类型
     * @param id
     * @return
     */
    public MemberPointTypeVO findMemberPointTypeById(Integer id);

    /**
     * 查找有效的类型 实时查询
     * @return
     */
    public Map<Integer,MemberPointTypeVO> findMemberPointTypeIds();


    /**
     * 查询有效的类型   走了redis 缓存 10 分钟
     * @return
     */
    public Map<Integer,MemberPointTypeVO> findMemberPointTypeAllTenCache();
}
