package com.thebeastshop.member.point.service;

import com.thebeastshop.member.point.cron.MemberCommonPointCron;
import com.thebeastshop.member.point.cron.SaveMemberPointCron;
import com.thebeastshop.member.point.exception.ArgumentException;
import com.thebeastshop.member.point.vo.MemberPointVO;
import com.thebeastshop.member.point.vo.OpMemberPointVO;
import com.thebeastshop.member.point.vo.MemberResponseVO;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 会员积分
 * create by com.thebeastshop.member.point.service member :author lijing
 * User:lijing
 * DATE : 2016/12/5
 * TIME : 15:01
 * member.
 */
public interface MemberPointService {


    /**
     * 得到会员积分信息
     * @param memberId 会员id
     * @param memberCode 会员code
     * @throws RuntimeException  参数错误
     * @return MemberPointVO
     */
    public MemberPointVO getMemberPointVO(Long memberId,String memberCode);

    /**
     * 得到等级有效的积分
     * @param memberId
     * @param memberCode
     * @return
     */
    public BigDecimal findAvailablePointByCode(Long memberId,String memberCode);


    /**
     * 得到等级积分的过期积分
     * @param memberId
     * @param memberCode
     * @return
     */
    public BigDecimal findHistoryPointByCode(Long memberId,String memberCode);

    /**
     * 得到普通积分 有效积分
     * @param memberId
     * @param memberCode
     * @return
     */
    public BigDecimal findCommonValidMemberLevelByparam(Long memberId,String memberCode);


    /**
     *查询订单金额
     * @param memberCode
     * @return
     */
    public BigDecimal findTotalConsumptionAmountByCode(String memberCode);

    /**
     * 保存增加的会员积分
     * @param saveMemberPointCron
     * @return
     */
    public Boolean saveAddOrderPoint(SaveMemberPointCron saveMemberPointCron);


    /**
     * 保存订单退款 积分 扣减的
     * @param saveMemberPointCron
     * @return
     */
    public Boolean saveSubstractOrderPoint(SaveMemberPointCron saveMemberPointCron);


    /**
     * 查询为过期的消费记录
     * @param memberId
     * @param memberCode
     * @return
     */
    public BigDecimal getSpendingAmount(Long memberId,String memberCode);


    /**
     * 最新等级变化时间之后 未过期的累计消费金额
     * @param memberId
     * @param memberCode
     * @param lastLevelUpdateTime
     * @return
     */
    public BigDecimal getSpendingAmountAfterLastLevelUpdateTime(Long memberId,String memberCode,Date lastLevelUpdateTime);

    /**
     * 积分代码合并
     * @param mainMemberCode
     * @param mainMemberId
     * @param subMemberCode
     * @param subMemberId
     * @exception  RuntimeException()
     * @return
     */
    public Boolean mergerMemberPoint(String mainMemberCode,Long mainMemberId,String subMemberCode,Long subMemberId);


    /**
     * 根据会员CODE查找积分流水
     * @param meberId
     * @param memberCode
     * @return
     */
    public List<OpMemberPointVO> findOpMemberPointVOByMemberCode (Long meberId,String memberCode);


    /**
     * 添加会员使用积分
     * @param memberCommonPointCron
     * @return
     */
    public Boolean addMemberCommonPoint(MemberCommonPointCron memberCommonPointCron) throws ArgumentException;


    /**
     * ResponseVO.meta.errno = 0 是成功   其他code 是错误
     * ResponseVO.meta.msg 是错误信息
     * @param memberCommonPointCron
     * @return
     */
    public MemberResponseVO subtractionMemberCommonPoint(MemberCommonPointCron memberCommonPointCron);

}
