package com.thebeastshop.member.point.service;

import com.thebeastshop.member.point.vo.MemberPointRelevanceVO;

/**
 * 会员积分关联表
 * create by com.thebeastshop.member.point.service member :author lijing
 * User:lijing
 * DATE : 2016/12/5
 * TIME : 15:07
 * member.
 */
public interface MemberPointRelevanceService {

    /**
     * 保存会员关联的积分
     * @throws RuntimeException 保存信息参数错误
     * @return
     */
    public Boolean saveMemberPointRelevance(String memberCode,Long memberId);

    /**
     * 修改会员关联积分表
     * @throws RuntimeException 保存信息参数错误
     * @return
     */
    public Boolean updateMemberPointRelevance(String memberCode,Long memberId,Integer tableId);

    /**
     * 删除会员关联积分表
     * @throws RuntimeException 保存信息参数错误
     * @return
     */
    public Boolean deleteMemberPointRelevance(String memberCode,Long memberId);

    /**
     * 查询
     * @param memberCode
     * @param memberId
     * @return
     */
    public MemberPointRelevanceVO findMemberPointRelevance(String memberCode,Long memberId);

}
