package com.thebeastshop.member.point.constant;

/**
 * 内容管理系统后台错误 1 表示透传错误码 02 营销中心 09 内容管理系统后台  10209XX
 * 07 表示活动
 * 错误码常量
 * @author baodk
 */
public enum CodeEnum {


    SUCCESS(0, "正常"),

    ERROR_USER_LOGIN_FALIURE(1020401, "用户未登录"),
    ERROR_USER_LOGIN_EXPIRE(1020401, "用户登录过期"),
    ERROR_USER_NOT_EXIST(1020401, "用户不存在"),
    ERROR_NO_AUTHORITY(1020403, "没有权限"),

    ERROR_SYSTEM(1020701, "系统故障"),
    ERROR_DATABASE(1020702, "数据库故障"),
    ERROR_ID_ILLEGAL(1020703, "调用方ID不合法 "),
    ERROR_ID_INVALID(1020704, "调用者ID不存在或无效"),

    ERROR_PARAM(1020705, "必要参数不合法或无效"),
    ERROR_PARAM_CHAR(1020706, "包含特殊字符"),
    ERROR_DUBBO(1020707, "dubbo远程调用出错"),
    ERROR_PARAM_VALID(1020708,"参数错误"),
    ERROR_TEMPLEMENT_VALID(1020709,"信息不存在"),
    ERROR_URL_VALID(1020710,"模板内容未配置，请先配置内容后在查看地址"),
    ERROR_UPPIC_VALID(2020911,"图片上传不合法"),
    ERROR_NOSHOPS(1020712,"该商场下没有特卖店铺！"),
    ERROR_MEMBER_TYPE_INVALIS(1020713,"会员类型无效"),
    INFORMATION_IS_NOT(1020930, "添加失败，请核实后添加"),
    REPEAT_GOODIS(102092631, "添加失败，重复goodis"),
    SUBMITERROR(1020932, "商品/卡券提交不成功，需移出或更换"),
    ERROR_UPPIC_FAIL(1020926,"图片上传错误");





    private int code;
    private String message;

    private CodeEnum(int code, String message) {
        this.code = code; 
        this.message = message;
    }

    public int getActionCode() {
        return code; 
    }
    
    public String getMessage(){
        return message;
    }
}
