/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.litx.spring;

import com.thebeastshop.litx.annotations.Compensable;
import com.thebeastshop.litx.definition.CompensableMethodDefinition;
import com.thebeastshop.litx.definition.DefinitionManager;
import com.thebeastshop.litx.definition.LitTransactionType;
import com.thebeastshop.litx.definition.MethodDefinition;
import com.thebeastshop.litx.exceptions.NoSuchRollbackMethodException;
import com.thebeastshop.litx.util.MethodUtil;
import java.lang.reflect.Method;
import org.apache.dubbo.config.spring.ReferenceBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.PriorityOrdered;

public class LitxDubboDefinationScanner
implements BeanPostProcessor,
PriorityOrdered,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(LitxDubboDefinationScanner.class);
    private static ApplicationContext applicationContext = null;
    private String appId;

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        LitxDubboDefinationScanner.applicationContext = applicationContext;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private String getRollbackMethodName(Method method) {
        String name = method.getName();
        return "rollback" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private Method getRollbackMethod(Class interfaceClass, Method method) {
        String rollbackMethodName = this.getRollbackMethodName(method);
        Class<?> returnType = method.getReturnType();
        try {
            return interfaceClass.getMethod(rollbackMethodName, returnType);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchRollbackMethodException(method.getName(), rollbackMethodName, returnType);
        }
    }

    private void registerDefinationList(Class targetClass) {
        Method[] methods;
        for (Method method : methods = targetClass.getDeclaredMethods()) {
            Compensable compensable = method.getAnnotation(Compensable.class);
            if (compensable == null) continue;
            Method rollbackMethod = this.getRollbackMethod(targetClass, method);
            MethodDefinition rollbackDefinition = new MethodDefinition(LitTransactionType.ROLLBACK, this.appId, targetClass, rollbackMethod);
            CompensableMethodDefinition definition = new CompensableMethodDefinition(this.appId, targetClass, method, rollbackDefinition);
            DefinitionManager.registerMethodDefination((Class)targetClass, (Method)method, (MethodDefinition)definition);
            log.info(" [LITX] \u6ce8\u518cDUBBO\u7684\u53ef\u8865\u507f\u4e8b\u52a1\u63a5\u53e3 " + MethodUtil.getMethodNameWithParameterTypes((Class)targetClass, (Method)method) + ", \u548c\u5b83\u7684\u8865\u507f\u65b9\u6cd5 " + MethodUtil.getMethodNameWithParameterTypes((Class)targetClass, (Method)rollbackMethod));
        }
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> clazz = bean.getClass();
        if (ReferenceBean.class.isAssignableFrom(clazz)) {
            ReferenceBean referenceBean = (ReferenceBean)bean;
            Class targetClass = referenceBean.getObjectType();
            this.registerDefinationList(targetClass);
        }
        return bean;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

