/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.litx.test.service.impl;

import com.thebeastshop.litx.test.service.TestService;
import com.thebeastshop.stock.dto.SStockOccupyDTO;
import com.thebeastshop.stock.dto.SStockReleaseDTO;
import com.thebeastshop.stock.enums.SStockInOutTypeEnum;
import com.thebeastshop.stock.enums.SStockOccupyTypeEnum;
import com.thebeastshop.stock.enums.SStockOperationTypeEnum;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.vo.SStockRecordVO;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="testService")
public class TestServiceImpl
implements TestService {
    private static final Logger log = LoggerFactory.getLogger(TestServiceImpl.class);
    @Autowired
    private SStockService sStockService;

    private void doTest() {
        log.info("start litx test1");
        SStockRecordVO recordVO = new SStockRecordVO();
        recordVO.setSkuCode("S00301000014322");
        recordVO.setWarehouseCode("WH020600010102");
        recordVO.setQuantity(Integer.valueOf(1));
        recordVO.setInOutType(SStockInOutTypeEnum.IN_TYPE_ALLOT.getCode());
        this.sStockService.record(recordVO);
        ArrayList<SStockOccupyDTO> occupyList = new ArrayList<SStockOccupyDTO>();
        SStockOccupyDTO occupy1 = new SStockOccupyDTO(SStockOccupyTypeEnum.TYPE_MOVE_OUT);
        occupy1.setOperationType(SStockOperationTypeEnum.DEFAULT);
        occupy1.setQuantity(Integer.valueOf(2));
        occupy1.setSkuCode("TEST0001");
        occupy1.setWarehouseCode("WH020600010102");
        occupy1.setOccupyTime(new Date());
        occupy1.setReferenceCode("SO0110040000243779010004");
        occupyList.add(occupy1);
        this.sStockService.occupy(occupyList);
        SStockReleaseDTO releaseDTO = new SStockReleaseDTO(SStockOccupyTypeEnum.TYPE_MOVE_OUT);
        releaseDTO.setOperationType(SStockOperationTypeEnum.DEFAULT);
        releaseDTO.setReferenceCode("SO0110040000243779010004");
        this.sStockService.release(releaseDTO);
    }

    @Override
    @Transactional
    public Boolean test1() {
        this.doTest();
        this.test2();
        return true;
    }

    @Override
    @Transactional
    public Boolean test2() {
        throw new RuntimeException("\u6545\u610f\u5931\u8d25");
    }
}

