/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.es.dao;

import com.thebeastshop.es.annotation.EsDaoConfig;
import com.thebeastshop.es.dao.EsUtil;
import com.thebeastshop.es.dao.core.AbstractEsDao;
import com.thebeastshop.es.spring.ElasticsearchClientFactory;
import com.thebeastshop.scm.es.PsCategoryCampaignVO;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.springframework.beans.factory.annotation.Autowired;

@EsDaoConfig(id="id", type="pubcategorycampaign")
public class CategoryCampaignEsDao
extends AbstractEsDao<PsCategoryCampaignVO> {
    @Autowired
    public CategoryCampaignEsDao(ElasticsearchClientFactory elasticsearchClientFactory) {
        super(elasticsearchClientFactory);
    }

    public void batchSave(List<PsCategoryCampaignVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequest bulkRequest = new BulkRequest();
        for (PsCategoryCampaignVO vo : list) {
            Map sourceMap = vo.toMap();
            String id = MapUtils.getString((Map)sourceMap, (Object)this.id);
            if (this.byId(id) == null) {
                IndexRequest indexRequest = this.getIndexRequest(id, sourceMap);
                bulkRequest.add(indexRequest);
                continue;
            }
            UpdateRequest updateRequest = this.getUpdateRequest(id, sourceMap);
            bulkRequest.add(updateRequest);
        }
        EsUtil.bulk(this.client, bulkRequest, "CategoryCampaignEsDao.batchSave.List<PsCategoryCampaignVO>", null);
    }

    @Override
    public PsCategoryCampaignVO toBean(Map<String, Object> sourceMap) {
        if (MapUtils.isEmpty(sourceMap)) {
            return null;
        }
        PsCategoryCampaignVO psCategoryCampaignVO = new PsCategoryCampaignVO();
        psCategoryCampaignVO.setId(MapUtils.getLong(sourceMap, (Object)"id"));
        psCategoryCampaignVO.setPsCampaignVOs((List)sourceMap.get("psCampaignVOs"));
        psCategoryCampaignVO.setPsCampaignVOSize(MapUtils.getInteger(sourceMap, (Object)"psCampaignVOSize"));
        return (PsCategoryCampaignVO)super.toBean(sourceMap);
    }

    @Override
    public Map<String, Object> toMap(PsCategoryCampaignVO psCategoryCampaignVO) {
        return super.toMap(psCategoryCampaignVO);
    }
}

