package com.thebeastshop.es.spring;

import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.client.transport.TransportClient;






import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.xpack.client.PreBuiltXPackTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

//import org.elasticsearch.common.collect.Lists;
//import org.elasticsearch.common.settings.ImmutableSettings;

public class ElasticsearchClientFactory {
	protected static final Logger log = LoggerFactory.getLogger(ElasticsearchClientFactory.class);

	private String clusterName;
	private String index;
	private String address;
	private String username;
	private String password;


	public String getClusterName() {
		return clusterName;
	}

	public void setClusterName(String clusterName) {
		this.clusterName = clusterName;
	}

	public String getIndex() {
		return index;
	}

	public void setIndex(String index) {
		this.index = index;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public Settings getSettings() {
		if (StringUtils.isEmpty(clusterName) || clusterName.equals("null"))
			return null;

		return null;

		/*
		Settings settings = Settings.builder()
				.put("cluster.name", clusterName)
				.put("client.transport.sniff", false)
				.build();
		return settings;
		*/

	}

	public TransportClient createClient() {
		TransportClient client = null;
		Settings settings = getSettings();

		if (settings != null) {
			Class<?> clazz = null;
			try {
				clazz = Class.forName(TransportClient.class.getName());
				Constructor<?> constructor = clazz.getDeclaredConstructor(Settings.class);
				constructor.setAccessible(true);
				client = (TransportClient) constructor.newInstance(settings);
			} catch (Exception e) {
				log.error("创建ES客户端失败：" + e);
				return null;
			}
		}
	else {
			//client = new TransportClient();
			 settings=  Settings.builder()
					 .put("cluster.name", this.getClusterName())
					 .put("client.transport.sniff", false)
					 .put("xpack.security.transport.ssl.enabled", false)
					 .put("xpack.security.user", this.getUsername() + ":" + this.getPassword()).build();
			 client = new PreBuiltXPackTransportClient(settings);
		}

		if (client == null){
			log.warn("client is null");
		}	
		List<InetSocketTransportAddress> addressList = getAddressList();
		for (InetSocketTransportAddress address : addressList) {
			client.addTransportAddress(address);
		}
		return client;
	}

	public List<InetSocketTransportAddress> getAddressList() {
		if (StringUtils.isBlank(address)) {
			return Lists.newArrayList();
		}
		String[] addrs = address.split(",");
		if (addrs.length == 0) {
			return Lists.newArrayList();
		}
		List<InetSocketTransportAddress> list = new ArrayList<>();
		for (String addr : addrs) {
			if (StringUtils.isBlank(addr)) continue;
			String[] parts = addr.split(":");
			if (parts.length < 2) continue;
			String host = parts[0];
			String portStr = parts[1];
			Integer port = null;
			try {
				port = Integer.parseInt(portStr);
			} catch (Throwable th) {
			}
			if (port == null) continue;
			InetAddress hostAddress = null;
			try {
				hostAddress = InetAddress.getByName(host);
			} catch (UnknownHostException e) {
				e.printStackTrace();
			}
			InetSocketTransportAddress inetSocketTransportAddress = new InetSocketTransportAddress(hostAddress, port);
			list.add(inetSocketTransportAddress);
		}
		return list;
	}

}
