/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.es.spring;

import com.thebeastshop.es.spring.CustomConnectionKeepAliveStrategy;
import java.util.ArrayList;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.settings.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchClientFactory {
    protected static final Logger log = LoggerFactory.getLogger(ElasticsearchClientFactory.class);
    private String clusterName;
    private String index;
    private String address;
    private String username;
    private String password;

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Settings getSettings() {
        return null;
    }

    public RestHighLevelClient createClient() {
        String[] hostList;
        ArrayList<HttpHost> hostLists = new ArrayList<HttpHost>();
        for (String addr : hostList = this.address.split(",")) {
            String host = addr.split(":")[0];
            String port = addr.split(":")[1];
            hostLists.add(new HttpHost(host, Integer.parseInt(port), "http"));
        }
        HttpHost[] httpHost = hostLists.toArray(new HttpHost[0]);
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHost);
        builder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){

            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpAsyncClientBuilder) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(ElasticsearchClientFactory.this.username, ElasticsearchClientFactory.this.password));
                httpAsyncClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                httpAsyncClientBuilder.setMaxConnTotal(100);
                httpAsyncClientBuilder.setMaxConnPerRoute(100);
                httpAsyncClientBuilder.setKeepAliveStrategy((ConnectionKeepAliveStrategy)CustomConnectionKeepAliveStrategy.INSTANCE);
                return httpAsyncClientBuilder;
            }
        });
        builder.setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

            public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder builder) {
                builder.setConnectTimeout(10000);
                builder.setSocketTimeout(30000);
                builder.setConnectionRequestTimeout(5000);
                return builder;
            }
        });
        builder.setMaxRetryTimeoutMillis(300000);
        return new RestHighLevelClient(builder);
    }
}

