package com.thebeastshop.es.dao;

import com.thebeastshop.es.annotation.EsDaoConfig;
import com.thebeastshop.es.dao.core.AbstractEsDao;
import com.thebeastshop.es.spring.ElasticsearchClientFactory;
import com.thebeastshop.scm.es.PsAttributeValuePairVO;
import com.thebeastshop.scm.es.PsSpvVO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-11-03
 */
@EsDaoConfig(id = "spvId", type = "pubspv")
public class SpvEsDao extends AbstractEsDao<PsSpvVO> {

    @Autowired
    public SpvEsDao(ElasticsearchClientFactory elasticsearchClientFactory) {
        super(elasticsearchClientFactory);
    }

    public void batchSave(List<PsSpvVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequest bulkRequest = new BulkRequest();
        for (PsSpvVO vo : list) {
            Map<String, Object> sourceMap = this.toMap(vo);
            String id = MapUtils.getString(sourceMap, this.id);
            if (this.byId(id) == null) {
                IndexRequest indexRequest = this.getIndexRequest(id, sourceMap);
                bulkRequest.add(indexRequest);
            } else {
                UpdateRequest updateRequest = this.getUpdateRequest(id, sourceMap);
                bulkRequest.add(updateRequest);
            }
        }
        EsUtil.bulk(client,bulkRequest,"SpvEsDao.batchSave.List<PsSpvVO>",null);
    }

    @Override
    public PsSpvVO toBean(Map<String, Object> sourceMap) {
        if (MapUtils.isEmpty(sourceMap)) {
            return null;
        }
        PsSpvVO psSpvVO = new PsSpvVO();
        psSpvVO.setSpvId(MapUtils.getInteger(sourceMap, "spvId"));
        psSpvVO.setProductId(MapUtils.getInteger(sourceMap, "productId"));
        psSpvVO.setProdCode(MapUtils.getString(sourceMap, "prodCode"));
        psSpvVO.setCombined(MapUtils.getInteger(sourceMap, "combined"));
        psSpvVO.setAttrs(MapUtils.getString(sourceMap, "attrs"));
        psSpvVO.setMinAmount(MapUtils.getInteger(sourceMap, "minAmount"));
        psSpvVO.setBu(MapUtils.getString(sourceMap, "bu"));
        Double salesPrice = MapUtils.getDouble(sourceMap, "salesPrice");
        if (salesPrice != null) {
            psSpvVO.setSalesPrice(new BigDecimal(salesPrice));
        }
        Double originalPrice = MapUtils.getDouble(sourceMap, "originalPrice");
        if (originalPrice != null) {
            psSpvVO.setOriginalPrice(new BigDecimal(originalPrice));
        }
        Object skuCombinationList = sourceMap.get("skuCombinationList");
        if (skuCombinationList != null) {
            psSpvVO.setSkuCombinationList((List<Map>) skuCombinationList);
        }
        psSpvVO.setSpvImg(MapUtils.getString(sourceMap, "spvImg"));
        psSpvVO.setAttrValue1(MapUtils.getString(sourceMap, "attrValue1"));
        psSpvVO.setAttrValue2(MapUtils.getString(sourceMap, "attrValue2"));
        psSpvVO.setAttrValue3(MapUtils.getString(sourceMap, "attrValue3"));
        return psSpvVO;
    }

    @Override
    public Map<String, Object> toMap(PsSpvVO psSpvVO) {
        Map<String, Object> sourceMap = new LinkedHashMap<String, Object>();
        sourceMap.put("spvId", psSpvVO.getSpvId());
        sourceMap.put("productId", psSpvVO.getProductId());
        sourceMap.put("prodCode", psSpvVO.getProdCode());
        sourceMap.put("combined", psSpvVO.getCombined());
        sourceMap.put("attrs", psSpvVO.getAttrs());
        sourceMap.put("bu",psSpvVO.getBu());
        sourceMap.put("categoryId", psSpvVO.getCategoryId());
        List<PsAttributeValuePairVO> pairs = psSpvVO.getAttributeValuePairList();
        List<Map> pairMapList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(pairs)) {
            for (PsAttributeValuePairVO pair : pairs) {
                pairMapList.add(pair.toMap());
            }
        }
        sourceMap.put("attributeValuePairList", pairMapList);
        Integer minAmount = psSpvVO.getMinAmount();
        if (minAmount != null && minAmount.intValue() < 1) {
            minAmount = 1;
        }
        sourceMap.put("minAmount", minAmount);
        BigDecimal salesPrice = psSpvVO.getSalesPrice();
        BigDecimal originalPrice = psSpvVO.getOriginalPrice();
        if (salesPrice == null) {
            salesPrice = BigDecimal.ZERO;
        }
        if (originalPrice == null) {
            originalPrice = BigDecimal.ZERO;
        }
        sourceMap.put("salesPrice", salesPrice.doubleValue());
        sourceMap.put("originalPrice", originalPrice.doubleValue());
        if (psSpvVO.getCombined() == null || psSpvVO.getCombined() == 0) {
            sourceMap.put("skuCode", psSpvVO.getSkuCode());
            sourceMap.put("attrValue1", psSpvVO.getAttrValue1());
            sourceMap.put("attrValue2", psSpvVO.getAttrValue2());
            sourceMap.put("attrValue3", psSpvVO.getAttrValue3());
        }
        sourceMap.put("skuCombinationList", psSpvVO.getSkuCombinationList());
        List<Map> campaignListMap = toListMap(psSpvVO.getCampaignList());
        sourceMap.put("campaignList", campaignListMap);
        sourceMap.put("spvImg", psSpvVO.getSpvImg());
        return sourceMap;
    }
}
