package com.thebeastshop.es.spring;

import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;



import org.elasticsearch.common.settings.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

//import org.elasticsearch.common.collect.Lists;
//import org.elasticsearch.common.settings.ImmutableSettings;

public class ElasticsearchClientFactory {
	protected static final Logger log = LoggerFactory.getLogger(ElasticsearchClientFactory.class);

	private String clusterName;
	private String index;
	private String address;
	private String username;
	private String password;


	public String getClusterName() {
		return clusterName;
	}

	public void setClusterName(String clusterName) {
		this.clusterName = clusterName;
	}

	public String getIndex() {
		return index;
	}

	public void setIndex(String index) {
		this.index = index;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public Settings getSettings() {
		return null;
	}

	public RestHighLevelClient createClient() {
		// 拆分地址
		List<HttpHost> hostLists = new ArrayList<>();
		String[] hostList = address.split(",");
		for (String addr : hostList) {
			String host = addr.split(":")[0];
			String port = addr.split(":")[1];
			hostLists.add(new HttpHost(host, Integer.parseInt(port), "http"));
		}
		// 转换成 HttpHost 数组
		HttpHost[] httpHost = hostLists.toArray(new HttpHost[]{});

		//System.out.println("toURI=" + httpHost[0].toURI());

		// 构建连接对象
		RestClientBuilder builder = RestClient.builder(httpHost);



		// 异步连接数配置
		builder.setHttpClientConfigCallback( new RestClientBuilder.HttpClientConfigCallback(){
			@Override
			public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpAsyncClientBuilder) {
				CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
				credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(username, password));
				httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
				httpAsyncClientBuilder.setMaxConnTotal(100);
				httpAsyncClientBuilder.setMaxConnPerRoute(100);
				return httpAsyncClientBuilder;
			}
		}
		);


		// 异步连接延时配置
		builder.setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback() {
			@Override
			public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder builder) {
				builder.setConnectTimeout(5000);
				builder.setSocketTimeout(15000);
				builder.setConnectionRequestTimeout(5000);
				return builder;
			}
		});

		builder.setMaxRetryTimeoutMillis(300 * 1000);

		return new RestHighLevelClient(builder);
	}


}
