package com.thebeastshop.es.dao;

import com.thebeastshop.es.annotation.EsDaoConfig;
import com.thebeastshop.es.dao.core.AbstractEsDao;
import com.thebeastshop.es.spring.ElasticsearchClientFactory;
import com.thebeastshop.scm.es.PsCategoryCampaignVO;
import com.thebeastshop.scm.es.PsSearchSuggestVO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Map;

/**
 * Created by gensheng.ye on 2017/12/28.
 */
@EsDaoConfig(id = "id", type = "pubsearchsuggest")
public class SearchSuggestEsDao extends AbstractEsDao<PsSearchSuggestVO> {

    @Autowired
    public SearchSuggestEsDao(ElasticsearchClientFactory elasticsearchClientFactory) {
        super(elasticsearchClientFactory);
    }


    public void batchSave(List<PsSearchSuggestVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequestBuilder bulkRequest = client.prepareBulk();
        for (PsSearchSuggestVO vo : list) {
            Map<String, Object> sourceMap = vo.toMap();
            String id = MapUtils.getString(sourceMap, this.id);
            if (this.byId(id) == null) {
                IndexRequest indexRequest = this.getIndexRequest(id, sourceMap);
                bulkRequest.add(indexRequest);
            } else {
                UpdateRequest updateRequest = this.getUpdateRequest(id, sourceMap);
                bulkRequest.add(updateRequest);
            }
        }
        bulkRequest.execute().actionGet();
    }

}
