/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.es.dao;

import com.thebeastshop.es.annotation.EsDaoConfig;
import com.thebeastshop.es.dao.core.AbstractEsDao;
import com.thebeastshop.es.spring.ElasticsearchClientFactory;
import com.thebeastshop.scm.es.PsCampaignVO;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.springframework.beans.factory.annotation.Autowired;

@EsDaoConfig(id="id", type="pubcampaign")
public class CampaignEsDao
extends AbstractEsDao<PsCampaignVO> {
    @Autowired
    public CampaignEsDao(ElasticsearchClientFactory elasticsearchClientFactory) {
        super(elasticsearchClientFactory);
    }

    public void batchSave(List<PsCampaignVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (PsCampaignVO vo : list) {
            Map sourceMap = vo.toMap();
            String id = MapUtils.getString((Map)sourceMap, (Object)this.id);
            if (this.byId(id) == null) {
                IndexRequest indexRequest = this.getIndexRequest(id, sourceMap);
                bulkRequest.add(indexRequest);
                continue;
            }
            UpdateRequest updateRequest = this.getUpdateRequest(id, sourceMap);
            bulkRequest.add(updateRequest);
        }
        bulkRequest.execute().actionGet();
    }

    @Override
    public Map<String, Object> toMap(PsCampaignVO psCampaignVO) {
        return super.toMap(psCampaignVO);
    }

    @Override
    public PsCampaignVO toBean(Map<String, Object> sourceMap) {
        PsCampaignVO psCampaignVO = new PsCampaignVO();
        psCampaignVO.setId(MapUtils.getLong(sourceMap, (Object)"id"));
        psCampaignVO.setCrossBorderFlag(MapUtils.getInteger(sourceMap, (Object)"crossBorderFlag"));
        psCampaignVO.setDiscountTypeId(MapUtils.getInteger(sourceMap, (Object)"discountTypeId"));
        psCampaignVO.setName(MapUtils.getString(sourceMap, (Object)"name"));
        return psCampaignVO;
    }
}

