/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.es.dao;

import com.thebeastshop.es.annotation.EsDaoConfig;
import com.thebeastshop.es.dao.core.AbstractEsDao;
import com.thebeastshop.es.spring.ElasticsearchClientFactory;
import com.thebeastshop.scm.es.PsAttributeValuePairVO;
import com.thebeastshop.scm.es.PsSpvVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.springframework.beans.factory.annotation.Autowired;

@EsDaoConfig(id="spvId", type="pubspv")
public class SpvEsDao
extends AbstractEsDao<PsSpvVO> {
    @Autowired
    public SpvEsDao(ElasticsearchClientFactory elasticsearchClientFactory) {
        super(elasticsearchClientFactory);
    }

    public void batchSave(List<PsSpvVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (PsSpvVO vo : list) {
            Map<String, Object> sourceMap = this.toMap(vo);
            String id = MapUtils.getString(sourceMap, (Object)this.id);
            if (this.byId(id) == null) {
                IndexRequest indexRequest = this.getIndexRequest(id, sourceMap);
                bulkRequest.add(indexRequest);
                continue;
            }
            UpdateRequest updateRequest = this.getUpdateRequest(id, sourceMap);
            bulkRequest.add(updateRequest);
        }
        bulkRequest.execute().actionGet();
    }

    @Override
    public PsSpvVO toBean(Map<String, Object> sourceMap) {
        Object skuCombinationList;
        if (MapUtils.isEmpty(sourceMap)) {
            return null;
        }
        PsSpvVO psSpvVO = new PsSpvVO();
        psSpvVO.setSpvId(MapUtils.getInteger(sourceMap, (Object)"spvId"));
        psSpvVO.setProductId(MapUtils.getInteger(sourceMap, (Object)"productId"));
        psSpvVO.setProdCode(MapUtils.getString(sourceMap, (Object)"prodCode"));
        psSpvVO.setCombined(MapUtils.getInteger(sourceMap, (Object)"combined"));
        psSpvVO.setAttrs(MapUtils.getString(sourceMap, (Object)"attrs"));
        psSpvVO.setMinAmount(MapUtils.getInteger(sourceMap, (Object)"minAmount"));
        Double salesPrice = MapUtils.getDouble(sourceMap, (Object)"salesPrice");
        if (salesPrice != null) {
            psSpvVO.setSalesPrice(new BigDecimal(salesPrice));
        }
        if ((skuCombinationList = sourceMap.get("skuCombinationList")) != null) {
            psSpvVO.setSkuCombinationList((List)skuCombinationList);
        }
        return psSpvVO;
    }

    @Override
    public Map<String, Object> toMap(PsSpvVO psSpvVO) {
        LinkedHashMap<String, Object> sourceMap = new LinkedHashMap<String, Object>();
        sourceMap.put("spvId", psSpvVO.getSpvId());
        sourceMap.put("productId", psSpvVO.getProductId());
        sourceMap.put("prodCode", psSpvVO.getProdCode());
        sourceMap.put("combined", psSpvVO.getCombined());
        sourceMap.put("attrs", psSpvVO.getAttrs());
        List pairs = psSpvVO.getAttributeValuePairList();
        ArrayList<Map> pairMapList = new ArrayList<Map>();
        if (CollectionUtils.isNotEmpty((Collection)pairs)) {
            for (PsAttributeValuePairVO pair : pairs) {
                pairMapList.add(pair.toMap());
            }
        }
        sourceMap.put("attributeValuePairList", pairMapList);
        Integer minAmount = psSpvVO.getMinAmount();
        if (minAmount != null && minAmount < 1) {
            minAmount = 1;
        }
        sourceMap.put("minAmount", minAmount);
        BigDecimal salesPrice = psSpvVO.getSalesPrice();
        if (salesPrice == null) {
            salesPrice = BigDecimal.ZERO;
        }
        sourceMap.put("salesPrice", salesPrice.doubleValue());
        if (psSpvVO.getCombined() == null || psSpvVO.getCombined() == 0) {
            sourceMap.put("skuCode", psSpvVO.getSkuCode());
        }
        sourceMap.put("skuCombinationList", psSpvVO.getSkuCombinationList());
        List<Map> campaignListMap = this.toListMap(psSpvVO.getCampaignList());
        sourceMap.put("campaignList", campaignListMap);
        return sourceMap;
    }
}

