/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.es.dao;

import com.thebeastshop.es.annotation.EsDaoConfig;
import com.thebeastshop.es.dao.SpvEsDao;
import com.thebeastshop.es.dao.core.AbstractEsDao;
import com.thebeastshop.es.spring.ElasticsearchClientFactory;
import com.thebeastshop.scm.es.PsAttributeVO;
import com.thebeastshop.scm.es.PsBrandVO;
import com.thebeastshop.scm.es.PsChnProdSaleSku;
import com.thebeastshop.scm.es.PsChnProdTimeCodeInfo;
import com.thebeastshop.scm.es.PsDeliveryVO;
import com.thebeastshop.scm.es.PsDynmContentVO;
import com.thebeastshop.scm.es.PsProductVO;
import com.thebeastshop.scm.es.PsSpvVO;
import com.thebeastshop.scm.es.PsTagVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.joda.time.format.DateTimeFormat;
import org.springframework.beans.factory.annotation.Autowired;

@EsDaoConfig(id="id", type="pubprod")
public class ProductEsDao
extends AbstractEsDao<PsProductVO> {
    @Resource
    private SpvEsDao spvEsDao;

    @Autowired
    public ProductEsDao(ElasticsearchClientFactory elasticsearchClientFactory) {
        super(elasticsearchClientFactory);
    }

    public void batchSave(List<PsProductVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (PsProductVO vo : list) {
            Map<String, Object> sourceMap = this.toMap(vo);
            try {
                sourceMap.put("psTags", this.toListMap(vo.getPsTags()));
            }
            catch (Exception ex) {
                this.log.error(ex.toString());
            }
            String id = MapUtils.getString(sourceMap, (Object)this.id);
            if (this.byId(id) == null) {
                IndexRequest indexRequest = this.getIndexRequest(id, sourceMap);
                bulkRequest.add(indexRequest);
                continue;
            }
            UpdateRequest updateRequest = this.getUpdateRequest(id, sourceMap);
            bulkRequest.add(updateRequest);
        }
        bulkRequest.execute().actionGet();
    }

    public void batchUpdateCalSaleProd(List<PsProductVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (PsProductVO vo : list) {
            List PsChnProdTimeCodeInfo;
            if (this.byId(vo.getId() + "") == null) {
                this.log.warn("productId:{} ES\u6ca1\u6709\u67e5\u5230", (Object)vo.getId());
                return;
            }
            HashMap<String, Object> sourceMap = new HashMap<String, Object>();
            sourceMap.put("chnSaleChnCodes", vo.getChnSaleChnCodes());
            sourceMap.put("onShelfChnCodes", vo.getOnShelfChnCodes());
            sourceMap.put("offShelfChnCodes", vo.getOffShelfChnCodes());
            sourceMap.put("chnCanSaleSKu", this.toListMap(vo.getChnCanSaleSKu()));
            sourceMap.put("chnCanSeeSKu", this.toListMap(vo.getChnCanSeeSKu()));
            if (vo.getListPrice() != null) {
                sourceMap.put("listPrice", vo.getListPrice().doubleValue());
            }
            if (vo.getListPriceSkuCode() != null) {
                sourceMap.put("listPriceSkuCode", vo.getListPriceSkuCode());
            }
            if (vo.getListPriceSpvId() != null) {
                sourceMap.put("listPriceSpvId", vo.getListPriceSpvId());
            }
            sourceMap.put("listPriceList", vo.getListPriceList());
            if (vo.getStocks() != null) {
                sourceMap.put("stocks", vo.getStocks());
            }
            if (vo.getPrimaryUpdateTime() != null) {
                sourceMap.put("primaryUpdateTime", vo.getPrimaryUpdateTime());
            }
            if (vo.getPrimaryUpdateLong() != null) {
                sourceMap.put("primaryUpdateLong", vo.getPrimaryUpdateLong());
            }
            if (CollectionUtils.isNotEmpty((Collection)(PsChnProdTimeCodeInfo = vo.getChannelProdInfo()))) {
                sourceMap.put("channelProdInfo", this.toListMap(PsChnProdTimeCodeInfo));
            }
            UpdateRequest updateRequest = this.getUpdateRequest(vo.getId() + "", sourceMap);
            bulkRequest.add(updateRequest);
        }
        bulkRequest.execute().actionGet();
    }

    public void batchUpdateSku(List<PsProductVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (PsProductVO vo : list) {
            if (this.byId(vo.getId() + "") == null) {
                this.log.warn("productId:{} ES\u6ca1\u6709\u67e5\u5230", (Object)vo.getId());
                return;
            }
            HashMap<String, Object> sourceMap = new HashMap<String, Object>();
            sourceMap.put("skuCodes", vo.getSkuCodes());
            sourceMap.put("categoryId", vo.getCategoryId());
            sourceMap.put("categoryCode", vo.getCategoryCode());
            UpdateRequest updateRequest = this.getUpdateRequest(vo.getId() + "", sourceMap);
            bulkRequest.add(updateRequest);
        }
        bulkRequest.execute().actionGet();
    }

    public void batchUpdateSelfDeliveries(List<PsProductVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (PsProductVO vo : list) {
            if (this.byId(vo.getId() + "") == null) {
                this.log.warn("productId:{} ES\u6ca1\u6709\u67e5\u5230", (Object)vo.getId());
                return;
            }
            HashMap<String, List<Map>> sourceMap = new HashMap<String, List<Map>>();
            sourceMap.put("selfDeliveries", this.toListMap(vo.getSelfDeliveries()));
            UpdateRequest updateRequest = this.getUpdateRequest(vo.getId(), sourceMap);
            bulkRequest.add(updateRequest);
        }
        bulkRequest.execute().actionGet();
    }

    public void batchUpdateDymnContent(List<PsProductVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (PsProductVO vo : list) {
            if (this.byId(vo.getId() + "") == null) {
                this.log.warn("productId:{} ES\u6ca1\u6709\u67e5\u5230", (Object)vo.getId());
                return;
            }
            HashMap<String, List<Map>> sourceMap = new HashMap<String, List<Map>>();
            sourceMap.put("dynmContents", this.toListMap(vo.getDynmContents()));
            UpdateRequest updateRequest = this.getUpdateRequest(vo.getId() + "", sourceMap);
            bulkRequest.add(updateRequest);
        }
        bulkRequest.execute().actionGet();
    }

    public void batchUpdateBrand(List<PsProductVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (PsProductVO vo : list) {
            if (this.byId(vo.getId() + "") == null) {
                this.log.warn("productId:{} ES\u6ca1\u6709\u67e5\u5230", (Object)vo.getId());
                return;
            }
            HashMap<String, List> sourceMap = new HashMap<String, List>();
            sourceMap.put("brandList", vo.getBrandList());
            UpdateRequest updateRequest = this.getUpdateRequest(vo.getId() + "", sourceMap);
            bulkRequest.add(updateRequest);
        }
        bulkRequest.execute().actionGet();
    }

    public void batchUpdateLabel(List<PsProductVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (PsProductVO vo : list) {
            if (this.byId(vo.getId() + "") == null) {
                this.log.warn("productId:{} ES\u6ca1\u6709\u67e5\u5230", (Object)vo.getId());
                return;
            }
            HashMap<String, List> sourceMap = new HashMap<String, List>();
            sourceMap.put("labels", vo.getLabels());
            UpdateRequest updateRequest = this.getUpdateRequest(vo.getId() + "", sourceMap);
            bulkRequest.add(updateRequest);
        }
        bulkRequest.execute().actionGet();
    }

    public void batchUpdateAttribute(List<PsProductVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (PsProductVO vo : list) {
            if (this.byId(vo.getId() + "") == null) {
                this.log.warn("productId:{} ES\u6ca1\u6709\u67e5\u5230", (Object)vo.getId());
                return;
            }
            HashMap<String, List<Map>> sourceMap = new HashMap<String, List<Map>>();
            sourceMap.put("attributeList", this.toListMap(vo.getAttributeList()));
            UpdateRequest updateRequest = this.getUpdateRequest(vo.getId() + "", sourceMap);
            bulkRequest.add(updateRequest);
        }
        bulkRequest.execute().actionGet();
    }

    public void batchUpdateSpv(List<PsProductVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (PsProductVO vo : list) {
            if (this.byId(vo.getId() + "") == null) {
                this.log.warn("productId:{} ES\u6ca1\u6709\u67e5\u5230", (Object)vo.getId());
                return;
            }
            HashMap<String, Object> sourceMap = new HashMap<String, Object>();
            ArrayList<Map<String, Object>> spvListMap = new ArrayList<Map<String, Object>>();
            for (PsSpvVO spvVO : vo.getSpvList()) {
                spvListMap.add(this.spvEsDao.toMap(spvVO));
            }
            if (vo.getListPrice() != null) {
                sourceMap.put("listPrice", vo.getListPrice().doubleValue());
            }
            if (vo.getListPriceSkuCode() != null) {
                sourceMap.put("listPriceSkuCode", vo.getListPriceSkuCode());
            }
            if (vo.getListPriceSpvId() != null) {
                sourceMap.put("listPriceSpvId", vo.getListPriceSpvId());
            }
            sourceMap.put("listPriceList", vo.getListPriceList());
            sourceMap.put("spvList", spvListMap);
            UpdateRequest updateRequest = this.getUpdateRequest(vo.getId() + "", sourceMap);
            bulkRequest.add(updateRequest);
        }
        bulkRequest.execute().actionGet();
    }

    public void batchUpdateStocks(List<PsProductVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (PsProductVO vo : list) {
            if (this.byId(vo.getId() + "") == null) {
                this.log.warn("productId:{} ES\u6ca1\u6709\u67e5\u5230", (Object)vo.getId());
                return;
            }
            HashMap<String, Object> sourceMap = new HashMap<String, Object>();
            sourceMap.put("stocks", vo.getStocks());
            if (vo.getListPrice() != null) {
                sourceMap.put("listPrice", vo.getListPrice().doubleValue());
            }
            if (vo.getListPriceSkuCode() != null) {
                sourceMap.put("listPriceSkuCode", vo.getListPriceSkuCode());
            }
            if (vo.getListPriceSpvId() != null) {
                sourceMap.put("listPriceSpvId", vo.getListPriceSpvId());
            }
            sourceMap.put("listPriceList", vo.getListPriceList());
            UpdateRequest updateRequest = this.getUpdateRequest(vo.getId() + "", sourceMap);
            bulkRequest.add(updateRequest);
        }
        bulkRequest.execute().actionGet();
    }

    public void batchUpdateCampaign(List<PsProductVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (PsProductVO vo : list) {
            if (this.byId(vo.getId() + "") == null) {
                this.log.warn("productId:{} ES\u6ca1\u6709\u67e5\u5230", (Object)vo.getId());
                continue;
            }
            HashMap<String, List<Map>> sourceMap = new HashMap<String, List<Map>>();
            if (vo.getCampaignList() == null) continue;
            List<Map> campaignList = this.toListMap(vo.getCampaignList());
            sourceMap.put("campaignList", campaignList);
            UpdateRequest updateRequest = this.getUpdateRequest(vo.getId() + "", sourceMap);
            bulkRequest.add(updateRequest);
        }
        bulkRequest.execute().actionGet();
    }

    public void updateSaleStartDate(String productId, Date saleStartDate) {
        HashMap<String, Date> sourceMap = new HashMap<String, Date>();
        sourceMap.put("saleStartDate", saleStartDate);
        this.client.prepareBulk().add(this.getUpdateRequest(productId, sourceMap)).execute();
    }

    @Override
    public PsProductVO toBean(Map<String, Object> sourceMap) {
        List listMap;
        if (MapUtils.isEmpty(sourceMap)) {
            return null;
        }
        PsProductVO productEsVO = new PsProductVO();
        productEsVO.setId(MapUtils.getString(sourceMap, (Object)"id"));
        productEsVO.setCode(MapUtils.getString(sourceMap, (Object)"code"));
        String listPrice = MapUtils.getString(sourceMap, (Object)"listPrice");
        if (StringUtils.isNotBlank((CharSequence)listPrice)) {
            productEsVO.setListPrice(new BigDecimal(listPrice));
        }
        productEsVO.setAllowVipDiscount(MapUtils.getInteger(sourceMap, (Object)"allowVipDiscount"));
        productEsVO.setAllowBdDiscount(MapUtils.getInteger(sourceMap, (Object)"allowBdDiscount"));
        productEsVO.setAllowNoteCard(MapUtils.getInteger(sourceMap, (Object)"allowNoteCard"));
        productEsVO.setPrepareDays(MapUtils.getInteger(sourceMap, (Object)"prepareDays"));
        productEsVO.setSelectDeliveryDays(MapUtils.getInteger(sourceMap, (Object)"selectDeliveryDays"));
        productEsVO.setPicList(MapUtils.getString(sourceMap, (Object)"picList"));
        productEsVO.setPicDetail(MapUtils.getString(sourceMap, (Object)"picDetail"));
        productEsVO.setPicThumb(MapUtils.getString(sourceMap, (Object)"picThumb"));
        productEsVO.setPicDetailMul(MapUtils.getString(sourceMap, (Object)"picDetailMul"));
        productEsVO.setExpressType(MapUtils.getInteger(sourceMap, (Object)"expressType", (Integer)3));
        productEsVO.setName(MapUtils.getString(sourceMap, (Object)"name"));
        productEsVO.setNameCn(MapUtils.getString(sourceMap, (Object)"nameCn"));
        productEsVO.setSkuCategoryDesc(MapUtils.getString(sourceMap, (Object)"skuCategoryDesc"));
        productEsVO.setCategoryId(Long.valueOf(MapUtils.getLongValue(sourceMap, (Object)"categoryId")));
        productEsVO.setCategoryCode(MapUtils.getString(sourceMap, (Object)"categoryCode", (String)""));
        productEsVO.setSeq(MapUtils.getInteger(sourceMap, (Object)"seq"));
        productEsVO.setSort1(MapUtils.getInteger(sourceMap, (Object)"sort1"));
        productEsVO.setSort2(MapUtils.getInteger(sourceMap, (Object)"sort2"));
        productEsVO.setDescription(MapUtils.getString(sourceMap, (Object)"description"));
        productEsVO.setCrossBorderFlag(MapUtils.getInteger(sourceMap, (Object)"crossBorderFlag"));
        String saleStartDateString = MapUtils.getString(sourceMap, (Object)"saleStartDate");
        if (StringUtils.isNotBlank((CharSequence)saleStartDateString)) {
            Date saleStartDate = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parseDateTime(saleStartDateString).plusHours(8).toDate();
            productEsVO.setSaleStartDate(saleStartDate);
        }
        productEsVO.setUpdateTime(MapUtils.getString(sourceMap, (Object)"updateTime"));
        productEsVO.setUpdateLong(MapUtils.getString(sourceMap, (Object)"updateLong"));
        productEsVO.setSkuCodes((List)sourceMap.get("skuCodes"));
        productEsVO.setSmallIconList((List)sourceMap.get("smallIconList"));
        productEsVO.setLargeIconList((List)sourceMap.get("largeIconList"));
        productEsVO.setChnSaleChnCodes((List)sourceMap.get("chnSaleChnCodes"));
        productEsVO.setOnShelfChnCodes((List)sourceMap.get("onShelfChnCodes"));
        productEsVO.setOffShelfChnCodes((List)sourceMap.get("offShelfChnCodes"));
        productEsVO.setFrontCategories((List)sourceMap.get("frontCategories"));
        productEsVO.setStocks((List)sourceMap.get("stocks"));
        List psTags = this.toListBean(sourceMap, "psTags", PsTagVO.class);
        productEsVO.setPsTags(psTags);
        List selfDeliveries = this.toListBean(sourceMap, "selfDeliveries", PsDeliveryVO.class);
        productEsVO.setSelfDeliveries(selfDeliveries);
        List dynmContents = this.toListBean(sourceMap, "dynmContents", PsDynmContentVO.class);
        productEsVO.setDynmContents(dynmContents);
        productEsVO.setChnCanSaleSKu(this.toListBean(sourceMap, "chnCanSaleSKu", PsChnProdSaleSku.class));
        productEsVO.setChnCanSeeSKu(this.toListBean(sourceMap, "chnCanSeeSKu", PsChnProdSaleSku.class));
        productEsVO.setBrandList(this.toListBean(sourceMap, "brandList", PsBrandVO.class));
        productEsVO.setLabels((List)sourceMap.get("labels"));
        productEsVO.setAttributeList(this.toListBean(sourceMap, "attributeList", PsAttributeVO.class));
        productEsVO.setSpvList(this.toListBean(sourceMap, "spvList", PsSpvVO.class));
        Object channelProdInfoObj = sourceMap.get("channelProdInfo");
        if (channelProdInfoObj != null && CollectionUtils.isNotEmpty((Collection)(listMap = (List)channelProdInfoObj))) {
            ArrayList<PsChnProdTimeCodeInfo> channelProdInfo = new ArrayList<PsChnProdTimeCodeInfo>();
            for (Map map : listMap) {
                String channelCode = MapUtils.getString((Map)map, (Object)"channelCode");
                if (StringUtils.isBlank((CharSequence)channelCode)) continue;
                String creatTimeString = MapUtils.getString((Map)map, (Object)"createTime");
                Date creatTime = null;
                if (StringUtils.isNotBlank((CharSequence)creatTimeString)) {
                    creatTime = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parseDateTime(creatTimeString).plusHours(8).toDate();
                }
                channelProdInfo.add(new PsChnProdTimeCodeInfo(channelCode, creatTime));
            }
            productEsVO.setChannelProdInfo(channelProdInfo);
        }
        return productEsVO;
    }

    @Override
    public Map<String, Object> toMap(PsProductVO vo) {
        Date saleStartDate;
        LinkedHashMap<String, Object> sourceMap = new LinkedHashMap<String, Object>();
        sourceMap.put("id", vo.getId());
        sourceMap.put("prodId", vo.getId());
        sourceMap.put("code", vo.getCode());
        sourceMap.put("combined", vo.getCombined() == null ? 0 : vo.getCombined());
        BigDecimal listPrice = vo.getListPrice();
        if (listPrice != null) {
            sourceMap.put("listPrice", listPrice.doubleValue());
        }
        if (vo.getListPriceSkuCode() != null) {
            sourceMap.put("listPriceSkuCode", vo.getListPriceSkuCode());
        }
        if (vo.getListPriceSpvId() != null) {
            sourceMap.put("listPriceSpvId", vo.getListPriceSpvId());
        }
        sourceMap.put("listPriceList", vo.getListPriceList());
        sourceMap.put("allowVipDiscount", vo.getAllowVipDiscount());
        sourceMap.put("allowBdDiscount", vo.getAllowBdDiscount());
        sourceMap.put("allowNoteCard", vo.getAllowNoteCard());
        sourceMap.put("prepareDays", vo.getPrepareDays());
        sourceMap.put("selectDeliveryDays", vo.getSelectDeliveryDays());
        sourceMap.put("picList", vo.getPicList());
        sourceMap.put("picDetail", vo.getPicDetail());
        sourceMap.put("picThumb", vo.getPicThumb());
        sourceMap.put("picDetailMul", vo.getPicDetailMul());
        sourceMap.put("expressType", vo.getExpressType());
        sourceMap.put("name", vo.getName());
        sourceMap.put("nameCn", vo.getNameCn());
        if (vo.getSkuCategoryDesc() != null) {
            sourceMap.put("skuCategoryDesc", vo.getSkuCategoryDesc());
        }
        sourceMap.put("categoryId", vo.getCategoryId());
        sourceMap.put("categoryCode", vo.getCategoryCode());
        sourceMap.put("seq", vo.getSeq());
        sourceMap.put("sort1", vo.getSort1());
        sourceMap.put("sort2", vo.getSort2());
        sourceMap.put("description", vo.getDescription());
        if (vo.getPrimaryUpdateTime() != null) {
            sourceMap.put("primaryUpdateTime", vo.getPrimaryUpdateTime());
        }
        if (vo.getPrimaryUpdateLong() != null) {
            sourceMap.put("primaryUpdateLong", vo.getPrimaryUpdateLong());
        }
        if ((saleStartDate = vo.getSaleStartDate()) != null) {
            sourceMap.put("saleStartDate", saleStartDate);
        }
        sourceMap.put("crossBorderFlag", vo.getCrossBorderFlag());
        sourceMap.put("skuCodes", vo.getSkuCodes());
        sourceMap.put("smallIconList", vo.getSmallIconList());
        sourceMap.put("largeIconList", vo.getLargeIconList());
        sourceMap.put("chnSaleChnCodes", vo.getChnSaleChnCodes());
        sourceMap.put("onShelfChnCodes", vo.getOnShelfChnCodes());
        sourceMap.put("offShelfChnCodes", vo.getOffShelfChnCodes());
        sourceMap.put("frontCategories", vo.getFrontCategories());
        sourceMap.put("stocks", vo.getStocks());
        sourceMap.put("psTags", this.toListMap(vo.getPsTags()));
        sourceMap.put("selfDeliveries", this.toListMap(vo.getSelfDeliveries()));
        sourceMap.put("dynmContents", this.toListMap(vo.getDynmContents()));
        sourceMap.put("chnCanSaleSKu", this.toListMap(vo.getChnCanSaleSKu()));
        sourceMap.put("chnCanSeeSKu", this.toListMap(vo.getChnCanSeeSKu()));
        sourceMap.put("brandList", vo.getBrandList());
        sourceMap.put("channelProdInfo", this.toListMap(vo.getChannelProdInfo()));
        sourceMap.put("labels", vo.getLabels());
        sourceMap.put("attributeList", this.toListMap(vo.getAttributeList()));
        sourceMap.put("campaignList", this.toListMap(vo.getCampaignList()));
        sourceMap.put("spvList", this.toListMap(vo.getSpvList()));
        sourceMap.put("isMonthSend", vo.getIsMonthSend());
        sourceMap.put("isDiscount", vo.getIsDiscount());
        sourceMap.put("video", vo.getVideo());
        sourceMap.put("videoCover", vo.getVideoCover());
        return sourceMap;
    }
}

