/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.es.dao.core;

import com.thebeastshop.es.annotation.EsDaoConfig;
import com.thebeastshop.es.spring.ElasticsearchFactoryBean;
import com.thebeastshop.scm.es.PsUpdateVO;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.joda.time.DateTime;
import org.elasticsearch.common.lang3.StringUtils;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import pers.richard.ormybatis.domain.core.AbstractDomain;

public class AbstractEsDao<T extends PsUpdateVO> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected String host;
    protected int port;
    protected String index;
    protected String type;
    protected String id;
    protected TransportClient client = new TransportClient();

    public AbstractEsDao(ElasticsearchFactoryBean elasticsearchFactoryBean) {
        Annotation annotation = AnnotationUtils.findAnnotation(this.getClass(), EsDaoConfig.class);
        this.index = (String)AnnotationUtils.getValue((Annotation)annotation, (String)"index");
        this.id = (String)AnnotationUtils.getValue((Annotation)annotation, (String)"id");
        if (StringUtils.isBlank((CharSequence)this.index)) {
            this.index = elasticsearchFactoryBean.getIndex();
        }
        this.type = (String)AnnotationUtils.getValue((Annotation)annotation, (String)"type");
        InetSocketTransportAddress netSocketTransportAddress = elasticsearchFactoryBean.getNetSocketTransportAddress();
        this.client.addTransportAddress((TransportAddress)netSocketTransportAddress);
    }

    public T byId(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        GetResponse responseGet = (GetResponse)this.client.prepareGet(this.index, this.type, id).execute().actionGet();
        Map sourceMap = responseGet.getSourceAsMap();
        return this.toBean(sourceMap);
    }

    public IndexResponse insertOrUpdate(T vo) {
        Map<String, Object> sourceMap = this.toMap(vo);
        String id = MapUtils.getString(sourceMap, (Object)this.id);
        IndexRequest indexRequest = this.getIndexRequest(id, sourceMap);
        return (IndexResponse)this.client.index(indexRequest).actionGet();
    }

    public BulkResponse insertOrUpdate(Collection<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (PsUpdateVO t : list) {
            Map<String, Object> sourceMap = this.toMap(t);
            String id = MapUtils.getString(sourceMap, (Object)this.id);
            if (this.byId(id) == null) {
                IndexRequest indexRequest = this.getIndexRequest(id, sourceMap);
                bulkRequest.add(indexRequest);
                continue;
            }
            UpdateRequest updateRequest = this.getUpdateRequest(id, sourceMap);
            bulkRequest.add(updateRequest);
        }
        return (BulkResponse)bulkRequest.execute().actionGet();
    }

    public UpdateResponse update(T vo) {
        Map<String, Object> sourceMap = this.toMap(vo);
        String id = MapUtils.getString(sourceMap, (Object)this.id);
        UpdateRequest updateRequest = this.getUpdateRequest(id, sourceMap);
        return (UpdateResponse)this.client.update(updateRequest).actionGet();
    }

    public BulkResponse update(Collection<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (PsUpdateVO t : list) {
            Map<String, Object> sourceMap = this.toMap(t);
            String id = MapUtils.getString(sourceMap, (Object)this.id);
            UpdateRequest ur = this.getUpdateRequest(id, sourceMap);
            bulkRequest.add(ur);
        }
        return (BulkResponse)bulkRequest.execute().actionGet();
    }

    public DeleteResponse delete(String id) {
        DeleteRequest deleteRequest = this.getDeleteRequest(id);
        return (DeleteResponse)this.client.delete(deleteRequest).actionGet();
    }

    public BulkResponse delete(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (String id : list) {
            DeleteRequest deleteRequest = this.getDeleteRequest(id);
            bulkRequest.add(deleteRequest);
        }
        return (BulkResponse)bulkRequest.execute().actionGet();
    }

    public T toBean(Map<String, Object> sourceMap) {
        if (MapUtils.isEmpty(sourceMap)) {
            return null;
        }
        PsUpdateVO vo = null;
        try {
            vo = (PsUpdateVO)this.getClz().newInstance();
            BeanUtils.populate((Object)vo, sourceMap);
        }
        catch (Exception e) {
            this.log.error(null, (Throwable)e);
        }
        return (T)vo;
    }

    public Map<String, Object> toMap(T t) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors = Introspector.getBeanInfo(this.getClz()).getPropertyDescriptors();
            int n = propertyDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                Method readMethod;
                Object result;
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
                String propertyName = propertyDescriptor.getName();
                if (!("class".equals(propertyName) || (result = (readMethod = propertyDescriptor.getReadMethod()).invoke(t, new Object[0])) == null || result instanceof Collection && CollectionUtils.isEmpty((Collection)((Collection)result)) || result instanceof Map && MapUtils.isEmpty((Map)((Map)result)))) {
                    map.put(propertyName, result);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            this.log.error(null, (Throwable)e);
        }
        return map;
    }

    protected UpdateRequest getUpdateRequest(String id, Map sourceMap) {
        DateTime now = DateTime.now();
        sourceMap.put("updateTime", now.toString("yyyy-MM-dd HH:mm:ss"));
        sourceMap.put("updateLong", now.getMillis());
        return new UpdateRequest(this.index, this.type, id).doc(sourceMap);
    }

    protected IndexRequest getIndexRequest(String id, Map sourceMap) {
        DateTime now = DateTime.now();
        sourceMap.put("updateTime", now.toString("yyyy-MM-dd HH:mm:ss"));
        sourceMap.put("updateLong", now.getMillis());
        return new IndexRequest(this.index, this.type, id).source(sourceMap);
    }

    protected DeleteRequest getDeleteRequest(String id) {
        return new DeleteRequest(this.index, this.type, id);
    }

    public List toListBean(Object listMapObj, Class clz) {
        if (listMapObj == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        if (listMapObj instanceof List) {
            List listMap = (List)listMapObj;
            for (Map map : listMap) {
                try {
                    Object o = clz.newInstance();
                    BeanUtils.populate(o, (Map)map);
                    result.add(o);
                }
                catch (Exception e) {
                    this.log.error(null, (Throwable)e);
                }
            }
        }
        return result;
    }

    public List toListBean(Map sourceMap, String key, Class clz) {
        Collection list = (Collection)MapUtils.getObject((Map)sourceMap, (Object)key, (Object)Collections.EMPTY_LIST);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList listBean = new ArrayList();
        if (list instanceof List) {
            List listMap = (List)list;
            for (Map map : listMap) {
                try {
                    Object o = clz.newInstance();
                    BeanUtils.populate(o, (Map)map);
                    listBean.add(o);
                }
                catch (Exception e) {
                    this.log.error(null, (Throwable)e);
                }
            }
        }
        return listBean;
    }

    public List<Map> toListMap(List listBean) {
        ArrayList<Map> result = new ArrayList<Map>();
        if (CollectionUtils.isNotEmpty((Collection)listBean)) {
            for (Object obj : listBean) {
                if (!(obj instanceof AbstractDomain)) continue;
                AbstractDomain abstractDomain = (AbstractDomain)obj;
                result.add(abstractDomain.toMap());
            }
        }
        return result;
    }

    private Class<T> getClz() {
        Type type = this.getClass().getGenericSuperclass();
        Type[] p = ((ParameterizedType)type).getActualTypeArguments();
        Class clz = (Class)p[0];
        return clz;
    }
}

