package com.thebeastshop.es.dao;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.update.UpdateRequest;
import org.springframework.beans.factory.annotation.Autowired;

import com.thebeastshop.es.annotation.EsDaoConfig;
import com.thebeastshop.es.dao.core.AbstractEsDao;
import com.thebeastshop.es.spring.ElasticsearchFactoryBean;
import com.thebeastshop.scm.es.PcsSkuCategoryVO;
import com.thebeastshop.scm.es.PsSkuVO;

@EsDaoConfig(id = "skuCode", type = "pubsku")
public class SkuEsDao extends AbstractEsDao<PsSkuVO> {

	@Autowired
	public SkuEsDao(ElasticsearchFactoryBean elasticsearchFactoryBean) {
		super(elasticsearchFactoryBean);
	}

	public void updateSupplier(List<Map> supplierMapList) {
		for (Map supplierMap : supplierMapList) {
			String id = MapUtils.getString(supplierMap, "skuCode");
			UpdateRequest updateRequest = this.getUpdateRequest(id, supplierMap);
			client.update(updateRequest).actionGet();
		}
	}
	public void updateCategory(List<Map> categoryMapList) {
		if (CollectionUtils.isEmpty(categoryMapList)) {
			return;
		}
		BulkRequestBuilder bulkRequest = client.prepareBulk();
		for (Map brandMap : categoryMapList) {
			String id = MapUtils.getString(brandMap, "skuCode");
			UpdateRequest updateRequest = this.getUpdateRequest(id, brandMap);
			bulkRequest.add(updateRequest);
		}
		bulkRequest.execute().actionGet();
	}
	
	public void updateBrand(List<Map> brandList) {
		if (CollectionUtils.isEmpty(brandList)) {
			return;
		}
		BulkRequestBuilder bulkRequest = client.prepareBulk();
		for (Map brandMap : brandList) {
			String id = MapUtils.getString(brandMap, "skuCode");
			UpdateRequest updateRequest = this.getUpdateRequest(id, brandMap);
			bulkRequest.add(updateRequest);
		}
		bulkRequest.execute().actionGet();
	}	
	
	@Override
	public PsSkuVO toBean(Map<String, Object> sourceMap) {
		if (MapUtils.isEmpty(sourceMap)) {
			return null;
		}
		PsSkuVO skuVO = new PsSkuVO();
		skuVO.setId(MapUtils.getString(sourceMap, "id"));
		skuVO.setSkuId(MapUtils.getLongValue(sourceMap, "skuId"));
		skuVO.setSkuCode(MapUtils.getString(sourceMap, "skuCode"));
		skuVO.setSkuName(MapUtils.getString(sourceMap, "skuName"));
		skuVO.setSkuNameCN(MapUtils.getString(sourceMap, "skuNameCN"));
		skuVO.setSkuType(MapUtils.getInteger(sourceMap, "skuType"));
		skuVO.setIsMadeBySelf(MapUtils.getInteger(sourceMap, "isMadeBySelf"));
		skuVO.setIsImported(MapUtils.getInteger(sourceMap, "isImported"));
		
		skuVO.setSkuCustomMadeCode(MapUtils.getString(sourceMap, "skuCustomMadeCode"));
		skuVO.setIsSkuCustomMade(MapUtils.getInteger(sourceMap, "isSkuCustomMade"));
		
		skuVO.setCombinedSkuRecipeCode(MapUtils.getString(sourceMap, "combinedSkuRecipeCode"));
		skuVO.setIsCombinedSkuRecipeCode(MapUtils.getInteger(sourceMap, "isCombinedSkuRecipeCode"));
		
		skuVO.setIsJit(MapUtils.getInteger(sourceMap, "isJit"));
		skuVO.setEan13(MapUtils.getString(sourceMap, "ean13"));
		skuVO.setBarcode(MapUtils.getString(sourceMap, "barcode"));
		skuVO.setCanPurchase(MapUtils.getInteger(sourceMap, "canPurchase"));
		skuVO.setCostPrice(new BigDecimal(MapUtils.getDoubleValue(sourceMap, "costPrice")));
		skuVO.setSalesPrice(MapUtils.getDouble(sourceMap, "salesPrice"));
		skuVO.setCategoryId(MapUtils.getLongValue(sourceMap, "categoryId"));
		skuVO.setCategoryName(MapUtils.getString(sourceMap, "categoryName"));
		skuVO.setBrandId(MapUtils.getLongValue(sourceMap, "brandId"));
		skuVO.setBrandName(MapUtils.getString(sourceMap, "brandName"));
		skuVO.setBrandNameCN(MapUtils.getString(sourceMap, "brandNameCN"));
		skuVO.setBrandCountryId(MapUtils.getLong(sourceMap, "brandCountryId"));
		skuVO.setBrandCountryName(MapUtils.getString(sourceMap, "brandCountryName"));
		skuVO.setPlaceOfOrigin(MapUtils.getString(sourceMap, "placeOfOrigin"));
		skuVO.setSupplierId(MapUtils.getLongValue(sourceMap, "supplierId"));
		skuVO.setSupplierName(MapUtils.getString(sourceMap, "supplierName"));
		skuVO.setSupplierNameCN(MapUtils.getString(sourceMap, "supplierNameCN"));
		skuVO.setSkuCategoryName(MapUtils.getString(sourceMap, "skuCategoryName"));
		skuVO.setCanRemark(MapUtils.getInteger(sourceMap, "canRemark"));
		skuVO.setPointDeductRule(MapUtils.getInteger(sourceMap, "pointDeductRule"));
		skuVO.setPointDeductPoint(new BigDecimal(MapUtils.getDoubleValue(sourceMap, "pointDeductPoint")));
		skuVO.setPointDuductPrice(new BigDecimal(MapUtils.getDoubleValue(sourceMap, "pointDuductPrice")));
		skuVO.setCrossBorderFlag(MapUtils.getInteger(sourceMap, "crossBorderFlag"));
		skuVO.setWeight(MapUtils.getString(sourceMap, "weight"));
		skuVO.setTaxNo(MapUtils.getString(sourceMap, "taxNo"));
		skuVO.setWhetherConsignment(MapUtils.getIntValue(sourceMap, "whetherConsignment"));
		skuVO.setClearanceWay(MapUtils.getInteger(sourceMap, "clearanceWay"));
		skuVO.setUpdateTime(MapUtils.getString(sourceMap, "updateTime"));
		skuVO.setUpdateLong(MapUtils.getString(sourceMap, "updateLong"));
		
		skuVO.setFrontCategoryList(this.toListBean(sourceMap, "frontCategoryList", PcsSkuCategoryVO.class));
		return skuVO;
	}
	
	
	@Override
	public Map<String, Object> toMap(PsSkuVO vo) {
		Map<String, Object> sourceMap = new LinkedHashMap<String, Object>();
		sourceMap.put("id", vo.getId());
		sourceMap.put("skuId", vo.getSkuId());
	    sourceMap.put("skuCode", vo.getSkuCode());
	    sourceMap.put("skuName", vo.getSkuName());
	    sourceMap.put("skuNameCN", vo.getSkuNameCN());
	    sourceMap.put("skuType", vo.getSkuType());
	    sourceMap.put("isMadeBySelf", vo.getIsMadeBySelf());
	    sourceMap.put("isImported", vo.getIsImported());
	    
	    sourceMap.put("skuCustomMadeCode", vo.getSkuCustomMadeCode());
	    sourceMap.put("isSkuCustomMade", StringUtils.isBlank(vo.getSkuCustomMadeCode()) ? 0 : 1);
		
	    sourceMap.put("combinedSkuRecipeCode", vo.getCombinedSkuRecipeCode());
	    sourceMap.put("isCombinedSkuRecipeCode", StringUtils.isBlank(vo.getCombinedSkuRecipeCode()) ? 0 : 1);
	    
	    sourceMap.put("isJit", vo.getIsJit());
	    sourceMap.put("ean13", vo.getEan13());
	    sourceMap.put("barcode", vo.getBarcode());
	    sourceMap.put("canPurchase", vo.getCanPurchase());
	    sourceMap.put("costPrice", vo.getCostPrice());  
	    sourceMap.put("salesPrice", vo.getSalesPrice());
	    sourceMap.put("categoryId", vo.getCategoryId());
	    sourceMap.put("categoryName", vo.getCategoryName());
	    sourceMap.put("brandId", vo.getBrandId());
	    sourceMap.put("brandName", vo.getBrandName());
	    sourceMap.put("brandNameCN", vo.getBrandNameCN());
	    sourceMap.put("brandCountryId", vo.getBrandCountryId());
	    sourceMap.put("brandCountryName", vo.getBrandCountryName());
	    sourceMap.put("placeOfOrigin", vo.getPlaceOfOrigin());
	    sourceMap.put("supplierId", vo.getSupplierId());
	    sourceMap.put("supplierName", vo.getSupplierName());
	    sourceMap.put("supplierNameCN", vo.getSupplierNameCN());
	    sourceMap.put("skuCategoryName", vo.getSkuCategoryName());
	    sourceMap.put("canRemark", vo.getCanRemark());
	    sourceMap.put("pointDeductRule", vo.getPointDeductRule());
	    sourceMap.put("pointDeductPoint", vo.getPointDeductPoint());
	    sourceMap.put("pointDuductPrice", vo.getPointDuductPrice());
	    sourceMap.put("crossBorderFlag", vo.getCrossBorderFlag());
		sourceMap.put("weight", vo.getWeight());
		sourceMap.put("taxNo", vo.getTaxNo());
		sourceMap.put("discountPrice", vo.getDiscountPrice());
		sourceMap.put("whetherConsignment", vo.getWhetherConsignment());
		sourceMap.put("clearanceWay", vo.getClearanceWay());
		sourceMap.put("frontCategoryList", this.toListMap(vo.getFrontCategoryList()));
		return sourceMap;
	}

}