package com.thebeastshop.dx.adapt;

import org.apache.dubbo.config.ReferenceConfig;

import java.util.HashMap;
import java.util.Map;

public class DubboReferenceUtil {

    private static final Map<String, Object> referenceCacheMap = new HashMap<>();

    public static <T> T getReference(Class<T> clazz){
        if (referenceCacheMap.containsKey(clazz.getName())){
            return (T)referenceCacheMap.get(clazz.getName());
        }else{
            ReferenceConfig<T> reference = new ReferenceConfig<>();
            reference.setInterface(clazz);
            T t = reference.get();
            referenceCacheMap.put(clazz.getName(), t);
            return t;
        }
    }
}
