/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.wms.dataProps;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.common.utils.EmptyUtil;
import com.thebeastshop.common.utils.NullUtil;
import com.thebeastshop.wms.dataProps.DataColumn;
import com.thebeastshop.wms.dataProps.RowData;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.core.ResolvableType;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

@Deprecated
public class DataPropHelperV1 {
    private static final SimpleTypeConverter simpleTypeConverter = new SimpleTypeConverter();
    private static final Logger log = LoggerFactory.getLogger(DataPropHelperV1.class);

    public static <T> List<DataItem> extract(T data) {
        if (data == null) {
            return new ArrayList<DataItem>();
        }
        IdGenerator idGenerator = new IdGenerator();
        int id = idGenerator.next();
        List<DataItem> propColItemList = DataPropHelperV1.doExtract(data, idGenerator);
        log.info("extract propColItemList : {}", (Object)JSON.toJSONString(propColItemList));
        ArrayList flatColItemList = new ArrayList();
        propColItemList.forEach(colItem -> {
            ((DataItem)colItem).parentDataId = id;
            flatColItemList.addAll(DataPropHelperV1.getSubColItems(colItem));
        });
        log.info("extract flatColItemList : {}", (Object)JSON.toJSONString(flatColItemList));
        return flatColItemList.stream().filter(item -> EmptyUtil.isNotEmpty((String)item.getConfigValue())).collect(Collectors.toList());
    }

    public static <T> void merge(T data, List<DataItem> flatColItemList) {
        if (NullUtil.isNull(data) || EmptyUtil.isEmpty(flatColItemList)) {
            return;
        }
        log.info("merge flatColItemList : {}", (Object)JSON.toJSONString(flatColItemList));
        List<DataItem> propColItemList = DataPropHelperV1.toTree(flatColItemList);
        log.info("merge propColItemList : {}", (Object)JSON.toJSONString(propColItemList));
        DataPropHelperV1.doMerge(data, propColItemList);
    }

    private static <T> void doMerge(T data, List<DataItem> propColItemList) {
        Map propColItemMap = propColItemList.stream().collect(Collectors.toMap(DataItem::getDataPath, Function.identity()));
        ReflectionUtils.doWithFields(data.getClass(), field -> {
            DataColumn dataColumnAnnotation = field.getAnnotation(DataColumn.class);
            if (dataColumnAnnotation == null) {
                return;
            }
            ReflectionUtils.makeAccessible((Field)field);
            ResolvableType resolvableType = ResolvableType.forField((Field)field);
            Class fieldType = resolvableType.getRawClass();
            String dataPropCode = dataColumnAnnotation.value() != null && !"".equals(dataColumnAnnotation.value()) ? dataColumnAnnotation.value() : field.getName();
            DataItem colItem = (DataItem)propColItemMap.get(dataPropCode);
            if (NullUtil.isNull((Object)colItem)) {
                return;
            }
            if (ClassUtils.isAssignable(Collection.class, (Class)fieldType)) {
                if (EmptyUtil.isNotEmpty((List)colItem.subItemList)) {
                    Collection list = DataPropHelperV1.instanceCollection(fieldType);
                    Class elementType = resolvableType.getGeneric(new int[]{0}).getRawClass();
                    if (DataPropHelperV1.dataAnnotation(elementType)) {
                        Map containerItemColItemMap = colItem.subItemList.stream().collect(Collectors.toMap(DataItem::getDataId, Function.identity()));
                        containerItemColItemMap.forEach((id, containerItem) -> {
                            Object elementData = DataPropHelperV1.newInstance(elementType);
                            if (elementData != null) {
                                DataPropHelperV1.doMerge(elementData, ((DataItem)containerItem).subItemList);
                                list.add(elementData);
                            }
                        });
                    } else {
                        colItem.subItemList.forEach(subItem -> list.add(DataPropHelperV1.convert(((DataItem)subItem).configValue, elementType)));
                    }
                    ReflectionUtils.setField((Field)field, (Object)data, list);
                }
            } else if (DataPropHelperV1.dataAnnotation(fieldType)) {
                if (EmptyUtil.isNotEmpty((List)colItem.subItemList)) {
                    Object filedData = DataPropHelperV1.newInstance(fieldType);
                    DataPropHelperV1.doMerge(filedData, colItem.subItemList);
                    ReflectionUtils.setField((Field)field, (Object)data, filedData);
                }
            } else {
                ReflectionUtils.setField((Field)field, (Object)data, DataPropHelperV1.convert(colItem.configValue, fieldType));
            }
        });
    }

    private static <T> List<DataItem> doExtract(T data, IdGenerator idGenerator) {
        if (data == null) {
            return new ArrayList<DataItem>();
        }
        ArrayList<DataItem> colItemList = new ArrayList<DataItem>();
        ReflectionUtils.doWithFields(data.getClass(), field -> {
            DataColumn dataColumnAnnotation = field.getAnnotation(DataColumn.class);
            if (dataColumnAnnotation == null) {
                return;
            }
            ReflectionUtils.makeAccessible((Field)field);
            Object fieldValue = ReflectionUtils.getField((Field)field, (Object)data);
            if (fieldValue == null) {
                return;
            }
            String propCode = dataColumnAnnotation.value() != null && !"".equals(dataColumnAnnotation.value()) ? dataColumnAnnotation.value() : field.getName();
            ResolvableType resolvableType = ResolvableType.forField((Field)field);
            Class fieldType = resolvableType.getRawClass();
            if (fieldValue instanceof Iterable) {
                String configType = propCode;
                Class elementType = resolvableType.getGeneric(new int[]{0}).getRawClass();
                Iterable collection = (Iterable)fieldValue;
                DataItem container = new DataItem();
                container.dataId = idGenerator.next();
                container.configType = String.format("%s_Collection", configType);
                container.configDesc = dataColumnAnnotation.name();
                container.configValue = "L[placeholder]";
                container.dataPath = propCode;
                container.subItemList = new ArrayList();
                if (DataPropHelperV1.dataAnnotation(elementType)) {
                    collection.forEach(data_i -> {
                        DataItem containerItem = new DataItem();
                        containerItem.dataId = idGenerator.next();
                        containerItem.parentDataId = container.dataId;
                        containerItem.configType = String.format("%s_Obj", configType);
                        containerItem.configDesc = dataColumnAnnotation.name();
                        containerItem.configValue = "{placeholder}";
                        containerItem.dataPath = propCode;
                        containerItem.subItemList = DataPropHelperV1.doExtract(data_i, idGenerator);
                        containerItem.subItemList.forEach(item -> {
                            ((DataItem)item).parentDataId = containerItem.dataId;
                            ((DataItem)item).configType = DataPropHelperV1.buildCode(configType, ((DataItem)item).configType);
                        });
                        container.subItemList.add(containerItem);
                    });
                } else {
                    collection.forEach(data_i -> {
                        DataItem containerItem = new DataItem();
                        containerItem.dataId = idGenerator.next();
                        containerItem.parentDataId = container.dataId;
                        containerItem.configType = configType;
                        containerItem.configDesc = dataColumnAnnotation.name();
                        containerItem.configValue = data_i.toString();
                        containerItem.dataPath = propCode;
                        container.subItemList.add(containerItem);
                    });
                }
                if (!container.subItemList.isEmpty()) {
                    colItemList.add(container);
                }
            } else if (DataPropHelperV1.dataAnnotation(fieldType)) {
                DataItem colItem = new DataItem();
                colItem.dataId = idGenerator.next();
                colItem.configType = String.format("%s_Obj", propCode);
                colItem.configValue = "{placeholder}";
                colItem.configDesc = dataColumnAnnotation.name();
                colItem.subItemList = DataPropHelperV1.doExtract(fieldValue, idGenerator);
                colItem.subItemList.forEach(item -> {
                    ((DataItem)item).parentDataId = colItem.dataId;
                    ((DataItem)item).configType = DataPropHelperV1.buildCode(propCode, ((DataItem)item).configType);
                });
                colItem.dataPath = propCode;
                colItemList.add(colItem);
            } else {
                DataItem dataColItem = new DataItem();
                dataColItem.dataId = idGenerator.next();
                dataColItem.configType = propCode;
                dataColItem.configDesc = dataColumnAnnotation.name();
                dataColItem.configValue = fieldValue.toString();
                dataColItem.dataPath = propCode;
                colItemList.add(dataColItem);
            }
        });
        return colItemList;
    }

    private static List<DataItem> toTree(List<DataItem> flatColItemList) {
        Map<Integer, List<DataItem>> subColListMap = flatColItemList.stream().collect(Collectors.groupingBy(DataItem::getParentDataId));
        ArrayList<DataItem> propColItemList = new ArrayList<DataItem>();
        ((List)subColListMap.getOrDefault(0, new ArrayList())).forEach(colItem -> {
            DataPropHelperV1.buildChildren(colItem, subColListMap);
            propColItemList.add((DataItem)colItem);
        });
        return propColItemList;
    }

    private static void buildChildren(DataItem colItem, Map<Integer, List<DataItem>> subColListMap) {
        List<DataItem> children = subColListMap.get(colItem.getDataId());
        if (EmptyUtil.isEmpty(children)) {
            return;
        }
        children.forEach(item -> DataPropHelperV1.buildChildren(item, subColListMap));
        colItem.subItemList = children;
    }

    private static List<DataItem> getSubColItems(DataItem colItem) {
        ArrayList<DataItem> list = new ArrayList<DataItem>();
        list.add(colItem);
        if (EmptyUtil.isNotEmpty(colItem.getSubItemList())) {
            colItem.getSubItemList().forEach(colItem1 -> list.addAll(DataPropHelperV1.getSubColItems(colItem1)));
            colItem.setSubItemList(null);
        }
        return list;
    }

    private static String buildCode(String pcode, String code) {
        return pcode == null || "".equals(pcode) ? code : pcode + "." + code;
    }

    private static <T> T convert(String str, Class<T> clazz) {
        return (T)simpleTypeConverter.convertIfNecessary((Object)str, clazz);
    }

    private static <T> Collection<T> instanceCollection(Class<T> collectType) {
        if (collectType.isAssignableFrom(List.class)) {
            return new ArrayList();
        }
        if (collectType.isAssignableFrom(Set.class)) {
            return new HashSet();
        }
        return null;
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(ClassUtils.getQualifiedName(clazz) + " newInstance error");
        }
    }

    public static boolean dataAnnotation(Class<?> clazz) {
        RowData annotation = clazz.getAnnotation(RowData.class);
        return annotation != null;
    }

    private static class IdGenerator {
        private int code = 0;

        private IdGenerator() {
        }

        public int next() {
            return this.code++;
        }
    }

    public static class DataItem
    implements Serializable {
        private Integer dataId;
        private String configType;
        private String configDesc;
        private String configValue;
        private Integer parentDataId;
        private String dataPath;
        private List<DataItem> subItemList;

        public Integer getDataId() {
            return this.dataId;
        }

        public void setDataId(Integer dataId) {
            this.dataId = dataId;
        }

        public String getConfigType() {
            return this.configType;
        }

        public void setConfigType(String configType) {
            this.configType = configType;
        }

        public String getConfigDesc() {
            return this.configDesc;
        }

        public void setConfigDesc(String configDesc) {
            this.configDesc = configDesc;
        }

        public String getConfigValue() {
            return this.configValue;
        }

        public void setConfigValue(String configValue) {
            this.configValue = configValue;
        }

        public Integer getParentDataId() {
            return this.parentDataId;
        }

        public void setParentDataId(Integer parentDataId) {
            this.parentDataId = parentDataId;
        }

        public String getDataPath() {
            return this.dataPath;
        }

        public void setDataPath(String dataPath) {
            this.dataPath = dataPath;
        }

        public List<DataItem> getSubItemList() {
            return this.subItemList;
        }

        public void setSubItemList(List<DataItem> subItemList) {
            this.subItemList = subItemList;
        }
    }
}

